/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.AbstractEventAction;
import org.eclipse.stardust.model.xpdl.carnot.BindActionType;
import org.eclipse.stardust.model.xpdl.carnot.EventActionType;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.util.ActionTypeUtil;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.Validation_Messages;

public class ActionValidator
implements IModelElementValidator {
    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        if (element instanceof AbstractEventAction) {
            AbstractEventAction action = (AbstractEventAction)element;
            if (this.findDuplicateId(action)) {
                result.add(Issue.error((EObject)action, Validation_Messages.ERR_ACTIONTYPE_DuplicateId, ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
            }
            if (ActionTypeUtil.getActionType((IModelElement)action) == null) {
                result.add(Issue.error((EObject)action, Validation_Messages.ERR_ActionHasNoType, ValidationService.PKG_CWM.getIIdentifiableElement_Name()));
            }
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    private boolean findDuplicateId(AbstractEventAction eventAction) {
        EventHandlerType eventHandler = (EventHandlerType)eventAction.eContainer();
        EList abstractEventActions = eventAction instanceof EventActionType ? eventHandler.getEventAction() : (eventAction instanceof BindActionType ? eventHandler.getBindAction() : eventHandler.getUnbindAction());
        return this.findDuplicateId((List)abstractEventActions, eventAction);
    }

    private boolean findDuplicateId(List abstractEventActions, AbstractEventAction eventAction) {
        for (AbstractEventAction nextEventAction : abstractEventActions) {
            if (!nextEventAction.getId().equals(eventAction.getId()) || eventAction.equals(nextEventAction)) continue;
            return true;
        }
        return false;
    }
}

