/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.Validation_Messages;

public class ApplicationValidator
implements IModelElementValidator {
    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        ApplicationType application = (ApplicationType)element;
        if (this.findDuplicateId(application)) {
            result.add(Issue.error((EObject)application, Validation_Messages.ERR_APPLICATION_DuplicateId, ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
        }
        ValidationService vs = ValidationService.getInstance();
        result.addAll(Arrays.asList(vs.validateModelElements((List<?>)application.getContext())));
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    private boolean findDuplicateId(ApplicationType application) {
        ModelType model = ModelUtils.findContainingModel((EObject)application);
        if (model != null) {
            for (ApplicationType otherApplication : model.getApplication()) {
                if (!otherApplication.getId().equals(application.getId()) || application.equals(otherApplication)) continue;
                return true;
            }
        }
        return false;
    }
}

