/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.JoinSplitType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.SubProcessModeType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.XmlTextNode;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.LoopMultiInstanceType;
import org.eclipse.stardust.model.xpdl.xpdl2.LoopStandardType;
import org.eclipse.stardust.model.xpdl.xpdl2.LoopType;
import org.eclipse.stardust.model.xpdl.xpdl2.MIOrderingType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.extensions.ExtensionPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.util.XpdlUtil;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.Validation_Messages;

public class DefaultActivityValidator
implements IModelElementValidator {
    private static final int JOIN = 0;
    private static final int SPLIT = 1;

    protected boolean performFullCheck() {
        return true;
    }

    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        ActivityType activity = (ActivityType)element;
        if (this.findDuplicateId(activity)) {
            result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_DuplicateId, ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
        }
        if (this.performFullCheck()) {
            this.checkPerformer(result, activity);
            this.checkSubprocessActivity(result, activity);
            this.checkApplicationActivity(result, activity);
        }
        if ((activity.getJoin() == null || activity.getJoin().getValue() == 0) && this.hasMultipleTransitions(activity, 0)) {
            result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_MultipleIncomingTransitions, ValidationService.PKG_CWM.getTransitionType_To()));
        }
        if ((activity.getSplit() == null || activity.getSplit().getValue() == 0) && this.hasMultipleTransitions(activity, 1)) {
            result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_MultipleOutgoingTransitions, ValidationService.PKG_CWM.getTransitionType_From()));
        }
        this.validateLoop(result, activity, activity.getLoop());
        HashMap<ActivityType, Boolean> targetActivities = new HashMap<ActivityType, Boolean>();
        for (TransitionType transition : activity.getOutTransitions()) {
            if (transition.getTo() == null) continue;
            if (targetActivities.containsKey(transition.getTo())) {
                if (!Boolean.FALSE.equals(targetActivities.get(transition.getTo()))) continue;
                result.add(Issue.warning((EObject)activity, MessageFormat.format(Validation_Messages.ERR_ACTIVITY_MultipleTransitions, activity.getId(), transition.getTo().getId()), ValidationService.PKG_CWM.getActivityType_LoopCondition()));
                targetActivities.put(transition.getTo(), Boolean.TRUE);
                continue;
            }
            targetActivities.put(transition.getTo(), Boolean.FALSE);
        }
        ActivityType blockingActivity = this.checkXORANDBlock(activity, activity, new HashSet<ActivityType>());
        if (blockingActivity != null) {
            result.add(Issue.warning((EObject)activity, MessageFormat.format(Validation_Messages.Msg_XORSplitANDJoinBlock, activity.getName(), blockingActivity.getName()), ValidationService.PKG_CWM.getActivityType()));
        }
        ValidationService vs = ValidationService.getInstance();
        result.addAll(Arrays.asList(vs.validateModelElements((List<?>)activity.getDataMapping())));
        result.addAll(Arrays.asList(vs.validateModelElements((List<?>)activity.getEventHandler())));
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    private void validateLoop(List<Issue> result, ActivityType activity, LoopType loop) {
        if (loop == null) {
            this.validateOldStyleLoop(result, activity);
        } else {
            switch (loop.getLoopType()) {
                case STANDARD: {
                    this.validateLoopStandard(result, activity, loop.getLoopStandard());
                    break;
                }
                case MULTI_INSTANCE: {
                    this.validateLoopMulti(result, activity, loop.getLoopMultiInstance());
                    break;
                }
                default: {
                    result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_UndefinedStandardLoop, XpdlPackage.eINSTANCE.getLoopType_LoopType()));
                }
            }
        }
    }

    private void validateLoopMulti(List<Issue> result, ActivityType activity, LoopMultiInstanceType loopMulti) {
        if (loopMulti == null) {
            if (activity.getLoop().getLoopStandard() == null) {
                result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_UndefinedStandardLoop, XpdlPackage.eINSTANCE.getLoopType_LoopMultiInstance()));
            } else {
                result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_InvalidMultiInstanceLoop, XpdlPackage.eINSTANCE.getLoopType_LoopMultiInstance()));
            }
        } else {
            if (loopMulti.getMIOrdering() == null) {
                result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_NoMultiInstanceLoopOrderingType, XpdlPackage.eINSTANCE.getLoopMultiInstanceType_MIOrdering()));
            } else if (loopMulti.getMIOrdering() == MIOrderingType.PARALLEL && activity.getImplementation() == ActivityImplementationType.SUBPROCESS_LITERAL && activity.getSubProcessMode() == SubProcessModeType.SYNC_SHARED_LITERAL) {
                result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_IncompatibleSubProcessMode, ValidationService.PKG_CWM.getActivityType_SubProcessMode()));
            }
            if (loopMulti.getLoopDataRef() == null || StringUtils.isEmpty((String)loopMulti.getLoopDataRef().getInputItemRef())) {
                result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_NoInputLoopDataSpecified, ExtensionPackage.eINSTANCE.getLoopDataRefType_InputItemRef()));
            }
        }
    }

    private void validateLoopStandard(List<Issue> result, ActivityType activity, LoopStandardType loopStandard) {
        if (loopStandard == null) {
            if (activity.getLoop().getLoopMultiInstance() == null) {
                result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_UndefinedStandardLoop, XpdlPackage.eINSTANCE.getLoopType_LoopStandard()));
            } else {
                result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_InvalidMultiInstanceLoop, XpdlPackage.eINSTANCE.getLoopType_LoopStandard()));
            }
        } else {
            String condition;
            if (loopStandard.getTestTime() == null) {
                result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_NoStandardLoopExecutionType, XpdlPackage.eINSTANCE.getLoopStandardType_TestTime()));
            }
            if ((condition = XpdlUtil.getLoopStandardCondition((LoopStandardType)loopStandard)) == null || condition.trim().length() == 0) {
                result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_NoLoopCondition, XpdlPackage.eINSTANCE.getLoopStandardType_LoopCondition()));
            } else if (!this.isValidLoopCondition(condition)) {
                result.add(Issue.warning((EObject)activity, Validation_Messages.ERR_ACTIVITY_InvalidLoopCondition, XpdlPackage.eINSTANCE.getLoopStandardType_LoopCondition()));
            }
        }
    }

    private void validateOldStyleLoop(List<Issue> result, ActivityType activity) {
        if (activity.getLoopType() != null && (activity.getLoopType().getValue() == 2 || activity.getLoopType().getValue() == 3)) {
            if (activity.getLoopCondition() == null || activity.getLoopCondition().trim().length() == 0) {
                result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_NoLoopCondition, ValidationService.PKG_CWM.getActivityType_LoopCondition()));
            } else if (!this.isValidLoopCondition(activity.getLoopCondition())) {
                result.add(Issue.warning((EObject)activity, Validation_Messages.ERR_ACTIVITY_InvalidLoopCondition, ValidationService.PKG_CWM.getActivityType_LoopCondition()));
            }
        }
    }

    private ActivityType checkXORANDBlock(ActivityType startActivity, ActivityType currentActivity, HashSet<ActivityType> checkedActivities) {
        for (TransitionType outTransition : currentActivity.getOutTransitions()) {
            currentActivity = outTransition.getTo();
            if (JoinSplitType.AND_LITERAL.equals((Object)currentActivity.getJoin()) && this.checkBackXORANDBlock(startActivity, currentActivity, outTransition, checkedActivities)) {
                return currentActivity;
            }
            if (checkedActivities.contains(currentActivity)) continue;
            checkedActivities.add(currentActivity);
            return this.checkXORANDBlock(startActivity, currentActivity, checkedActivities);
        }
        return null;
    }

    private boolean checkBackXORANDBlock(ActivityType startActivity, ActivityType currentActivity, TransitionType outTransition, HashSet<ActivityType> checkedActivities) {
        for (TransitionType inTransition : currentActivity.getInTransitions()) {
            if (outTransition != null && outTransition.equals(inTransition)) {
                outTransition = null;
                continue;
            }
            currentActivity = inTransition.getFrom();
            if (JoinSplitType.AND_LITERAL.equals((Object)currentActivity.getSplit())) {
                return false;
            }
            if (currentActivity.equals(startActivity)) {
                return true;
            }
            if (checkedActivities.contains(currentActivity)) continue;
            checkedActivities.add(currentActivity);
            return this.checkBackXORANDBlock(startActivity, currentActivity, outTransition, checkedActivities);
        }
        return false;
    }

    private void checkApplicationActivity(List<Issue> result, ActivityType activity) {
        if (ActivityUtil.isApplicationActivity((ActivityType)activity) && activity.getApplication() == null) {
            result.add(Issue.error((EObject)activity, MessageFormat.format(Validation_Messages.ERR_ACTIVITYNoApplication, activity.getName()), ValidationService.PKG_CWM.getActivityType_Application()));
        }
    }

    private void checkSubprocessActivity(List<Issue> result, ActivityType activity) {
        if (ActivityUtil.isSubprocessActivity((ActivityType)activity)) {
            if (activity.getImplementationProcess() == null) {
                result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_NoImplementationProcess, ValidationService.PKG_CWM.getActivityType_ImplementationProcess()));
            } else if (activity.getSubProcessMode() == null) {
                result.add(Issue.warning((EObject)activity, MessageFormat.format(Validation_Messages.ERR_ACTIVITY_SubProcessMode, activity.getName()), ValidationService.PKG_CWM.getActivityType_SubProcessMode()));
            }
        }
    }

    private void checkPerformer(List<Issue> result, ActivityType activity) {
        if (ActivityUtil.isInteractive((ActivityType)activity)) {
            boolean isQualityAssurance;
            if (activity.getPerformer() == null) {
                result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_NoPerformerSet, ValidationService.PKG_CWM.getActivityType_Performer()));
            }
            if (isQualityAssurance = AttributeUtil.getBooleanValue((IExtensibleElement)activity, (String)"isQualityControlActivity")) {
                IModelParticipant qualityControlPerformer;
                IModelParticipant performer = activity.getPerformer();
                if (performer != null && performer instanceof ConditionalPerformerType) {
                    result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_QualityAssurancePerformer, ValidationService.PKG_CWM.getActivityType_Performer()));
                }
                if ((qualityControlPerformer = activity.getQualityControlPerformer()) != null && qualityControlPerformer instanceof ConditionalPerformerType) {
                    result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_QualityAssurancePerformer, ValidationService.PKG_CWM.getActivityType_QualityControlPerformer()));
                }
            }
        } else if (activity.getPerformer() != null) {
            result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_PerformerWronglySet, ValidationService.PKG_CWM.getActivityType_Performer()));
        }
    }

    private boolean isValidLoopCondition(String condition) {
        return true;
    }

    private boolean hasMultipleTransitions(ActivityType activity, int type) {
        ProcessDefinitionType process = (ProcessDefinitionType)activity.eContainer();
        int count = 0;
        ArrayList<TransitionType> removeTransitions = new ArrayList<TransitionType>();
        ArrayList transitions = new ArrayList();
        transitions.addAll(process.getTransition());
        for (EventHandlerType eventHandler : activity.getEventHandler()) {
            TransitionType exceptionTransition = this.getExceptionTransition((List<TransitionType>)activity.getOutTransitions(), eventHandler.getId());
            if (exceptionTransition == null) continue;
            removeTransitions.add(exceptionTransition);
        }
        transitions.removeAll(removeTransitions);
        int i = 0;
        while (i < transitions.size()) {
            TransitionType trans = (TransitionType)transitions.get(i);
            switch (type) {
                case 0: {
                    if (trans.getTo() != activity) break;
                    ++count;
                    break;
                }
                case 1: {
                    if (trans.getFrom() != activity) break;
                    ++count;
                }
            }
            if (count > 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean findDuplicateId(ActivityType activity) {
        for (ActivityType otherActivity : ModelUtils.findContainingProcess((EObject)activity).getActivity()) {
            if (!otherActivity.getId().equals(activity.getId()) || activity.equals(otherActivity)) continue;
            return true;
        }
        return false;
    }

    private TransitionType getExceptionTransition(List<TransitionType> outTransitions, String eventHandlerId) {
        if (outTransitions == null || StringUtils.isEmpty((String)eventHandlerId)) {
            return null;
        }
        String condition = "ON_BOUNDARY_EVENT(" + eventHandlerId + ")";
        for (TransitionType t : outTransitions) {
            String expression = this.getExpression(t);
            if (expression == null || !condition.equals(expression)) continue;
            return t;
        }
        return null;
    }

    private String getExpression(TransitionType transition) {
        XmlTextNode type = transition.getExpression();
        String expression = type == null ? null : ModelUtils.getCDataString((FeatureMap)transition.getExpression().getMixed());
        return expression;
    }
}

