/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl.spi.actionTypes;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;

public class MailActionValidator
implements IModelElementValidator {
    private static final String MAIL_TYPE = "email";
    private static final String PARTICIPANT_TYPE = "participant";
    private static final String MAIL_ACTION_RECEIVER_TYPE_ATT = "carnot:engine:receiverType";
    private static final String MAIL_ACTION_RECEIVER_ATT = "carnot:engine:receiver";
    private static final String MAIL_ACTION_ADDRESS_ATT = "carnot:engine:emailAddress";
    private static final String[] messages = new String[]{Validation_Messages.MSG_NoReceiverType, Validation_Messages.MSG_NoReceivingParticipant, Validation_Messages.MSG_NoEmailAddress, Validation_Messages.MailActionValidator_MSG_NoCorrectEmailAddress};

    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        String receiverType = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)MAIL_ACTION_RECEIVER_TYPE_ATT);
        if (StringUtils.isEmpty((String)receiverType)) {
            result.add(Issue.warning((EObject)element, messages[0]));
        } else if (receiverType.equals(PARTICIPANT_TYPE)) {
            if (StringUtils.isEmpty((String)AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)MAIL_ACTION_RECEIVER_ATT))) {
                result.add(Issue.warning((EObject)element, messages[1]));
            }
        } else if (receiverType.equals(MAIL_TYPE)) {
            if (StringUtils.isEmpty((String)AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)MAIL_ACTION_ADDRESS_ATT))) {
                result.add(Issue.warning((EObject)element, messages[2]));
            } else {
                String mailAddress = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)MAIL_ACTION_ADDRESS_ATT);
                mailAddress = VariableContextHelper.getInstance().getContext(element).replaceAllVariablesByDefaultValue(mailAddress);
                if (!this.checkFormat(mailAddress)) {
                    result.add(Issue.warning((EObject)element, messages[3]));
                }
            }
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    private boolean checkFormat(String mailAdress) {
        boolean isCorrectSuffix;
        boolean isCorrectDot;
        boolean isCorrectAtSign;
        int atSignIdx = mailAdress.indexOf(64);
        int atSignLastIdx = mailAdress.lastIndexOf(64);
        int dotLastIdx = mailAdress.lastIndexOf(".");
        boolean bl = isCorrectAtSign = atSignIdx > 0 && atSignIdx == atSignLastIdx;
        boolean bl2 = atSignIdx > 0 ? dotLastIdx > atSignIdx + 1 && mailAdress.charAt(atSignIdx + 1) != '.' && mailAdress.charAt(atSignIdx - 1) != '.' : (isCorrectDot = false);
        boolean bl3 = dotLastIdx > 0 && dotLastIdx < mailAdress.length() - 1 ? mailAdress.substring(dotLastIdx + 1).length() > 1 && mailAdress.substring(dotLastIdx + 1).length() < 5 : (isCorrectSuffix = false);
        return !mailAdress.startsWith(".") && isCorrectAtSign && isCorrectDot && isCorrectSuffix;
    }
}

