/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseResource;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.core.syncinfo.BaserevInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.NotifyInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;

public class EclipseFile
extends EclipseResource
implements ICVSFile {
    private static final String TEMP_FILE_EXTENSION = ".tmp";
    private static final IPath PROJECT_META_DATA_PATH = new Path(".project");

    protected EclipseFile(IFile file) {
        super((IResource)file);
    }

    @Override
    public void delete() throws CVSException {
        try {
            ((IFile)this.resource).delete(false, true, null);
        }
        catch (CoreException e) {
            throw CVSException.wrapException(this.resource, NLS.bind((String)CVSMessages.EclipseFile_Problem_deleting_resource, (Object[])new String[]{this.resource.getFullPath().toString(), e.getStatus().getMessage()}), e);
        }
    }

    @Override
    public long getSize() {
        return this.getIOFile().length();
    }

    @Override
    public InputStream getContents() throws CVSException {
        try {
            return this.getIFile().getContents();
        }
        catch (CoreException e) {
            throw CVSException.wrapException(this.resource, NLS.bind((String)CVSMessages.EclipseFile_Problem_accessing_resource, (Object[])new String[]{this.resource.getFullPath().toString(), e.getStatus().getMessage()}), e);
        }
    }

    @Override
    public Date getTimeStamp() {
        long timestamp = this.getIFile().getLocalTimeStamp();
        if (timestamp == -1L) {
            return new Date(0L);
        }
        return new Date(timestamp / 1000L * 1000L);
    }

    @Override
    public void setTimeStamp(Date date) throws CVSException {
        long time = date == null ? System.currentTimeMillis() : date.getTime();
        EclipseSynchronizer.getInstance().setTimeStamp(this, time);
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public boolean isModified(IProgressMonitor monitor) throws CVSException {
        byte[] syncBytes;
        if (!this.exists()) {
            return this.getSyncBytes() != null;
        }
        int state = EclipseSynchronizer.getInstance().getModificationState((IResource)this.getIFile());
        if (state != 0) {
            boolean dirty;
            boolean bl = dirty = state != 1;
            if (dirty == this.isDirty()) {
                return dirty;
            }
        }
        if ((syncBytes = this.getSyncBytes()) == null && this.isIgnored()) {
            return false;
        }
        return EclipseSynchronizer.getInstance().setModified(this, 0);
    }

    @Override
    public void accept(ICVSResourceVisitor visitor) throws CVSException {
        visitor.visitFile(this);
    }

    @Override
    public void accept(ICVSResourceVisitor visitor, boolean recurse) throws CVSException {
        visitor.visitFile(this);
    }

    @Override
    public void copyTo(String filename) throws CVSException {
        try {
            Path targetPath = new Path(null, filename);
            IFile targetFile = this.getIFile().getParent().getFile((IPath)targetPath);
            if (targetFile.exists()) {
                targetFile.delete(false, true, null);
            }
            this.getIFile().copy((IPath)targetPath, true, null);
        }
        catch (CoreException e) {
            throw new CVSException(e.getStatus());
        }
    }

    @Override
    public String getRemoteLocation(ICVSFolder stopSearching) throws CVSException {
        return String.valueOf(this.getParent().getRemoteLocation(stopSearching)) + "/" + this.getName();
    }

    @Override
    public void setContents(InputStream stream, int responseType, boolean keepLocalHistory, IProgressMonitor monitor) throws CVSException {
        try {
            IFile file = this.getIFile();
            if (PROJECT_META_DATA_PATH.equals((Object)file.getFullPath().removeFirstSegments(1))) {
                responseType = 1;
            }
            switch (responseType) {
                case 1: {
                    if (this.resource.exists()) {
                        file.setContents(stream, false, true, monitor);
                        break;
                    }
                }
                case 4: {
                    file.create(stream, false, monitor);
                    break;
                }
                case 2: {
                    IFile tempFile = file.getParent().getFile((IPath)new Path(null, String.valueOf(file.getName()) + TEMP_FILE_EXTENSION));
                    monitor.beginTask(null, 100);
                    if (tempFile.exists()) {
                        tempFile.delete(true, Policy.subMonitorFor(monitor, 25));
                    }
                    tempFile.create(stream, true, Policy.subMonitorFor(monitor, 25));
                    file.delete(false, true, Policy.subMonitorFor(monitor, 25));
                    tempFile.move((IPath)new Path(null, file.getName()), false, true, Policy.subMonitorFor(monitor, 25));
                    monitor.done();
                    break;
                }
                case 3: {
                    file.setContents(stream, false, true, monitor);
                }
            }
        }
        catch (CoreException e) {
            Throwable t;
            String message = null;
            if (e.getStatus().getCode() == 271 && (t = e.getStatus().getException()) != null) {
                message = t.getMessage();
            }
            if (message == null) {
                message = e.getMessage();
            }
            throw CVSException.wrapException(this.resource, NLS.bind((String)CVSMessages.EclipseFile_Problem_writing_resource, (Object[])new String[]{this.resource.getFullPath().toString(), message}), e);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws CVSException {
        ResourceAttributes attributes = this.resource.getResourceAttributes();
        if (attributes != null) {
            attributes.setReadOnly(readOnly);
            try {
                this.resource.setResourceAttributes(attributes);
            }
            catch (CoreException e) {
                throw CVSException.wrapException(e);
            }
        }
    }

    @Override
    public boolean isReadOnly() throws CVSException {
        return this.getIFile().isReadOnly();
    }

    @Override
    public void setExecutable(boolean executable) throws CVSException {
        ResourceAttributes attributes = this.resource.getResourceAttributes();
        if (attributes != null) {
            attributes.setExecutable(executable);
            try {
                this.resource.setResourceAttributes(attributes);
            }
            catch (CoreException e) {
                throw CVSException.wrapException(e);
            }
        }
    }

    @Override
    public boolean isExecutable() throws CVSException {
        ResourceAttributes attributes = this.resource.getResourceAttributes();
        if (attributes != null) {
            return attributes.isExecutable();
        }
        return false;
    }

    public IFile getIFile() {
        return (IFile)this.resource;
    }

    private File getIOFile() {
        IPath location = this.resource.getLocation();
        if (location != null) {
            return location.toFile();
        }
        return null;
    }

    @Override
    public ILogEntry[] getLogEntries(IProgressMonitor monitor) throws TeamException {
        ICVSRemoteResource remoteFile;
        if (this.getIResource() == null || !this.getIResource().getProject().isAccessible()) {
            return new ILogEntry[0];
        }
        byte[] syncBytes = this.getSyncBytes();
        if (syncBytes != null && !ResourceSyncInfo.isAddition(syncBytes) && (remoteFile = CVSWorkspaceRoot.getRemoteResourceFor(this.resource)) != null) {
            return ((ICVSRemoteFile)remoteFile).getLogEntries(monitor);
        }
        return new ILogEntry[0];
    }

    public void setNotifyInfo(NotifyInfo info) throws CVSException {
        if (this.isManaged()) {
            EclipseSynchronizer.getInstance().setNotifyInfo(this.resource, info);
        }
    }

    public NotifyInfo getNotifyInfo() throws CVSException {
        if (this.isManaged()) {
            return EclipseSynchronizer.getInstance().getNotifyInfo(this.resource);
        }
        return null;
    }

    public void setBaserevInfo(BaserevInfo info) throws CVSException {
        if (this.isManaged()) {
            if (info == null) {
                EclipseSynchronizer.getInstance().deleteBaserevInfo(this.resource);
                EclipseSynchronizer.getInstance().deleteFileFromBaseDirectory(this.getIFile(), null);
            } else {
                EclipseSynchronizer.getInstance().setBaserevInfo(this.resource, info);
            }
        }
    }

    public BaserevInfo getBaserevInfo() throws CVSException {
        if (this.isManaged()) {
            return EclipseSynchronizer.getInstance().getBaserevInfo(this.resource);
        }
        return null;
    }

    @Override
    public void edit(final int notifications, boolean notifyForWritable, IProgressMonitor monitor) throws CVSException {
        if (!notifyForWritable && !this.isReadOnly()) {
            return;
        }
        this.run(new ICVSRunnable(){

            @Override
            public void run(IProgressMonitor monitor) throws CVSException {
                char[] internalFormat;
                byte[] syncBytes = EclipseFile.this.getSyncBytes();
                if (syncBytes == null || ResourceSyncInfo.isAddition(syncBytes)) {
                    return;
                }
                if (notifications == 0) {
                    internalFormat = null;
                } else if (notifications == 7) {
                    internalFormat = NotifyInfo.ALL;
                } else {
                    ArrayList<Character> notificationCharacters = new ArrayList<Character>();
                    if ((notifications & 1) > 0) {
                        notificationCharacters.add(new Character('E'));
                    }
                    if ((notifications & 2) > 0) {
                        notificationCharacters.add(new Character('U'));
                    }
                    if ((notifications & 4) > 0) {
                        notificationCharacters.add(new Character('C'));
                    }
                    internalFormat = new char[notificationCharacters.size()];
                    int i = 0;
                    while (i < internalFormat.length) {
                        internalFormat[i] = ((Character)notificationCharacters.get(i)).charValue();
                        ++i;
                    }
                }
                NotifyInfo notifyInfo = new NotifyInfo(EclipseFile.this.getName(), 'E', new Date(), internalFormat);
                EclipseFile.this.setNotifyInfo(notifyInfo);
                if (!EclipseFile.this.isModified(null)) {
                    EclipseSynchronizer.getInstance().copyFileToBaseDirectory(EclipseFile.this.getIFile(), monitor);
                    EclipseFile.this.setBaserevInfo(new BaserevInfo(EclipseFile.this.getName(), ResourceSyncInfo.getRevision(syncBytes)));
                }
                try {
                    EclipseFile.this.setReadOnly(false);
                }
                catch (CVSException e) {
                    CVSProviderPlugin.log((CoreException)((Object)e));
                }
            }
        }, monitor);
    }

    @Override
    public void unedit(IProgressMonitor monitor) throws CVSException {
        if (this.isReadOnly()) {
            return;
        }
        this.run(new ICVSRunnable(){

            @Override
            public void run(IProgressMonitor monitor) throws CVSException {
                NotifyInfo info = EclipseFile.this.getNotifyInfo();
                info = info != null && info.getNotificationType() == 'E' ? null : new NotifyInfo(EclipseFile.this.getName(), 'U', new Date(), null);
                EclipseFile.this.setNotifyInfo(info);
                if (EclipseFile.this.isModified(null)) {
                    ResourceSyncInfo syncInfo = EclipseFile.this.getSyncInfo();
                    BaserevInfo baserevInfo = EclipseFile.this.getBaserevInfo();
                    EclipseSynchronizer.getInstance().restoreFileFromBaseDirectory(EclipseFile.this.getIFile(), monitor);
                    if (!syncInfo.getRevision().equals(baserevInfo.getRevision())) {
                        MutableResourceSyncInfo newInfo = syncInfo.cloneMutable();
                        newInfo.setRevision(baserevInfo.getRevision());
                        newInfo.setTimeStamp(EclipseFile.this.getTimeStamp());
                        newInfo.setDeleted(false);
                        EclipseFile.this.setSyncInfo(newInfo, 1);
                    } else {
                        EclipseSynchronizer.getInstance().setModified(EclipseFile.this, 1);
                    }
                } else {
                    EclipseFile.this.setSyncBytes(EclipseFile.this.getSyncBytes(), 1);
                }
                EclipseFile.this.setBaserevInfo(null);
                try {
                    EclipseFile.this.setReadOnly(true);
                }
                catch (CVSException e) {
                    CVSProviderPlugin.log((CoreException)((Object)e));
                }
            }
        }, monitor);
    }

    @Override
    public void notificationCompleted() throws CVSException {
        EclipseSynchronizer.getInstance().deleteNotifyInfo(this.resource);
    }

    @Override
    public NotifyInfo getPendingNotification() throws CVSException {
        return this.getNotifyInfo();
    }

    @Override
    public void checkedIn(String entryLine, boolean commit) throws CVSException {
        ResourceSyncInfo oldInfo = this.getSyncInfo();
        ResourceSyncInfo newInfo = null;
        int modificationState = 1;
        if (entryLine == null) {
            if (oldInfo == null) {
                return;
            }
            if (!oldInfo.isAdded()) {
                MutableResourceSyncInfo mutable = oldInfo.cloneMutable();
                mutable.setTimeStamp(this.getTimeStamp(), true);
                newInfo = mutable;
            }
        } else if (oldInfo == null) {
            newInfo = new ResourceSyncInfo(entryLine, null);
            modificationState = 2;
        } else {
            Date timeStamp;
            if (commit) {
                timeStamp = this.getTimeStamp();
            } else {
                timeStamp = oldInfo.getTimeStamp();
                if (timeStamp == null) {
                    timeStamp = this.getTimeStamp();
                } else {
                    this.setTimeStamp(timeStamp);
                    timeStamp = this.getTimeStamp();
                }
            }
            newInfo = new ResourceSyncInfo(entryLine, timeStamp);
        }
        if (newInfo != null) {
            CVSTag tag = newInfo.getTag();
            if (tag != null && CVSEntryLineTag.BASE.getName().equals(tag.getName())) {
                newInfo = newInfo.cloneMutable();
                ((MutableResourceSyncInfo)newInfo).setTag(oldInfo.getTag());
            }
            this.setSyncInfo(newInfo, modificationState);
        }
        this.clearCachedBase();
    }

    private void clearCachedBase() throws CVSException {
        BaserevInfo base = this.getBaserevInfo();
        if (base != null) {
            this.setBaserevInfo(null);
            try {
                this.setReadOnly(true);
            }
            catch (CVSException e) {
                CVSProviderPlugin.log((CoreException)((Object)e));
            }
        } else {
            CVSTeamProvider provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)this.resource.getProject(), (String)CVSProviderPlugin.getTypeId());
            if (provider != null && provider.isWatchEditEnabled()) {
                try {
                    this.setReadOnly(true);
                }
                catch (CVSException e) {
                    CVSProviderPlugin.log((CoreException)((Object)e));
                }
            }
        }
    }

    @Override
    public void unmanage(IProgressMonitor monitor) throws CVSException {
        this.run(new ICVSRunnable(){

            @Override
            public void run(IProgressMonitor monitor) throws CVSException {
                EclipseFile.super.unmanage(monitor);
                EclipseFile.this.clearCachedBase();
            }
        }, monitor);
    }

    @Override
    public boolean isEdited() throws CVSException {
        return EclipseSynchronizer.getInstance().isEdited(this.getIFile());
    }

    @Override
    public void setSyncInfo(ResourceSyncInfo info, int modificationState) throws CVSException {
        this.setSyncBytes(info.getBytes(), info, modificationState);
    }

    @Override
    public void setSyncBytes(byte[] syncBytes, int modificationState) throws CVSException {
        this.setSyncBytes(syncBytes, null, modificationState);
    }

    private void setSyncBytes(byte[] syncBytes, ResourceSyncInfo info, int modificationState) throws CVSException {
        Assert.isNotNull((Object)syncBytes);
        this.setSyncBytes(syncBytes);
        EclipseSynchronizer.getInstance().setModified(this, modificationState);
    }

    @Override
    public void handleModification(boolean forAddition) throws CVSException {
        if (this.isIgnored()) {
            if (!this.resource.isDerived()) {
                EclipseSynchronizer.getInstance().setModified(this, 1);
            }
            return;
        }
        EclipseSynchronizer.getInstance().setModified(this, 0);
    }

    @Override
    public String getRepositoryRelativePath() throws CVSException {
        if (!this.isManaged()) {
            return null;
        }
        String parentPath = this.getParent().getRepositoryRelativePath();
        if (parentPath == null) {
            return null;
        }
        return String.valueOf(parentPath) + "/" + this.getName();
    }

    protected boolean isDirty() throws CVSException {
        boolean dirty;
        byte[] syncBytes = this.getSyncBytes();
        if (syncBytes == null) {
            dirty = this.exists();
        } else if (ResourceSyncInfo.isAddition(syncBytes) || ResourceSyncInfo.isMerge(syncBytes) || ResourceSyncInfo.wasDeleted(syncBytes) || !this.exists()) {
            dirty = true;
        } else {
            ResourceSyncInfo info = new ResourceSyncInfo(syncBytes);
            dirty = !this.getTimeStamp().equals(info.getTimeStamp());
        }
        return dirty;
    }
}

