/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.eclipse.team.internal.ccvs.ui.CVSPropertiesPage;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.ui.PlatformUI;

public class CVSFilePropertiesPage
extends CVSPropertiesPage {
    IFile file;

    protected Control createContents(Composite parent) {
        this.initialize();
        this.noDefaultAndApplyButton();
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        try {
            ICVSFile cvsResource = CVSWorkspaceRoot.getCVSFileFor((IFile)this.file);
            if (!cvsResource.isManaged()) {
                if (cvsResource.isIgnored()) {
                    this.createLabel(composite, CVSUIMessages.CVSFilePropertiesPage_ignored);
                } else {
                    this.createLabel(composite, CVSUIMessages.CVSFilePropertiesPage_notManaged);
                }
                this.createLabel(composite, "");
                return composite;
            }
            ResourceSyncInfo syncInfo = cvsResource.getSyncInfo();
            if (syncInfo.isAdded()) {
                this.createLabel(composite, CVSUIMessages.CVSFilePropertiesPage_isAdded, 2);
            } else {
                this.createLabel(composite, CVSUIMessages.CVSFilePropertiesPage_baseRevision);
                this.createReadOnlyText(composite, syncInfo.getRevision());
                Date baseTime = syncInfo.getTimeStamp();
                if (baseTime != null) {
                    this.createLabel(composite, CVSUIMessages.CVSFilePropertiesPage_baseTimestamp);
                    this.createReadOnlyText(composite, DateFormat.getDateTimeInstance((int)0, (int)0).format(syncInfo.getTimeStamp()));
                }
                this.createLabel(composite, CVSUIMessages.CVSFilePropertiesPage_modified);
                this.createReadOnlyText(composite, cvsResource.isModified(null) ? CVSUIMessages.yes : CVSUIMessages.no);
            }
            this.createLabel(composite, CVSUIMessages.CVSFilePropertiesPage_keywordMode);
            this.createReadOnlyText(composite, syncInfo.getKeywordMode().getLongDisplayText());
            this.createLabel(composite, CVSUIMessages.CVSFilePropertiesPage_tag);
            CVSTag tag = Util.getAccurateFileTag((ICVSResource)cvsResource);
            this.createReadOnlyText(composite, CVSFilePropertiesPage.getTagLabel(tag));
        }
        catch (TeamException teamException) {
            this.createLabel(composite, CVSUIMessages.CVSFilePropertiesPage_error);
            this.createReadOnlyText(composite, "");
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.team.cvs.ui.file_property_page_context");
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private void initialize() {
        this.file = null;
        IAdaptable element = this.getElement();
        if (element instanceof IFile) {
            this.file = (IFile)element;
        } else {
            Object adapter = element.getAdapter(IFile.class);
            if (adapter instanceof IFile) {
                this.file = (IFile)adapter;
            }
        }
    }
}

