/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.operation.local.management.ReconnectProjectOperation;
import org.eclipse.team.svn.core.operation.remote.management.AddRepositoryLocationOperation;
import org.eclipse.team.svn.core.operation.remote.management.SaveRepositoryLocationsOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryRoot;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class SVNFolderListener
implements IResourceChangeListener {
    public void resourceChanged(final IResourceChangeEvent event) {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(final IProgressMonitor monitor) throws CoreException {
                    event.getDelta().accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            IResource resource = delta.getResource();
                            if (!resource.isAccessible()) {
                                return false;
                            }
                            if (resource.getType() == 8) {
                                return true;
                            }
                            if (resource.getType() == 4 && delta.getKind() == 1 && delta.getFlags() == 16384 && SVNTeamPlugin.instance().getOptionProvider().is("automaticProjectShareEnabled") && ((IProject)resource).isOpen()) {
                                if (RepositoryProvider.getProvider((IProject)((IProject)resource), (String)"org.eclipse.team.svn.core.svnnature") != null) {
                                    return false;
                                }
                                SVNChangeStatus info = SVNUtility.getSVNInfoForNotConnected(resource);
                                if (info != null && info.url != null) {
                                    String url = SVNUtility.decodeURL(info.url);
                                    IRepositoryRoot[] roots = SVNUtility.findRoots(url, true);
                                    IRepositoryLocation location = null;
                                    if (roots.length == 0) {
                                        String rootNode = "/" + CoreExtensionsManager.instance().getOptionProvider().getString("defaultTrunkName");
                                        int idx = url.lastIndexOf(rootNode);
                                        if (!(idx != -1 && (url.endsWith(rootNode) || url.charAt(idx + rootNode.length()) == '/') || (idx = url.lastIndexOf(rootNode = "/" + CoreExtensionsManager.instance().getOptionProvider().getString("defaultBranchesName"))) != -1 && (url.endsWith(rootNode) || url.charAt(idx + rootNode.length()) == '/') || (idx = url.lastIndexOf(rootNode = "/" + CoreExtensionsManager.instance().getOptionProvider().getString("defaultTagsName"))) == -1 || url.endsWith(rootNode) || url.charAt(idx + rootNode.length()) == '/')) {
                                            idx = -1;
                                        }
                                        if (idx != -1) {
                                            url = url.substring(0, idx);
                                        }
                                        location = SVNRemoteStorage.instance().newRepositoryLocation();
                                        SVNUtility.initializeRepositoryLocation(location, url);
                                    } else {
                                        location = roots[0].getRepositoryLocation();
                                    }
                                    ReconnectProjectOperation mainOp = new ReconnectProjectOperation(new IProject[]{(IProject)resource}, location);
                                    CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
                                    if (roots.length == 0) {
                                        op.add(new AddRepositoryLocationOperation(location));
                                        op.add(new SaveRepositoryLocationsOperation());
                                    }
                                    op.add(mainOp);
                                    ProgressMonitorUtility.doTaskExternal(op, monitor);
                                    return false;
                                }
                            }
                            if (delta.getKind() == 1 && resource instanceof IContainer && !resource.isTeamPrivateMember() && FileUtility.isSVNInternals(resource)) {
                                FileUtility.findAndMarkSVNInternals(resource, true);
                                return false;
                            }
                            return true;
                        }
                    });
                }
            }, null, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ex) {
            LoggedOperation.reportError(this.getClass().getName(), ex);
        }
    }
}

