/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.utility;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.Team;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamProvider;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.GetAllResourcesOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.PatternProvider;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtility {
    public static final IResource[] NO_CHILDREN = new IResource[0];
    private static IPath ALWAYS_IGNORED_PATH = null;
    public static final int COPY_NO_OPTIONS = 0;
    public static final int COPY_IGNORE_EXISTING_FOLDERS = 1;
    public static final int COPY_OVERRIDE_EXISTING_FILES = 2;

    public static File findWCDB(File folder) {
        String fragment = "/" + SVNUtility.getSVNFolderName() + "/wc.db";
        File target = null;
        do {
            if (!(target = new File(String.valueOf(folder.getAbsolutePath()) + fragment)).exists()) continue;
            return target;
        } while ((folder = folder.getParentFile()) != null);
        return null;
    }

    public static boolean isSymlink(IResource resource) {
        URI uri = null;
        if (resource.exists() && (uri = resource.getLocationURI()) != null) {
            try {
                IFileStore store = EFS.getStore((URI)uri);
                IFileInfo info = store.fetchInfo();
                if (info.getAttribute(32)) {
                    return true;
                }
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    public static IPath getAlwaysIgnoredPath() {
        if (ALWAYS_IGNORED_PATH == null) {
            ALWAYS_IGNORED_PATH = new Path(SVNUtility.getSVNFolderName());
        }
        return ALWAYS_IGNORED_PATH;
    }

    public static int getMIMEType(IResource resource) {
        int type = Team.getFileContentManager().getTypeForExtension(resource.getFileExtension() == null ? "" : resource.getFileExtension());
        if (type == 0) {
            type = Team.getFileContentManager().getTypeForName(resource.getName());
        }
        return type;
    }

    public static IResource selectOneOf(IResource[] scope, IResource[] set) {
        int i = 0;
        while (i < set.length) {
            if (FileUtility.relatesTo(scope, set[i])) {
                return set[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean relatesTo(IResource[] set, IResource resource) {
        int i = 0;
        while (i < set.length) {
            if (FileUtility.relatesTo(set[i], resource)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean relatesTo(IResource set, IResource resource) {
        return set.equals((Object)resource) ? true : (resource == null ? false : FileUtility.relatesTo(set, (IResource)resource.getParent()));
    }

    public static String getResource(ResourceBundle bundle, String key) {
        if (key == null) {
            return null;
        }
        if (bundle == null) {
            return key;
        }
        String retVal = FileUtility.getResourceImpl(bundle, key);
        if (retVal != null) {
            String id;
            if (key.indexOf("Error") != -1 && (id = FileUtility.getResourceImpl(bundle, String.valueOf(key) + ".Id")) != null) {
                retVal = String.valueOf(id) + ": " + retVal;
            }
            return retVal;
        }
        return key;
    }

    private static String getResourceImpl(ResourceBundle bundle, String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static String getWorkingCopyPath(IResource resource) {
        return FileUtility.getResourcePath(resource).toString();
    }

    public static IPath getResourcePath(IResource resource) {
        IPath projectLocation;
        IPath location = resource.getLocation();
        if (location == null && resource.getProject() != null && (projectLocation = resource.getProject().getLocation()) != null) {
            location = projectLocation.append(resource.getFullPath());
        }
        return location != null ? location : FileUtility.getAlwaysIgnoredPath();
    }

    public static Map<String, String> getEnvironmentVariables() {
        try {
            Method getenv = System.class.getMethod("getenv", null);
            return (Map)getenv.invoke(null, null);
        }
        catch (Exception exception) {
            try {
                String varLine;
                boolean isWindows = FileUtility.isWindows();
                Process p = isWindows ? Runtime.getRuntime().exec("cmd.exe /c set") : Runtime.getRuntime().exec("env");
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                HashMap<String, String> retVal = new HashMap<String, String>();
                while ((varLine = br.readLine()) != null) {
                    int idx = varLine.indexOf(61);
                    if (idx != -1) {
                        String name = varLine.substring(0, idx);
                        retVal.put(isWindows ? name.toUpperCase() : name, varLine.substring(idx + 1));
                        continue;
                    }
                    if (varLine.length() <= 0) continue;
                    retVal.put(varLine, "");
                }
                return retVal;
            }
            catch (IOException iOException) {
                return Collections.emptyMap();
            }
        }
    }

    public static String normalizePath(String path) {
        return FileUtility.isWindows() ? path.replace('/', '\\') : path.replace('\\', '/');
    }

    public static boolean isWindows() {
        return FileUtility.getOSName().indexOf("windows") != -1;
    }

    public static String getOSName() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static boolean isCaseInsensitiveOS() {
        return "macosx".equals(Platform.getOS()) || new File("a").compareTo(new File("A")) == 0;
    }

    public static boolean isLinked(IResource resource) {
        return resource.isLinked(512);
    }

    public static boolean isRemoteProject(IProject project) {
        return project.getLocation() == null;
    }

    public static boolean isNotSupervised(IResource resource) {
        return resource instanceof IWorkspaceRoot || resource.isTeamPrivateMember() || FileUtility.isLinked(resource);
    }

    public static String[] asPathArray(IResource[] resources) {
        String[] retVal = new String[resources.length];
        int i = 0;
        while (i < resources.length) {
            retVal[i] = FileUtility.normalizePath(FileUtility.getWorkingCopyPath(resources[i]));
            ++i;
        }
        return retVal;
    }

    public static String[] asPathArray(File[] files) {
        String[] retVal = new String[files.length];
        int i = 0;
        while (i < files.length) {
            retVal[i] = FileUtility.normalizePath(files[i].getAbsolutePath());
            ++i;
        }
        return retVal;
    }

    public static String formatResourceName(String projectName) {
        return projectName == null ? null : PatternProvider.replaceAll(projectName, "([\\/:])+", ".");
    }

    public static String formatPath(String path) {
        return PatternProvider.replaceAll(path, "\\\\", "/");
    }

    public static String getUsernameParam(String username) {
        return username == null || username.trim().length() == 0 ? "" : " --username \"" + username + "\"";
    }

    public static String flattenText(String text) {
        StringBuffer flat = new StringBuffer(text.length() + 20);
        boolean skipAdjacentLineSeparator = true;
        int i = 0;
        while (i < text.length()) {
            char currentChar = text.charAt(i);
            if (currentChar == '\r' || currentChar == '\n') {
                if (!skipAdjacentLineSeparator) {
                    flat.append("/");
                }
                skipAdjacentLineSeparator = true;
            } else {
                flat.append(currentChar);
                skipAdjacentLineSeparator = false;
            }
            ++i;
        }
        return flat.toString().replace('\t', ' ');
    }

    public static int getMaxStringLength(String[] strings) {
        int result = 0;
        int i = 0;
        while (i < strings.length) {
            result = Math.max(result, strings[i].length());
            ++i;
        }
        return result;
    }

    public static String formatMultilineText(String text) {
        if (text.length() > 0 && text.substring(0, 1).matches("(\\s)+")) {
            text = text.replaceFirst("(\\s)+", "");
        }
        if (text.length() == 0) {
            return "";
        }
        text = text.replace('\t', ' ');
        int idx = text.indexOf(10);
        int idx1 = text.indexOf(13);
        if (idx == -1) {
            idx = idx1;
        }
        int n = idx = idx < idx1 || idx1 == -1 ? idx : idx1;
        if (idx != -1) {
            if (text.substring(idx).trim().length() != 0) {
                return String.valueOf(text.substring(0, idx)) + "...";
            }
            return text.substring(0, idx);
        }
        return text;
    }

    public static String[] decodeStringToArray(String encodedString) {
        String[] valuesArray = new String[]{};
        if (encodedString != null && encodedString.length() > 0) {
            String[] array = encodedString.split(";");
            int i = 0;
            while (i < array.length) {
                array[i] = new String(Base64.decode((byte[])array[i].getBytes()));
                ++i;
            }
            if (encodedString.endsWith(";")) {
                valuesArray = new String[array.length + 1];
                System.arraycopy(array, 0, valuesArray, 0, array.length);
                valuesArray[valuesArray.length - 1] = "";
            } else {
                valuesArray = array;
            }
        }
        return valuesArray;
    }

    public static String encodeArrayToString(String[] valuesArray) {
        String result = "";
        int i = 0;
        while (i < valuesArray.length) {
            String str = new String(Base64.encode((byte[])valuesArray[i].getBytes()));
            result = String.valueOf(result) + (i == 0 ? str : ";" + str);
            ++i;
        }
        return result;
    }

    public static void visitNodes(IResource resource, IResourceVisitor visitor, int depth) throws Exception {
        FileUtility.visitNodes(resource, visitor, depth, true);
    }

    public static void visitNodes(IResource resource, IResourceVisitor visitor, int depth, boolean useCache) throws Exception {
        FileUtility.visitNodes(resource, visitor, depth, useCache, false);
    }

    public static void visitNodes(IResource resource, IResourceVisitor visitor, int depth, boolean useCache, boolean useAlphabeticalOrder) throws Exception {
        boolean stepInside = visitor.visit(resource);
        if (stepInside && resource instanceof IContainer && depth != 0 && resource.isAccessible()) {
            IResource[] children;
            IContainer container = (IContainer)resource;
            IResource[] iResourceArray = children = useCache ? SVNRemoteStorage.instance().getRegisteredChildren(container) : FileUtility.resourceMembers(container, true);
            if (useAlphabeticalOrder) {
                FileUtility.reorder(children, true);
            }
            int nextDepth = depth == 1 ? 0 : depth;
            int i = 0;
            while (i < children.length) {
                FileUtility.visitNodes(children[i], visitor, nextDepth, useCache, useAlphabeticalOrder);
                ++i;
            }
        }
    }

    public static boolean checkForResourcesPresenceRecursive(IResource[] roots, IStateFilter filter) {
        return FileUtility.checkForResourcesPresence(roots, filter, 2);
    }

    public static boolean checkForResourcesPresence(IResource[] roots, IStateFilter filter, int depth) {
        ArrayList<IResource> recursiveCheck = null;
        int nextDepth = 0;
        if (depth != 0) {
            recursiveCheck = new ArrayList<IResource>();
            nextDepth = depth == 1 ? 0 : 2;
        }
        int i = 0;
        while (i < roots.length) {
            if (!FileUtility.isNotSupervised(roots[i])) {
                ILocalResource iLocalResource = SVNRemoteStorage.instance().asLocalResource(roots[i]);
                if (filter.accept(iLocalResource)) {
                    return true;
                }
                if (roots[i] instanceof IContainer && depth != 0 && filter.allowsRecursion(iLocalResource)) {
                    recursiveCheck.add(roots[i]);
                }
            }
            ++i;
        }
        if (depth != 0) {
            for (IContainer iContainer : recursiveCheck) {
                if (!FileUtility.checkForResourcesPresence(FileUtility.getAllMembers(iContainer), filter, nextDepth)) continue;
                return true;
            }
        }
        return false;
    }

    public static IResource[] filterResources(IResource[] resources, IStateFilter filter) {
        return FileUtility.filterResources(resources, filter, 2);
    }

    public static IResource[] filterResources(IResource[] resources, IStateFilter filter, int depth) {
        HashSet<IResource> retVal = new HashSet<IResource>(Arrays.asList(resources));
        int i = 0;
        while (i < resources.length) {
            if (!FileUtility.checkForResourcesPresence(new IResource[]{resources[i]}, filter, depth)) {
                retVal.remove(resources[i]);
            }
            ++i;
        }
        return retVal.toArray(new IResource[retVal.size()]);
    }

    public static IResource[] getResourcesRecursive(IResource[] roots, IStateFilter filter) {
        return FileUtility.getResourcesRecursive(roots, filter, 2);
    }

    public static IResource[] getResourcesRecursive(IResource[] roots, IStateFilter filter, int depth) {
        return FileUtility.getResourcesRecursive(roots, filter, depth, null, null);
    }

    public static IResource[] getResourcesRecursive(IResource[] roots, IStateFilter filter, int depth, IActionOperation calledFrom, IProgressMonitor monitor) {
        HashSet<IResource> resources = new HashSet<IResource>();
        FileUtility.addChildren(resources, roots, filter, depth, calledFrom, monitor);
        return resources.toArray(new IResource[resources.size()]);
    }

    public static IResource[] addOperableParents(IResource[] resources, IStateFilter stateFilter) {
        return FileUtility.addOperableParents(resources, stateFilter, false);
    }

    public static IResource[] addOperableParents(IResource[] resources, IStateFilter stateFilter, boolean through) {
        HashSet<IResource> tmp = new HashSet<IResource>(Arrays.asList(resources));
        tmp.addAll(Arrays.asList(FileUtility.getOperableParents(resources, stateFilter, through)));
        return tmp.toArray(new IResource[tmp.size()]);
    }

    public static IResource[] getOperableParents(IResource[] resources, IStateFilter stateFilter) {
        return FileUtility.getOperableParents(resources, stateFilter, false);
    }

    public static IResource[] getOperableParents(IResource[] resources, IStateFilter stateFilter, boolean through) {
        HashSet<IResource> tmp = new HashSet<IResource>();
        IResource[] parents = FileUtility.getParents(resources, true);
        if (!through) {
            FileUtility.reorder(parents, false);
        }
        int i = 0;
        while (i < parents.length) {
            ILocalResource parent = SVNRemoteStorage.instance().asLocalResource(parents[i]);
            if (stateFilter.accept(parent)) {
                tmp.add(parents[i]);
            } else if (!through) {
                IPath current = parents[i].getFullPath();
                while (i < parents.length) {
                    if (parents[i].getFullPath().isPrefixOf(current)) {
                        ++i;
                        continue;
                    }
                    --i;
                    break;
                }
            }
            ++i;
        }
        return tmp.toArray(new IResource[tmp.size()]);
    }

    /*
     * Unable to fully structure code
     */
    public static IResource[] getParents(IResource[] resources, boolean excludeIncoming) {
        parents = new HashSet<IResource>();
        i = 0;
        while (i < resources.length) {
            block5: {
                parent = resources[i];
                if (parent.getType() != 4) ** GOTO lbl11
                parents.add(parent);
                break block5;
lbl-1000:
                // 1 sources

                {
                    parents.add(parent);
lbl11:
                    // 2 sources

                    ** while ((parent = parent.getParent()) != null && !(parent instanceof IWorkspaceRoot))
                }
            }
            ++i;
        }
        if (excludeIncoming) {
            i = 0;
            while (i < resources.length) {
                if (resources[i].getType() != 4) {
                    parents.remove(resources[i]);
                }
                ++i;
            }
        }
        return parents.toArray(new IResource[parents.size()]);
    }

    public static boolean isSVNInternals(IResource resource) {
        return FileUtility.getSVNFolder(resource) != null;
    }

    public static IResource getSVNFolder(IResource resource) {
        if (resource.getType() == 2 && SVNUtility.getSVNFolderName().equals(resource.getName())) {
            return resource;
        }
        IContainer parent = resource.getParent();
        return parent == null ? null : FileUtility.getSVNFolder((IResource)parent);
    }

    public static void findAndMarkSVNInternals(IResource node, boolean isTeamPrivate) throws CoreException {
        if (node instanceof IContainer && !FileUtility.isLinked(node)) {
            if (SVNUtility.getSVNFolderName().equals(node.getName()) && node.isTeamPrivateMember() != isTeamPrivate) {
                FileUtility.markSVNInternalsTree(node, isTeamPrivate);
            } else {
                IResource[] children = FileUtility.resourceMembers((IContainer)node, false);
                int i = 0;
                while (i < children.length) {
                    FileUtility.findAndMarkSVNInternals(children[i], isTeamPrivate);
                    ++i;
                }
            }
        }
    }

    public static boolean deleteRecursive(File node) {
        return FileUtility.deleteRecursive(node, null);
    }

    public static boolean deleteRecursive(File node, IProgressMonitor monitor) {
        File[] files;
        if (node.isDirectory() && (files = node.listFiles()) != null) {
            int i = 0;
            while (!(i >= files.length || monitor != null && monitor.isCanceled())) {
                FileUtility.deleteRecursive(files[i], monitor);
                ++i;
            }
        }
        return node.delete();
    }

    public static void copyAll(File to, File what, IProgressMonitor monitor) throws Exception {
        FileUtility.copyAll(to, what, false, monitor);
    }

    public static void copyAll(File to, File what, boolean ignoreExistingFolders, IProgressMonitor monitor) throws Exception {
        FileUtility.copyAll(to, what, ignoreExistingFolders ? 1 : 0, null, monitor);
    }

    public static void copyAll(File to, File what, int options, FileFilter filter, IProgressMonitor monitor) throws Exception {
        if (what.isDirectory()) {
            to = new File(String.valueOf(to.getAbsolutePath()) + "/" + what.getName());
            if (monitor.isCanceled()) {
                return;
            }
            if (!to.mkdirs() && (options & 1) == 0) {
                String errMessage = SVNMessages.formatErrorString("Error_CreateDirectory", new String[]{to.getAbsolutePath()});
                throw new Exception(errMessage);
            }
            File[] files = what.listFiles(filter);
            if (files != null) {
                int i = 0;
                while (i < files.length && !monitor.isCanceled()) {
                    FileUtility.copyAll(to, files[i], options, filter, monitor);
                    ++i;
                }
            }
        } else {
            FileUtility.copyFile(to, what, options, monitor);
        }
    }

    public static boolean copyFile(File to, File what, IProgressMonitor monitor) throws Exception {
        return FileUtility.copyFile(to, what, 2, monitor);
    }

    public static boolean copyFile(File to, File what, int options, IProgressMonitor monitor) throws Exception {
        if (!what.exists()) {
            return false;
        }
        if (to.exists() && to.isDirectory()) {
            to = new File(String.valueOf(to.getAbsolutePath()) + "/" + what.getName());
        }
        if (!(to.exists() && (options & 2) == 0 || monitor.isCanceled())) {
            FileInputStream input;
            block18: {
                File parent = to.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                FileOutputStream output = null;
                input = null;
                try {
                    output = new FileOutputStream(to);
                    input = new FileInputStream(what);
                    byte[] buf = new byte[2048];
                    int loaded = 0;
                    while ((loaded = input.read(buf)) > 0 && !monitor.isCanceled()) {
                        output.write(buf, 0, loaded);
                    }
                    if (output == null) break block18;
                }
                catch (Throwable throwable) {
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                try {
                    output.close();
                }
                catch (Exception exception) {}
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
            return true;
        }
        return false;
    }

    public static void removeSVNMetaInformation(IResource root, IProgressMonitor monitor) throws CoreException {
        final ArrayList toRemove = new ArrayList();
        root.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (SVNUtility.getSVNFolderName().equals(resource.getName()) && !FileUtility.isLinked(resource)) {
                    toRemove.add(resource);
                    return false;
                }
                return !FileUtility.isNotSupervised(resource);
            }
        }, 2, 3);
        for (IResource resource : toRemove) {
            FileUtility.deleteRecursive(new File(resource.getLocation().toString()));
        }
    }

    public static boolean alreadyOnSVN(IResource root) {
        return SVNUtility.getSVNInfoForNotConnected(root) != null;
    }

    public static boolean isConnected(IResource resource) {
        if (resource.getProject() != null) {
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resource.getProject());
            return provider != null && provider instanceof SVNTeamProvider;
        }
        return false;
    }

    public static IResource[] getPathNodes(IResource resource) {
        return FileUtility.getPathNodes(new IResource[]{resource});
    }

    public static IResource[] getPathNodes(IResource[] resources) {
        HashSet<IResource> tmp = new HashSet<IResource>(Arrays.asList(resources));
        HashSet<IResource> modifiedRoots = new HashSet<IResource>();
        IWorkspaceRoot wRoot = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < resources.length) {
            IResource root = resources[i];
            while ((root = root.getParent()) != wRoot) {
                if (tmp.contains(root)) break;
                modifiedRoots.add(root);
            }
            ++i;
        }
        return modifiedRoots.toArray(new IResource[modifiedRoots.size()]);
    }

    public static void reorder(IResource[] resources, final boolean parent2Child) {
        Arrays.sort(resources, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String first = ((IResource)o1).getFullPath().toString();
                String second = ((IResource)o2).getFullPath().toString();
                return parent2Child ? first.compareTo(second) : second.compareTo(first);
            }
        });
    }

    public static void reorder(File[] files, final boolean parent2Child) {
        Arrays.sort(files, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String first = ((File)o1).getAbsolutePath();
                String second = ((File)o2).getAbsolutePath();
                return parent2Child ? first.compareTo(second) : second.compareTo(first);
            }
        });
    }

    public static IResource[] shrinkChildNodesWithSwitched(IResource[] resources) {
        HashSet<IResource> resourcesSet = new HashSet<IResource>();
        HashSet<IResource> switchedResourcesSet = new HashSet<IResource>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
            if ((local.getChangeMask() & 8) == 0) {
                resourcesSet.add(resource);
            } else {
                switchedResourcesSet.add(resource);
            }
            ++n2;
        }
        HashSet<IResource> tRoots = new HashSet<IResource>(Arrays.asList(resources));
        int i = 0;
        while (i < resources.length) {
            HashSet<IResource> roots;
            HashSet<IResource> hashSet = roots = resourcesSet.contains(resources[i]) ? resourcesSet : switchedResourcesSet;
            if (!roots.isEmpty() && FileUtility.hasRoots(roots, resources[i])) {
                tRoots.remove(resources[i]);
            }
            ++i;
        }
        return tRoots.toArray(new IResource[tRoots.size()]);
    }

    public static IResource[] shrinkChildNodes(IResource[] resources) {
        HashSet<IResource> tRoots = new HashSet<IResource>(Arrays.asList(resources));
        int i = 0;
        while (i < resources.length) {
            if (FileUtility.hasRoots(tRoots, resources[i])) {
                tRoots.remove(resources[i]);
            }
            ++i;
        }
        return tRoots.toArray(new IResource[tRoots.size()]);
    }

    public static File[] shrinkChildNodes(File[] files, boolean skipFiles) {
        HashSet<File> tRoots = new HashSet<File>(Arrays.asList(files));
        int i = 0;
        while (i < files.length) {
            if (!(skipFiles && files[i].isFile() || !FileUtility.hasRoots(tRoots, files[i]))) {
                tRoots.remove(files[i]);
            }
            ++i;
        }
        return tRoots.toArray(new File[tRoots.size()]);
    }

    public static IResource[] resourceMembers(IContainer node, boolean includePhantoms) throws CoreException {
        block3: {
            if (node.isAccessible()) {
                try {
                    return node.members(includePhantoms);
                }
                catch (CoreException ex) {
                    if (!node.isAccessible()) break block3;
                    throw ex;
                }
            }
        }
        return new IResource[0];
    }

    public static String getNamesListAsString(Object[] resources) {
        String resourcesNames = "";
        String name = "";
        int i = 0;
        while (i < resources.length) {
            if (i == 4) {
                resourcesNames = String.valueOf(resourcesNames) + "...";
                break;
            }
            name = resources[i] instanceof IRepositoryResource ? ((IRepositoryResource)resources[i]).getName() : (resources[i] instanceof IResource ? ((IResource)resources[i]).getName() : resources[i].toString());
            resourcesNames = String.valueOf(resourcesNames) + (i == 0 ? "'" : ", '") + name + "'";
            ++i;
        }
        return resourcesNames;
    }

    public static boolean hasNature(IResource resource, String natureId) throws CoreException {
        IProject project = resource.getProject();
        if (project == null) {
            return false;
        }
        String[] natureIds = project.getDescription().getNatureIds();
        int i = 0;
        while (i < natureIds.length) {
            if (natureId.equals(natureIds[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasRoots(Set<IResource> roots, IResource node) {
        while ((node = node.getParent()) != null) {
            if (!roots.contains(node)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasRoots(Set<File> roots, File node) {
        while ((node = node.getParentFile()) != null) {
            if (!roots.contains(node)) continue;
            return true;
        }
        return false;
    }

    private static void markSVNInternalsTree(IResource node, boolean isTeamPrivate) throws CoreException {
        if (node.exists()) {
            if (node instanceof IContainer) {
                IResource[] children = FileUtility.resourceMembers((IContainer)node, false);
                int i = 0;
                while (i < children.length) {
                    FileUtility.markSVNInternalsTree(children[i], isTeamPrivate);
                    ++i;
                }
            }
            node.setTeamPrivateMember(isTeamPrivate);
        }
    }

    private static void addChildren(Set<IResource> resources, IResource[] roots, IStateFilter filter, int depth, IActionOperation calledFrom, IProgressMonitor monitor) {
        if (roots == null || roots.length == 0) {
            return;
        }
        int nextDepth = depth == 1 ? 0 : 2;
        int i = 0;
        while (!(i >= roots.length || monitor != null && monitor.isCanceled())) {
            if (!FileUtility.isNotSupervised(roots[i])) {
                ILocalResource local;
                if (monitor != null) {
                    String path = roots[i].getFullPath().toString();
                    if (calledFrom != null) {
                        ProgressMonitorUtility.setTaskInfo(monitor, calledFrom, path);
                    } else {
                        monitor.subTask(path);
                    }
                    ProgressMonitorUtility.progress(monitor, 1, -1);
                }
                if (filter.accept(local = SVNRemoteStorage.instance().asLocalResource(roots[i]))) {
                    resources.add(roots[i]);
                }
                if (roots[i] instanceof IContainer && depth != 0 && filter.allowsRecursion(local)) {
                    FileUtility.addChildren(resources, FileUtility.getAllMembers((IContainer)roots[i]), filter, nextDepth, calledFrom, monitor);
                }
            }
            ++i;
        }
    }

    private static IResource[] getAllMembers(IContainer root) {
        GetAllResourcesOperation op = new GetAllResourcesOperation(root);
        ProgressMonitorUtility.doTaskExternalDefault(op, (IProgressMonitor)new NullProgressMonitor());
        return op.getChildren();
    }

    private FileUtility() {
    }
}

