/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.common;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.CommentComposite;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.properties.bugtraq.BugtraqModel;

public class CommentPanel
extends AbstractDialogPanel {
    protected CommentComposite comment;
    protected BugtraqModel bugtraqModel;
    protected String message;

    public CommentPanel(String title) {
        this.dialogTitle = title;
        this.dialogDescription = SVNUIMessages.CommentPanel_Description;
        this.defaultMessage = SVNUIMessages.CommentPanel_Message;
    }

    public CommentPanel(String title, BugtraqModel bugtraqModel) {
        this(title);
        this.bugtraqModel = bugtraqModel;
    }

    public String getMessage() {
        if (this.comment != null) {
            this.message = this.comment.getMessage();
        }
        return this.appendBugtraqMessage(this.message);
    }

    public void setMessage(String message) {
        this.message = message;
        if (this.comment != null) {
            this.comment.setMessage(message);
        }
    }

    public void createControlsImpl(Composite parent) {
        this.comment = new CommentComposite(parent, this);
        GridData data = new GridData(1808);
        this.comment.setLayoutData(data);
    }

    protected Point getPrefferedSizeImpl() {
        return new Point(510, -1);
    }

    public void postInit() {
        super.postInit();
        this.comment.postInit(this.manager);
        if (this.message != null) {
            this.comment.setMessage(this.message);
        }
    }

    protected void saveChangesImpl() {
        this.comment.saveChanges();
    }

    protected void cancelChangesImpl() {
        this.comment.cancelChanges();
    }

    protected String appendBugtraqMessage(String message) {
        String addString;
        String bugtraqMessage;
        if (this.bugtraqModel != null && (bugtraqMessage = this.bugtraqModel.getMessage()) != null && (addString = this.comment.getBugID()) != null && addString.trim().length() > 0) {
            bugtraqMessage = bugtraqMessage.replaceAll("%BUGID%", addString);
            message = this.bugtraqModel.isAppend() ? String.valueOf(message) + "\n" + bugtraqMessage : String.valueOf(bugtraqMessage) + "\n" + message;
        }
        return message;
    }
}

