/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.android.ui;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.thym.android.core.adt.AndroidSDKManager;
import org.eclipse.thym.ui.launch.HybridProjectLaunchShortcut;

public class AndroidEmulatorLaunchShortcut
extends HybridProjectLaunchShortcut {
    protected boolean validateBuildToolsReady() throws CoreException {
        AndroidSDKManager sdkManager = AndroidSDKManager.getManager();
        List targets = sdkManager.listTargets();
        if (targets == null || targets.isEmpty()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.android.ui", "No targets to build against"));
        }
        return true;
    }

    protected String getLaunchConfigurationTypeID() {
        return "org.eclipse.thym.android.core.AndroidLaunchConfigurationType";
    }

    protected void updateLaunchConfiguration(ILaunchConfigurationWorkingCopy wc) {
        wc.setAttribute("org.eclipse.thym.android.core.ATTR_IS_DEVICE_LAUNCH", false);
        super.updateLaunchConfiguration(wc);
    }

    protected boolean isCorrectLaunchConfiguration(IProject project, ILaunchConfiguration config) throws CoreException {
        if (config.getAttribute("org.eclipse.thym.android.core.ATTR_IS_DEVICE_LAUNCH", false)) {
            return false;
        }
        return super.isCorrectLaunchConfiguration(project, config);
    }

    protected String getLaunchConfigurationNamePrefix(IProject project) {
        return String.valueOf(project.getName()) + " (Android Emulator)";
    }
}

