/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.android.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.thym.android.ui.internal.preferences.AndroidPreferences;
import org.eclipse.thym.android.ui.internal.statushandler.MissingSDKStatusHandler;
import org.eclipse.thym.core.HybridMobileStatus;

public class SDKLocationHelper {
    public static boolean defineSDKLocationIfNecessary() {
        if (SDKLocationHelper.isSDKLocationDefined()) {
            return true;
        }
        MissingSDKStatusHandler handler = new MissingSDKStatusHandler();
        handler.handle((IStatus)SDKLocationHelper.makeNoSDKLocationStatus());
        return SDKLocationHelper.isSDKLocationDefined();
    }

    public static String getSDKLocation() {
        if (SDKLocationHelper.isSDKLocationDefined()) {
            return AndroidPreferences.getPrefs().getAndroidSDKLocation();
        }
        return null;
    }

    public static boolean isSDKLocationDefined() {
        String sdkLocation = AndroidPreferences.getPrefs().getAndroidSDKLocation();
        return sdkLocation != null && sdkLocation.length() > 0;
    }

    public static HybridMobileStatus makeNoSDKLocationStatus() {
        return new HybridMobileStatus(4, "org.eclipse.thym.android.core", 200, "Android SDK location is not defined", null);
    }
}

