/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.extensions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.thym.core.HybridCore;

public abstract class ExtensionPointProxy {
    protected IContributor contributor;

    ExtensionPointProxy(IConfigurationElement element) {
        this.setContributor(element.getContributor());
    }

    protected void setContributor(IContributor contributor) {
        this.contributor = contributor;
    }

    public static <T extends ExtensionPointProxy> List<T> getNativeExtensionPointProxy(String extensionPointID, Class<T> clazz) {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPointID);
        ArrayList<ExtensionPointProxy> proxies = new ArrayList<ExtensionPointProxy>();
        int i = 0;
        while (i < configElements.length) {
            try {
                ExtensionPointProxy proxy = (ExtensionPointProxy)clazz.getDeclaredConstructor(IConfigurationElement.class).newInstance(configElements[i]);
                proxies.add(proxy);
            }
            catch (Exception e) {
                HybridCore.log(4, "Error instantiating ExtensionPointProxy object", e);
            }
            ++i;
        }
        return proxies;
    }
}

