/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.internal.util;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.thym.core.HybridCore;

public class HttpUtil {
    public static void setupProxy(final DefaultHttpClient client) {
        client.setRoutePlanner(new HttpRoutePlanner(){

            public HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
                HttpRoute route = ConnRouteParams.getForcedRoute((HttpParams)request.getParams());
                if (route != null) {
                    return route;
                }
                Scheme scheme = client.getConnectionManager().getSchemeRegistry().getScheme(target);
                boolean secure = scheme.isLayered();
                HttpHost host = null;
                try {
                    IProxyData[] proxyDatas;
                    IProxyData[] iProxyDataArray = proxyDatas = HttpUtil.getEclipseProxyData(new URI(target.toURI()));
                    int n = proxyDatas.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProxyData data = iProxyDataArray[n2];
                        if (data.getType().equals("HTTP")) {
                            host = new HttpHost(data.getHost(), data.getPort());
                            break;
                        }
                        ++n2;
                    }
                }
                catch (URISyntaxException e) {
                    HybridCore.log(4, "Incorrect URI", e);
                }
                if (host == null) {
                    return new HttpRoute(target, null, secure);
                }
                return new HttpRoute(target, null, host, secure);
            }
        });
    }

    public static IProxyData[] getEclipseProxyData(URI uri) {
        IProxyService proxyService = HybridCore.getDefault().getProxyService();
        if (proxyService == null) {
            return new IProxyData[0];
        }
        return proxyService.select(uri);
    }
}

