/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ios.core.pbxproject;

import com.dd.plist.ASCIIPropertyListParser;
import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListParser;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.thym.ios.core.pbxproject.PBXFile;
import org.eclipse.thym.ios.core.pbxproject.PBXProjectException;

public class PBXProject {
    private static final String KEY_LIBRARY_SEARCH_PATHS = "LIBRARY_SEARCH_PATHS";
    private final File file;
    private NSDictionary root;

    public PBXProject(File pbxfile) {
        this.file = pbxfile;
    }

    public void addSourceFile(PBXFile file) throws PBXProjectException {
        this.addPluginFile(file);
        this.addToPbxBuildFileSection(file);
        this.addToBuildPhase("PBXSourcesBuildPhase", file);
    }

    public void addPluginFile(PBXFile file) throws PBXProjectException {
        String path;
        int index;
        file.setPlugin(true);
        NSDictionary pluginsGroup = this.getGroupByName("Plugins");
        if (pluginsGroup.containsKey("path") && (index = (path = file.getPath()).indexOf("Plugins/")) > -1) {
            file.setPath(path.substring(index + "Plugins/".length()));
        }
        this.addToPbxFileReferenceSection(file);
        this.addToPbxGroup("Plugins", file);
    }

    public void addFramework(PBXFile file) throws PBXProjectException {
        file.setFramework(true);
        this.addToPbxBuildFileSection(file);
        this.addToPbxFileReferenceSection(file);
        this.addToPbxGroup("Frameworks", file);
        this.addToBuildPhase("PBXFrameworksBuildPhase", file);
    }

    public void addHeaderFile(PBXFile file) throws PBXProjectException {
        this.addPluginFile(file);
    }

    public void addResourceFile(PBXFile file) throws PBXProjectException {
        String path;
        int index;
        NSDictionary resGroup;
        if (file.isPlugin()) {
            this.addPluginFile(file);
        }
        if (!file.isPlugin() && (resGroup = this.getGroupByName("Resources")).containsKey("path") && (index = (path = file.getPath()).indexOf("Resources/")) > -1) {
            file.setPath(path.substring(index + "Resources/".length()));
        }
        this.addToPbxBuildFileSection(file);
        this.addToBuildPhase("PBXResourcesBuildPhase", file);
        if (!file.isPlugin()) {
            this.addToPbxFileReferenceSection(file);
            this.addToPbxGroup("Resources", file);
        }
    }

    public void addToLibrarySearchPaths(PBXFile pbxfile) throws PBXProjectException {
        HashMap hashmap = this.getObjects().getHashMap();
        Collection values = hashmap.values();
        for (NSObject nsObject : values) {
            NSDictionary obj = (NSDictionary)nsObject;
            NSString isa = (NSString)obj.objectForKey("isa");
            if (isa == null || !isa.getContent().equals("XCBuildConfiguration")) continue;
            NSDictionary buildSettings = (NSDictionary)obj.objectForKey("buildSettings");
            NSArray arr = null;
            if (buildSettings.containsKey(KEY_LIBRARY_SEARCH_PATHS)) {
                arr = (NSArray)buildSettings.objectForKey(KEY_LIBRARY_SEARCH_PATHS);
            }
            if (arr == null) {
                arr = new NSArray(new NSObject[]{NSObject.wrap((String)"$(inherited)"), this.searchPathForFile(pbxfile)});
            } else {
                NSObject[] current = arr.getArray();
                NSObject[] newArray = new NSObject[current.length + 1];
                System.arraycopy(current, 0, newArray, 0, current.length);
                newArray[newArray.length - 1] = this.searchPathForFile(pbxfile);
            }
            buildSettings.put(KEY_LIBRARY_SEARCH_PATHS, (NSObject)arr);
        }
    }

    private NSString searchPathForFile(PBXFile pbxfile) throws PBXProjectException {
        String filepath = FilenameUtils.getFullPathNoEndSeparator((String)pbxfile.getPath());
        filepath = filepath.equals(".") ? "" : "/" + filepath;
        NSDictionary group = this.getGroupByName("Plugins");
        if (pbxfile.isPlugin() && group.containsKey("path")) {
            NSString groupPath = (NSString)group.objectForKey("path");
            return NSObject.wrap((String)("$(SRCROOT)/" + groupPath.getContent().replace('\"', ' ').trim()));
        }
        return NSObject.wrap((String)("$(SRCROOT)/" + this.getProductName() + filepath));
    }

    public String getProductName() throws PBXProjectException {
        HashMap hashmap = this.getObjects().getHashMap();
        Collection values = hashmap.values();
        for (NSObject nsObject : values) {
            NSDictionary buildSettings;
            NSDictionary obj = (NSDictionary)nsObject;
            NSString isa = (NSString)obj.objectForKey("isa");
            if (isa == null || !isa.getContent().equals("XCBuildConfiguration") || !(buildSettings = (NSDictionary)obj.objectForKey("buildSettings")).containsKey("PRODUCT_NAME")) continue;
            NSString name = (NSString)buildSettings.get((Object)"PRODUCT_NAME");
            return name.getContent().replace('\"', ' ').trim();
        }
        return null;
    }

    public String getContent() throws PBXProjectException {
        return this.getRoot().toASCIIPropertyList();
    }

    public void persist() throws IOException, PBXProjectException {
        PropertyListParser.saveAsASCII((NSDictionary)this.getRoot(), (File)this.file);
    }

    private void addToBuildPhase(String phaseName, PBXFile pbxfile) throws PBXProjectException {
        NSDictionary phase = this.getPhaseByName(phaseName);
        NSArray files = (NSArray)phase.objectForKey("files");
        NSObject[] current = files.getArray();
        NSObject[] newArray = new NSObject[current.length + 1];
        System.arraycopy(current, 0, newArray, 0, current.length);
        newArray[newArray.length - 1] = new NSString(pbxfile.getUuid());
        NSArray newNSArray = new NSArray(newArray);
        phase.remove("files");
        phase.put("files", (NSObject)newNSArray);
    }

    private void addToPbxBuildFileSection(PBXFile pbxfile) throws PBXProjectException {
        NSDictionary obj = new NSDictionary();
        obj.put("isa", "PBXBuildFile");
        obj.put("fileRef", pbxfile.getFileRef());
        if (pbxfile.hasSettings()) {
            NSDictionary settings = new NSDictionary();
            if (pbxfile.isWeak()) {
                NSArray attribs = new NSArray(new NSObject[]{NSObject.wrap((String)"Weak")});
                settings.put("ATTRIBUTES", (NSObject)attribs);
            }
            if (pbxfile.getCompilerFlags() != null) {
                settings.put("COMPILER_FLAGS", (NSObject)NSObject.wrap((String)pbxfile.getCompilerFlags()));
            }
            obj.put("settings", (NSObject)settings);
        }
        this.getObjects().put(pbxfile.getUuid(), (NSObject)obj);
    }

    private void addToPbxGroup(String groupName, PBXFile pbxfile) throws PBXProjectException {
        NSDictionary group = this.getGroupByName(groupName);
        NSArray children = (NSArray)group.objectForKey("children");
        NSObject[] childs = children.getArray();
        NSObject[] newChilds = new NSObject[childs.length + 1];
        System.arraycopy(childs, 0, newChilds, 0, childs.length);
        newChilds[newChilds.length - 1] = new NSString(pbxfile.getFileRef());
        NSArray newArray = new NSArray(newChilds);
        group.remove("children");
        group.put("children", (NSObject)newArray);
    }

    private void addToPbxFileReferenceSection(PBXFile pbxfile) throws PBXProjectException {
        NSDictionary obj = new NSDictionary();
        obj.put("isa", "PBXFileReference");
        obj.put("lastKnownFileType", pbxfile.getLastType());
        obj.put("path", pbxfile.getPath());
        obj.put("name", FilenameUtils.getName((String)pbxfile.getPath()));
        obj.put("sourceTree", pbxfile.getSourceTree());
        if (pbxfile.getEncoding() != null) {
            obj.put("fileEncoding", pbxfile.getEncoding());
        }
        this.getObjects().put(pbxfile.getFileRef(), (NSObject)obj);
    }

    private NSDictionary getRoot() throws PBXProjectException {
        if (this.root == null) {
            try {
                this.root = (NSDictionary)ASCIIPropertyListParser.parse((File)this.file);
            }
            catch (Exception e) {
                throw new PBXProjectException(e);
            }
        }
        return this.root;
    }

    private NSDictionary getObjects() throws PBXProjectException {
        NSDictionary dict = this.getRoot();
        NSDictionary objects = (NSDictionary)dict.getHashMap().get("objects");
        return objects;
    }

    private NSDictionary getPhaseByName(String name) throws PBXProjectException {
        NSDictionary objects = this.getObjects();
        HashMap map = objects.getHashMap();
        Collection values = map.values();
        for (NSObject nsObject : values) {
            NSDictionary obj = (NSDictionary)nsObject;
            NSString isa = (NSString)obj.objectForKey("isa");
            if (isa == null || !isa.getContent().equals(name)) continue;
            return obj;
        }
        return null;
    }

    private NSDictionary getGroupByName(String name) throws PBXProjectException {
        NSDictionary objects = this.getObjects();
        HashMap map = objects.getHashMap();
        Collection values = map.values();
        for (NSObject nsObject : values) {
            NSDictionary obj = (NSDictionary)nsObject;
            NSString isa = (NSString)obj.objectForKey("isa");
            NSString nameString = (NSString)obj.objectForKey("name");
            if (isa == null || !isa.getContent().equals("PBXGroup") || nameString == null || !name.equals(nameString.getContent())) continue;
            return obj;
        }
        return null;
    }

    public static String generateReference() {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            SecureRandom prng = SecureRandom.getInstance("SHA1PRNG");
            String randomNum = Integer.toString(prng.nextInt());
            String ref = new String(Hex.encodeHex((byte[])md.digest(randomNum.getBytes())));
            return ref.toUpperCase().substring(0, 24);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }
}

