/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.wizard.export;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.extensions.NativeProjectBuilder;
import org.eclipse.thym.core.platform.AbstractNativeBinaryBuildDelegate;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.internal.status.StatusManager;
import org.eclipse.thym.ui.wizard.export.NativeBinaryDestinationPage;
import org.eclipse.thym.ui.wizard.export.NativeBinaryExportOperation;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class NativeBinaryExportWizard
extends Wizard
implements IExportWizard {
    private static final String DIALOG_SETTINGS_KEY = "NativeBinaryExportWizard";
    private NativeBinaryDestinationPage pageOne;
    private IStructuredSelection initialSelection;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("Export Mobile Application");
        this.setNeedsProgressMonitor(true);
        this.initialSelection = selection;
        IDialogSettings workbenchSettings = HybridUI.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
        this.setDialogSettings(section);
    }

    public boolean performFinish() {
        List<HybridProject> projects = this.pageOne.getSelectedProjects();
        List<NativeProjectBuilder> builders = this.pageOne.getSelectedPlatforms();
        ArrayList<AbstractNativeBinaryBuildDelegate> delegates = new ArrayList<AbstractNativeBinaryBuildDelegate>();
        for (HybridProject hybridProject : projects) {
            for (NativeProjectBuilder nativeProjectBuilder : builders) {
                try {
                    AbstractNativeBinaryBuildDelegate dlg = nativeProjectBuilder.createDelegate(hybridProject.getProject(), null);
                    delegates.add(dlg);
                }
                catch (CoreException e) {
                    HybridCore.log((int)4, (String)("Error creating native binary builder delegate for " + nativeProjectBuilder.getPlatform()), (Throwable)e);
                }
            }
        }
        NativeBinaryExportOperation op = new NativeBinaryExportOperation(delegates, new File(this.pageOne.getDestinationDirectory()), this.pageOne);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                if (e.getTargetException() instanceof CoreException) {
                    StatusManager.handle((CoreException)e.getTargetException());
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)"Error exporting mobile application", null, (IStatus)new Status(4, "org.eclipse.thym.ui", "Error while exporting mobile application", e.getTargetException()));
                    return false;
                }
            }
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        this.savePageSettings();
        return true;
    }

    public void addPages() {
        super.addPages();
        this.pageOne = new NativeBinaryDestinationPage("Export Mobile Application", this.initialSelection);
        this.pageOne.setTitle("Export Mobile Application");
        this.pageOne.setDescription("Builds a mobile application that can be installed and run on a mobile device");
        this.addPage((IWizardPage)this.pageOne);
    }

    private void savePageSettings() {
        IDialogSettings workbenchSettings = HybridUI.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
        if (section == null) {
            section = workbenchSettings.addNewSection(DIALOG_SETTINGS_KEY);
        }
        this.setDialogSettings(section);
        this.pageOne.saveWidgetValues();
    }
}

