/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.wizard.project;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.core.plugin.CordovaPluginManager;
import org.eclipse.thym.core.plugin.FileOverwriteCallback;
import org.eclipse.thym.core.plugin.registry.CordovaRegistryPlugin;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.internal.status.StatusManager;
import org.eclipse.thym.ui.plugins.internal.CordovaPluginSelectionPage;
import org.eclipse.thym.ui.plugins.internal.ICordovaPluginWizard;
import org.eclipse.thym.ui.plugins.internal.RegistryConfirmPage;
import org.eclipse.thym.ui.wizard.project.EngineConfigurationPage;
import org.eclipse.thym.ui.wizard.project.HybridProjectCreator;
import org.eclipse.thym.ui.wizard.project.WizardNewHybridProjectCreationPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewHybridProjectWizard
extends Wizard
implements INewWizard,
ICordovaPluginWizard {
    private static final String IMAGE_WIZBAN = "/icons/wizban/newcordovaprj_wiz.png";
    private IWizardPage pageOne;
    private EngineConfigurationPage pageTwo;
    private CordovaPluginSelectionPage pageThree;
    private RegistryConfirmPage pageFour;
    private IStructuredSelection selection;

    public NewHybridProjectWizard() {
        this.setWindowTitle("Hybrid Mobile (Cordova) Application Project");
        this.setDefaultPageImageDescriptor(HybridUI.getImageDescriptor("org.eclipse.thym.ui", IMAGE_WIZBAN));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public boolean performFinish() {
        WorkspaceModifyOperation runnable = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                HybridProjectCreator creator = new HybridProjectCreator();
                WizardNewHybridProjectCreationPage page = (WizardNewHybridProjectCreationPage)NewHybridProjectWizard.this.pageOne;
                EngineConfigurationPage enginePage = NewHybridProjectWizard.this.pageTwo;
                try {
                    URI location = null;
                    if (!page.useDefaults()) {
                        location = page.getLocationURI();
                    }
                    String appName = page.getApplicationName();
                    String appID = page.getApplicationID();
                    HybridMobileEngine[] engines = enginePage.getSelectedEngines();
                    IProject project = creator.createBasicTemplatedProject(page.getProjectName(), location, appName, appID, engines, monitor);
                    NewHybridProjectWizard.this.installSelectedPlugins(project, monitor);
                    NewHybridProjectWizard.this.addToWorkingSets(project);
                    NewHybridProjectWizard.this.openAndSelectConfigFile(project);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                if (e.getTargetException() instanceof CoreException) {
                    StatusManager.handle((CoreException)e.getTargetException());
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)"Error creating project", null, (IStatus)new Status(4, "org.eclipse.thym.ui", "Project create error", e.getTargetException()));
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
        return true;
    }

    private void installSelectedPlugins(IProject project, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)project);
        HybridProject hybridProject = HybridProject.getHybridProject((IProject)project);
        FileOverwriteCallback cb = new FileOverwriteCallback(){

            public boolean isOverwiteAllowed(String[] files) {
                return true;
            }
        };
        CordovaPluginManager pm = new CordovaPluginManager(hybridProject);
        switch (this.pageThree.getPluginSourceType()) {
            case 3: {
                File directory = new File(this.pageThree.getSelectedDirectory());
                pm.installPlugin(directory, cb, monitor);
                break;
            }
            case 2: {
                URI uri = URI.create(this.pageThree.getSpecifiedGitURL());
                pm.installPlugin(uri, cb, false, monitor);
                break;
            }
            case 1: {
                List<CordovaRegistryPlugin.RegistryPluginVersion> plugins = this.pageFour.getSelectedPluginVersions();
                for (CordovaRegistryPlugin.RegistryPluginVersion cordovaRegistryPluginVersion : plugins) {
                    pm.installPlugin(cordovaRegistryPluginVersion, cb, false, monitor);
                }
                break;
            }
            default: {
                Assert.isTrue((boolean)false, (String)"No valid plugin source can be determined");
            }
        }
    }

    private void openAndSelectConfigFile(IProject project) {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        HybridProject hp = HybridProject.getHybridProject((IProject)project);
        IFile file = hp.getConfigFile();
        BasicNewResourceWizard.selectAndReveal((IResource)file, (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        try {
            IDE.openEditor((IWorkbenchPage)activePage, (IFile)file);
        }
        catch (PartInitException e) {
            HybridUI.log(4, "Error opening the config.xml", e);
        }
    }

    private void addToWorkingSets(IProject project) {
        IWorkingSet[] selectedWorkingSets = ((WizardNewHybridProjectCreationPage)this.pageOne).getSelectedWorkingSets();
        if (selectedWorkingSets == null || selectedWorkingSets.length == 0) {
            return;
        }
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        workingSetManager.addToWorkingSets((IAdaptable)project, selectedWorkingSets);
    }

    public void addPages() {
        super.addPages();
        this.pageOne = new WizardNewHybridProjectCreationPage(this.getWindowTitle(), this.selection);
        this.addPage(this.pageOne);
        this.pageTwo = new EngineConfigurationPage("Configure Engine");
        this.addPage((IWizardPage)this.pageTwo);
        this.pageThree = new CordovaPluginSelectionPage(true);
        this.addPage((IWizardPage)this.pageThree);
        this.pageFour = new RegistryConfirmPage();
        this.addPage((IWizardPage)this.pageFour);
    }

    @Override
    public WizardPage getRegistryConfirmPage() {
        return this.pageFour;
    }

    @Override
    public boolean isPluginSelectionOptional() {
        return true;
    }
}

