/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.wp.internal.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.thym.core.internal.util.ExternalProcessUtility;
import org.eclipse.thym.wp.core.WPCore;

public class WindowsRegistry {
    public static String readRegistry(String location, String key) throws CoreException {
        ExternalProcessUtility processUtility = new ExternalProcessUtility();
        ValueParser parser = new ValueParser(key);
        processUtility.execSync("reg query " + WindowsRegistry.addQuotes(location) + " /v " + WindowsRegistry.addQuotes(key), null, (IStreamListener)parser, (IStreamListener)parser, (IProgressMonitor)new NullProgressMonitor(), null, null);
        return parser.getValue();
    }

    public static String[] getChildren(String location) throws CoreException {
        ExternalProcessUtility processUtility = new ExternalProcessUtility();
        ChildrenParser parser = new ChildrenParser();
        processUtility.execSync("reg query " + WindowsRegistry.addQuotes(location), null, (IStreamListener)parser, (IStreamListener)parser, (IProgressMonitor)new NullProgressMonitor(), null, null);
        return parser.getChildren();
    }

    private static String addQuotes(String input) {
        return "\"" + input + "\"";
    }

    private static class ChildrenParser
    implements IStreamListener {
        private StringBuffer buffer = new StringBuffer();

        private ChildrenParser() {
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            this.buffer.append(text);
        }

        public String[] getChildren() {
            if (this.buffer == null || this.buffer.length() < 1) {
                return null;
            }
            StringReader reader = new StringReader(this.buffer.toString());
            BufferedReader read = new BufferedReader(reader);
            ArrayList<String> children = new ArrayList<String>();
            String line = null;
            try {
                while ((line = read.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    Path path = new Path(line.trim());
                    children.add(path.lastSegment());
                }
            }
            catch (IOException e) {
                WPCore.log(4, "Error parsing the String value from Windows Registry", e);
            }
            return children.toArray(new String[children.size()]);
        }
    }

    private static class ValueParser
    implements IStreamListener {
        private static final String REG_SZ = "REG_SZ";
        private StringBuffer buffer = new StringBuffer();
        private String key;

        public ValueParser(String key) {
            this.key = key;
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            this.buffer.append(text);
        }

        public String getValue() {
            if (this.buffer == null || this.buffer.length() < 1) {
                return null;
            }
            StringReader reader = new StringReader(this.buffer.toString());
            BufferedReader read = new BufferedReader(reader);
            String line = null;
            try {
                while ((line = read.readLine()) != null) {
                    if (!(line = line.trim()).startsWith(this.key) || line.indexOf(REG_SZ) == -1) continue;
                    String[] segments = line.split(REG_SZ);
                    return segments[1].trim();
                }
            }
            catch (IOException e) {
                WPCore.log(4, "Error parsing the String value from Windows Registry", e);
            }
            return null;
        }
    }
}

