/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers;

import org.eclipse.tracecompass.analysis.os.linux.core.kernel.StateValues;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.Attributes;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandlerUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;

public class SchedSwitchHandler
extends KernelEventHandler {
    public SchedSwitchHandler(IKernelAnalysisEventLayout layout) {
        super(layout);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event) throws AttributeNotFoundException {
        Integer cpu = KernelEventHandlerUtils.getCpu(event);
        if (cpu == null) {
            return;
        }
        ITmfEventField content = event.getContent();
        String prevProcessName = (String)NonNullUtils.checkNotNull((Object)((String)content.getField(new String[]{this.getLayout().fieldPrevComm()}).getValue()));
        Integer prevTid = ((Long)content.getField(new String[]{this.getLayout().fieldPrevTid()}).getValue()).intValue();
        Long prevState = (Long)NonNullUtils.checkNotNull((Object)((Long)content.getField(new String[]{this.getLayout().fieldPrevState()}).getValue()));
        Integer prevPrio = ((Long)content.getField(new String[]{this.getLayout().fieldPrevPrio()}).getValue()).intValue();
        String nextProcessName = (String)NonNullUtils.checkNotNull((Object)((String)content.getField(new String[]{this.getLayout().fieldNextComm()}).getValue()));
        Integer nextTid = ((Long)content.getField(new String[]{this.getLayout().fieldNextTid()}).getValue()).intValue();
        Integer nextPrio = ((Long)content.getField(new String[]{this.getLayout().fieldNextPrio()}).getValue()).intValue();
        String formerThreadAttributeName = Attributes.buildThreadAttributeName(prevTid, cpu);
        String currenThreadAttributeName = Attributes.buildThreadAttributeName(nextTid, cpu);
        int nodeThreads = KernelEventHandlerUtils.getNodeThreads(ss);
        int formerThreadNode = ss.getQuarkRelativeAndAdd(nodeThreads, new String[]{formerThreadAttributeName});
        int newCurrentThreadNode = ss.getQuarkRelativeAndAdd(nodeThreads, new String[]{currenThreadAttributeName});
        long timestamp = KernelEventHandlerUtils.getTimestamp(event);
        SchedSwitchHandler.setOldProcessStatus(ss, prevState, formerThreadNode, timestamp);
        KernelEventHandlerUtils.setProcessToRunning(timestamp, newCurrentThreadNode, ss);
        SchedSwitchHandler.setProcessExecName(ss, prevProcessName, formerThreadNode, timestamp);
        SchedSwitchHandler.setProcessExecName(ss, nextProcessName, newCurrentThreadNode, timestamp);
        SchedSwitchHandler.setProcessPrio(ss, prevPrio, formerThreadNode, timestamp);
        SchedSwitchHandler.setProcessPrio(ss, nextPrio, newCurrentThreadNode, timestamp);
        ss.getQuarkRelativeAndAdd(newCurrentThreadNode, new String[]{"System_call"});
        ss.getQuarkRelativeAndAdd(newCurrentThreadNode, new String[]{"PPID"});
        int currentCPUNode = KernelEventHandlerUtils.getCurrentCPUNode(cpu, ss);
        SchedSwitchHandler.setCpuProcess(ss, nextTid, timestamp, currentCPUNode);
        SchedSwitchHandler.setCpuStatus(ss, nextTid, newCurrentThreadNode, timestamp, currentCPUNode);
    }

    private static void setOldProcessStatus(ITmfStateSystemBuilder ss, Long prevState, Integer formerThreadNode, long timestamp) throws AttributeNotFoundException {
        int state = (int)(prevState & 0x3FFL);
        Object value = SchedSwitchHandler.isRunning(state) ? StateValues.PROCESS_STATUS_WAIT_FOR_CPU_VALUE : (SchedSwitchHandler.isWaiting(state) ? StateValues.PROCESS_STATUS_WAIT_BLOCKED_VALUE : (SchedSwitchHandler.isDead(state) ? TmfStateValue.nullValue() : StateValues.PROCESS_STATUS_WAIT_UNKNOWN_VALUE));
        int quark = ss.getQuarkRelativeAndAdd(formerThreadNode.intValue(), new String[]{"Status"});
        ss.modifyAttribute(timestamp, value, quark);
    }

    private static boolean isDead(int state) {
        return (state & 0x40) != 0;
    }

    private static boolean isWaiting(int state) {
        return (state & 3) != 0;
    }

    private static boolean isRunning(int state) {
        return state == 0;
    }

    private static void setCpuStatus(ITmfStateSystemBuilder ss, Integer nextTid, Integer newCurrentThreadNode, long timestamp, int currentCPUNode) throws AttributeNotFoundException {
        int quark;
        ITmfStateValue queryOngoingState;
        ITmfStateValue value = nextTid > 0 ? ((queryOngoingState = ss.queryOngoingState(quark = ss.getQuarkRelativeAndAdd(newCurrentThreadNode.intValue(), new String[]{"System_call"}))).isNull() ? StateValues.CPU_STATUS_RUN_USERMODE_VALUE : StateValues.CPU_STATUS_RUN_SYSCALL_VALUE) : StateValues.CPU_STATUS_IDLE_VALUE;
        quark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Status"});
        ss.modifyAttribute(timestamp, value, quark);
    }

    private static void setCpuProcess(ITmfStateSystemBuilder ss, Integer nextTid, long timestamp, int currentCPUNode) throws AttributeNotFoundException {
        int quark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Current_thread"});
        TmfStateValue value = TmfStateValue.newValueInt((int)nextTid);
        ss.modifyAttribute(timestamp, (ITmfStateValue)value, quark);
    }

    private static void setProcessPrio(ITmfStateSystemBuilder ss, Integer prio, Integer threadNode, long timestamp) throws AttributeNotFoundException {
        int quark = ss.getQuarkRelativeAndAdd(threadNode.intValue(), new String[]{"Prio"});
        TmfStateValue value = TmfStateValue.newValueInt((int)prio);
        ss.modifyAttribute(timestamp, (ITmfStateValue)value, quark);
    }

    private static void setProcessExecName(ITmfStateSystemBuilder ss, String processName, Integer threadNode, long timestamp) throws AttributeNotFoundException {
        int quark = ss.getQuarkRelativeAndAdd(threadNode.intValue(), new String[]{"Exec_name"});
        TmfStateValue value = TmfStateValue.newValueString((String)processName);
        ss.modifyAttribute(timestamp, (ITmfStateValue)value, quark);
    }
}

