/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.stream;

import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IEventHeaderDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.internal.ctf.core.Activator;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.Messages;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeSpecifierListParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.stream.StreamIdParser;
import org.eclipse.tracecompass.internal.ctf.core.trace.CTFStream;

public final class StreamDeclarationParser
extends AbstractScopedCommonTreeParser {
    private static final String IDENTIFIER_MUST_BE_A_STRING = "Left side of CTF assignment must be a string";
    private static final String PACKET_CONTEXT = "packet.context ";
    private static final String EVENT_CONTEXT = "event.context ";
    private static final String EVENT_HEADER = "event.header ";
    private static final String STREAM_ID = "stream id ";
    private static final String EXPECTS_A_STRUCT = "expects a struct";
    private static final String SCOPE_NOT_FOUND = "scope not found";
    private static final String EXPECTS_A_TYPE_SPECIFIER = "expects a type specifier";
    private static final String ALREADY_DEFINED = "already defined";
    public static final StreamDeclarationParser INSTANCE = new StreamDeclarationParser();

    private StreamDeclarationParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CTFStream parse(CommonTree streamDecl, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        DeclarationScope scope = ((Param)param).fDeclarationScope;
        CTFStream stream = ((Param)param).fStream;
        CTFTrace fTrace = ((Param)param).fTrace;
        CommonTree leftNode = (CommonTree)streamDecl.getChild(0);
        CommonTree rightNode = (CommonTree)streamDecl.getChild(1);
        List leftStrings = leftNode.getChildren();
        if (!TsdlUtils.isAnyUnaryString((CommonTree)leftStrings.get(0))) {
            throw new ParseException(IDENTIFIER_MUST_BE_A_STRING);
        }
        String left = TsdlUtils.concatenateUnaryStrings(leftStrings);
        if (left.equals("id")) {
            if (stream.isIdSet()) {
                throw new ParseException("stream id already defined");
            }
            long streamID = StreamIdParser.INSTANCE.parse(rightNode, null);
            stream.setId(streamID);
            return stream;
        } else if (left.equals("event.header")) {
            if (stream.isEventHeaderSet()) {
                throw new ParseException("event.header already defined");
            }
            CommonTree typeSpecifier = (CommonTree)rightNode.getChild(0);
            if (typeSpecifier.getType() != 115) {
                throw new ParseException("event.header expects a type specifier");
            }
            IDeclaration eventHeaderDecl = TypeSpecifierListParser.INSTANCE.parse(typeSpecifier, new TypeSpecifierListParser.Param(fTrace, null, null, scope));
            DeclarationScope eventHeaderScope = StreamDeclarationParser.lookupStructName(typeSpecifier, scope);
            if (eventHeaderScope == null) {
                throw new ParseException("event.header scope not found");
            }
            DeclarationScope eventScope = new DeclarationScope(scope, "event");
            eventScope.addChild(eventHeaderScope);
            eventHeaderScope.setName("header");
            if (eventHeaderDecl instanceof StructDeclaration) {
                stream.setEventHeader((StructDeclaration)eventHeaderDecl);
                return stream;
            } else {
                if (!(eventHeaderDecl instanceof IEventHeaderDeclaration)) throw new ParseException("event.header expects a struct");
                stream.setEventHeader((IEventHeaderDeclaration)eventHeaderDecl);
            }
            return stream;
        } else if (left.equals("event.context")) {
            if (stream.isEventContextSet()) {
                throw new ParseException("event.context already defined");
            }
            CommonTree typeSpecifier = (CommonTree)rightNode.getChild(0);
            if (typeSpecifier.getType() != 115) {
                throw new ParseException("event.context expects a type specifier");
            }
            IDeclaration eventContextDecl = TypeSpecifierListParser.INSTANCE.parse(typeSpecifier, new TypeSpecifierListParser.Param(fTrace, null, null, scope));
            if (!(eventContextDecl instanceof StructDeclaration)) {
                throw new ParseException("event.context expects a struct");
            }
            stream.setEventContext((StructDeclaration)eventContextDecl);
            return stream;
        } else if (left.equals("packet.context")) {
            if (stream.isPacketContextSet()) {
                throw new ParseException("packet.context already defined");
            }
            CommonTree typeSpecifier = (CommonTree)rightNode.getChild(0);
            if (typeSpecifier.getType() != 115) {
                throw new ParseException("packet.context expects a type specifier");
            }
            IDeclaration packetContextDecl = TypeSpecifierListParser.INSTANCE.parse(typeSpecifier, new TypeSpecifierListParser.Param(fTrace, null, null, scope));
            if (!(packetContextDecl instanceof StructDeclaration)) {
                throw new ParseException("packet.context expects a struct");
            }
            stream.setPacketContext((StructDeclaration)packetContextDecl);
            return stream;
        } else {
            Activator.log(2, String.valueOf(Messages.IOStructGen_UnknownStreamAttributeWarning) + ' ' + left);
        }
        return stream;
    }

    private static DeclarationScope lookupStructName(CommonTree typeSpecifier, DeclarationScope scope) {
        Tree potentialStructName;
        Tree potentialStruct = typeSpecifier.getChild(0);
        DeclarationScope eventHeaderScope = null;
        if (potentialStruct.getType() == 104 && (potentialStructName = potentialStruct.getChild(0)).getType() == 106) {
            String name = potentialStructName.getChild(0).getText();
            eventHeaderScope = scope.lookupChildRecursive(name);
        }
        if (eventHeaderScope == null) {
            eventHeaderScope = scope.lookupChildRecursive("struct");
        }
        return eventHeaderScope;
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final CTFStream fStream;
        private final CTFTrace fTrace;
        private final DeclarationScope fDeclarationScope;

        public Param(CTFTrace trace, CTFStream stream, DeclarationScope scope) {
            this.fTrace = trace;
            this.fStream = stream;
            this.fDeclarationScope = scope;
        }
    }
}

