/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.handlers;

import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.building.LttngKernelExecGraphProvider;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.handlers.BaseHandler;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.handlers.Messages;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.model.EventField;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.model.LttngSystemModel;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.model.LttngWorker;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class TraceEventHandlerSched
extends BaseHandler {
    public TraceEventHandlerSched(LttngKernelExecGraphProvider provider) {
        super(provider);
    }

    @Override
    public void handleEvent(ITmfEvent ev) {
        IKernelAnalysisEventLayout eventLayout;
        String eventName = ev.getName();
        if (eventName.equals((eventLayout = this.getProvider().getEventLayout(ev.getTrace())).eventSchedSwitch())) {
            this.handleSchedSwitch(ev);
        } else if (eventName.equals(eventLayout.eventSchedProcessFork())) {
            this.handleSchedProcessFork(ev);
        } else if (eventName.equals(eventLayout.eventSchedProcessExit())) {
            this.handleSchedProcessExit(ev);
        } else if (eventName.equals(eventLayout.eventSchedProcessExec())) {
            this.handleSchedProcessExec(ev);
        } else if (this.isWakeupEvent(ev)) {
            this.handleSchedWakeup(ev);
        }
    }

    private void handleSchedSwitch(ITmfEvent event) {
        Integer cpu = (Integer)NonNullUtils.checkNotNull((Object)TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event));
        IKernelAnalysisEventLayout eventLayout = this.getProvider().getEventLayout(event.getTrace());
        LttngSystemModel system = this.getProvider().getSystem();
        Integer next = EventField.getInt(event, eventLayout.fieldNextTid());
        Integer prev = EventField.getInt(event, eventLayout.fieldPrevTid());
        long ts = event.getTimestamp().getValue();
        long prev_state = EventField.getLong(event, eventLayout.fieldPrevState());
        prev_state = (long)((int)prev_state) & 3L;
        String host = event.getTrace().getHostId();
        system.cacheTidOnCpu(cpu, new HostThread(event.getTrace().getHostId(), next));
        HostThread nextHt = new HostThread(host, next);
        LttngWorker nextTask = system.findWorker(nextHt);
        if (nextTask == null) {
            String name = EventField.getOrDefault(event, eventLayout.fieldNextComm(), (String)NonNullUtils.checkNotNull((Object)Messages.TraceEventHandlerSched_UnknownThreadName));
            nextTask = new LttngWorker(nextHt, name, ts);
            system.addWorker(nextTask);
        }
        nextTask.setStatus(LttngKernelExecGraphProvider.ProcessStatus.RUN);
        HostThread prevHt = new HostThread(host, prev);
        LttngWorker prevTask = system.findWorker(prevHt);
        if (prevTask == null) {
            String name = EventField.getOrDefault(event, eventLayout.fieldPrevComm(), (String)NonNullUtils.checkNotNull((Object)Messages.TraceEventHandlerSched_UnknownThreadName));
            prevTask = new LttngWorker(prevHt, name, ts);
            system.addWorker(prevTask);
        }
        if (prev_state == 0L) {
            prevTask.setStatus(LttngKernelExecGraphProvider.ProcessStatus.WAIT_CPU);
        } else {
            prevTask.setStatus(LttngKernelExecGraphProvider.ProcessStatus.WAIT_BLOCKED);
        }
    }

    private void handleSchedProcessFork(ITmfEvent event) {
        String host = event.getTrace().getHostId();
        IKernelAnalysisEventLayout eventLayout = this.getProvider().getEventLayout(event.getTrace());
        LttngSystemModel system = this.getProvider().getSystem();
        Integer childTid = EventField.getInt(event, eventLayout.fieldChildTid());
        String name = EventField.getString(event, eventLayout.fieldChildComm());
        long ts = event.getTimestamp().getValue();
        HostThread childHt = new HostThread(host, childTid);
        LttngWorker childTask = system.findWorker(childHt);
        if (childTask == null) {
            childTask = new LttngWorker(childHt, name, ts);
            system.addWorker(childTask);
        }
        childTask.setStatus(LttngKernelExecGraphProvider.ProcessStatus.WAIT_FORK);
    }

    private void handleSchedWakeup(ITmfEvent event) {
        String host = event.getTrace().getHostId();
        Integer cpu = (Integer)NonNullUtils.checkNotNull((Object)TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event));
        IKernelAnalysisEventLayout eventLayout = this.getProvider().getEventLayout(event.getTrace());
        LttngSystemModel system = this.getProvider().getSystem();
        Integer tid = EventField.getInt(event, eventLayout.fieldTid());
        HostThread targetHt = new HostThread(host, tid);
        LttngWorker target = system.findWorker(targetHt);
        LttngWorker current = system.getWorkerOnCpu(host, cpu);
        if (target == null) {
            String name = EventField.getOrDefault(event, eventLayout.fieldComm(), (String)NonNullUtils.checkNotNull((Object)Messages.TraceEventHandlerSched_UnknownThreadName));
            target = new LttngWorker(targetHt, name, event.getTimestamp().getValue());
            system.addWorker(target);
            target.setStatus(LttngKernelExecGraphProvider.ProcessStatus.WAIT_BLOCKED);
        }
        LttngKernelExecGraphProvider.ProcessStatus status = target.getStatus();
        if (current != null && target.getHostThread().equals((Object)current.getHostThread()) || status == LttngKernelExecGraphProvider.ProcessStatus.WAIT_CPU) {
            return;
        }
        if (status == LttngKernelExecGraphProvider.ProcessStatus.WAIT_BLOCKED || status == LttngKernelExecGraphProvider.ProcessStatus.WAIT_FORK || status == LttngKernelExecGraphProvider.ProcessStatus.UNKNOWN) {
            target.setStatus(LttngKernelExecGraphProvider.ProcessStatus.WAIT_CPU);
            return;
        }
    }

    private void handleSchedProcessExit(ITmfEvent event) {
        Integer tid;
        String host = event.getTrace().getHostId();
        IKernelAnalysisEventLayout eventLayout = this.getProvider().getEventLayout(event.getTrace());
        LttngSystemModel system = this.getProvider().getSystem();
        LttngWorker task = system.findWorker(new HostThread(host, tid = EventField.getInt(event, eventLayout.fieldTid())));
        if (task == null) {
            return;
        }
        task.setStatus(LttngKernelExecGraphProvider.ProcessStatus.EXIT);
    }

    private void handleSchedProcessExec(ITmfEvent event) {
        String host = event.getTrace().getHostId();
        Integer cpu = (Integer)NonNullUtils.checkNotNull((Object)TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event));
        IKernelAnalysisEventLayout eventLayout = this.getProvider().getEventLayout(event.getTrace());
        LttngSystemModel system = this.getProvider().getSystem();
        String filename = EventField.getString(event, eventLayout.fieldFilename());
        LttngWorker task = system.getWorkerOnCpu(host, cpu);
        if (task == null) {
            return;
        }
        task.setName(filename);
    }
}

