/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.backend;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.interval.TmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

public class InMemoryBackend
implements IStateHistoryBackend {
    private static final Comparator<ITmfStateInterval> END_COMPARATOR = new Comparator<ITmfStateInterval>(){

        @Override
        public int compare(ITmfStateInterval o1, ITmfStateInterval o2) {
            long e1 = o1.getEndTime();
            long e2 = o2.getEndTime();
            int a1 = o1.getAttribute();
            int a2 = o2.getAttribute();
            if (e1 < e2) {
                return -1;
            }
            if (e1 > e2) {
                return 1;
            }
            if (a1 < a2) {
                return -1;
            }
            if (a1 > a2) {
                return 1;
            }
            return 0;
        }
    };
    private final @NonNull String ssid;
    private final NavigableSet<ITmfStateInterval> intervals;
    private final long startTime;
    private volatile long latestTime;

    public InMemoryBackend(@NonNull String ssid, long startTime) {
        this.ssid = ssid;
        this.startTime = startTime;
        this.latestTime = startTime;
        this.intervals = new TreeSet<ITmfStateInterval>(END_COMPARATOR);
    }

    @Override
    public String getSSID() {
        return this.ssid;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getEndTime() {
        return this.latestTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertPastState(long stateStartTime, long stateEndTime, int quark, ITmfStateValue value) throws TimeRangeException {
        if (stateStartTime > stateEndTime || stateStartTime < this.startTime) {
            throw new TimeRangeException(String.valueOf(this.ssid) + " Interval Start:" + stateStartTime + ", Interval End:" + stateEndTime + ", Backend Start:" + this.startTime);
        }
        TmfStateInterval interval = new TmfStateInterval(stateStartTime, stateEndTime, quark, value);
        NavigableSet<ITmfStateInterval> navigableSet = this.intervals;
        synchronized (navigableSet) {
            this.intervals.add(interval);
        }
        if (stateEndTime > this.latestTime) {
            this.latestTime = stateEndTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doQuery(List<ITmfStateInterval> currentStateInfo, long t) throws TimeRangeException {
        if (!this.checkValidTime(t)) {
            throw new TimeRangeException(String.valueOf(this.ssid) + " Time:" + t + ", Start:" + this.startTime + ", End:" + this.latestTime);
        }
        NavigableSet<ITmfStateInterval> navigableSet = this.intervals;
        synchronized (navigableSet) {
            Iterator<ITmfStateInterval> iter = InMemoryBackend.searchforEndTime(this.intervals, t);
            int modCount = 0;
            while (iter.hasNext() && modCount < currentStateInfo.size()) {
                ITmfStateInterval entry = iter.next();
                long entryStartTime = entry.getStartTime();
                if (entryStartTime > t) continue;
                currentStateInfo.set(entry.getAttribute(), entry);
                ++modCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITmfStateInterval doSingularQuery(long t, int attributeQuark) throws TimeRangeException {
        if (!this.checkValidTime(t)) {
            throw new TimeRangeException(String.valueOf(this.ssid) + " Time:" + t + ", Start:" + this.startTime + ", End:" + this.latestTime);
        }
        NavigableSet<ITmfStateInterval> navigableSet = this.intervals;
        synchronized (navigableSet) {
            Iterator<ITmfStateInterval> iter = InMemoryBackend.searchforEndTime(this.intervals, t);
            while (iter.hasNext()) {
                ITmfStateInterval entry = iter.next();
                boolean attributeMatches = entry.getAttribute() == attributeQuark;
                long entryStartTime = entry.getStartTime();
                if (!attributeMatches || entryStartTime > t) continue;
                return entry;
            }
        }
        return null;
    }

    private boolean checkValidTime(long t) {
        return t >= this.startTime && t <= this.latestTime;
    }

    @Override
    public void finishedBuilding(long endTime) throws TimeRangeException {
    }

    @Override
    public FileInputStream supplyAttributeTreeReader() {
        return null;
    }

    @Override
    public File supplyAttributeTreeWriterFile() {
        return null;
    }

    @Override
    public long supplyAttributeTreeWriterFilePosition() {
        return -1L;
    }

    @Override
    public void removeFiles() {
    }

    @Override
    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void debugPrint(PrintWriter writer) {
        NavigableSet<ITmfStateInterval> navigableSet = this.intervals;
        synchronized (navigableSet) {
            writer.println(this.intervals.toString());
        }
    }

    private static Iterator<ITmfStateInterval> searchforEndTime(NavigableSet<ITmfStateInterval> tree, long time) {
        TmfStateInterval dummyInterval = new TmfStateInterval(-1L, time, -1, TmfStateValue.nullValue());
        ITmfStateInterval myInterval = tree.lower(dummyInterval);
        if (myInterval == null) {
            return tree.iterator();
        }
        SortedSet<ITmfStateInterval> tailSet = tree.tailSet(myInterval);
        Iterator<ITmfStateInterval> retVal = tailSet.iterator();
        retVal.next();
        return retVal;
    }
}

