/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.jface.util.Util;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.AbstractWebBrowser;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.internal.browser.DefaultBrowserSupport;
import org.eclipse.ui.internal.browser.IBrowserDescriptor;
import org.eclipse.ui.internal.browser.Messages;
import org.eclipse.ui.internal.browser.Trace;
import org.eclipse.ui.internal.browser.WebBrowserUtil;
import org.eclipse.ui.internal.browser.browsers.StreamConsumer;

public class ExternalBrowserInstance
extends AbstractWebBrowser {
    protected IBrowserDescriptor browser;
    protected Process process;

    public ExternalBrowserInstance(String id, IBrowserDescriptor browser) {
        super(id);
        this.browser = browser;
    }

    public void openURL(URL url) throws PartInitException {
        final String urlText = url == null ? null : url.toExternalForm();
        ArrayList<String> cmdOptions = new ArrayList<String>();
        String location = this.browser.getLocation();
        cmdOptions.add(location);
        String parameters = this.browser.getParameters();
        final boolean[] reportNonZeroExitValue = new boolean[1];
        Trace.trace(Trace.FINEST, "Launching external Web browser: " + location + " - " + parameters + " - " + urlText);
        boolean isMacBundle = Util.isMac() && ExternalBrowserInstance.isMacAppBundle(location);
        boolean includeUrlInParams = !isMacBundle || parameters != null && parameters.contains("%URL%");
        String[] params = WebBrowserUtil.createParameterArray(parameters, includeUrlInParams ? urlText : null);
        try {
            if (isMacBundle) {
                cmdOptions.add(0, "-a");
                cmdOptions.add(0, "open");
                if (urlText != null) {
                    cmdOptions.add(urlText);
                }
                if (params.length > 0) {
                    cmdOptions.add("--args");
                }
                reportNonZeroExitValue[0] = true;
            }
            String[] stringArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                cmdOptions.add(param);
                ++n2;
            }
            String[] cmd = cmdOptions.toArray(new String[cmdOptions.size()]);
            Trace.trace(Trace.FINEST, "Launching " + this.join(" ", cmd));
            this.process = Runtime.getRuntime().exec(cmd);
            StreamConsumer outConsumer = new StreamConsumer(this.process.getInputStream());
            outConsumer.setName("External browser output reader");
            outConsumer.start();
            StreamConsumer errConsumer = new StreamConsumer(this.process.getErrorStream());
            errConsumer.setName("External browser  error reader");
            errConsumer.start();
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        ExternalBrowserInstance.this.process.waitFor();
                        if (reportNonZeroExitValue[0] && ExternalBrowserInstance.this.process.exitValue() != 0) {
                            Trace.trace(Trace.SEVERE, "External browser returned non-zero status: " + ExternalBrowserInstance.this.process.exitValue());
                            WebBrowserUtil.openError(NLS.bind((String)Messages.errorCouldNotLaunchExternalWebBrowser, (Object)urlText));
                        }
                        DefaultBrowserSupport.getInstance().removeBrowser((IWebBrowser)ExternalBrowserInstance.this);
                    }
                    catch (Exception exception) {}
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not launch external browser", e);
            WebBrowserUtil.openError(NLS.bind((String)Messages.errorCouldNotLaunchExternalWebBrowser, (Object)urlText));
        }
    }

    public static boolean isMacAppBundle(String location) {
        return ExternalBrowserInstance.isMacAppBundle(new File(location));
    }

    public static boolean isMacAppBundle(File location) {
        File macosDir = new File(new File(location, "Contents"), "MacOS");
        File plist = new File(new File(location, "Contents"), "Info.plist");
        return location.isDirectory() && macosDir.isDirectory() && plist.isFile();
    }

    private String join(String delim, String ... data) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < data.length) {
            sb.append(data[i]);
            if (i >= data.length - 1) break;
            sb.append(delim);
            ++i;
        }
        return sb.toString();
    }

    public boolean close() {
        try {
            this.process.destroy();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

