/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.chromium.JavascriptVmFactory;
import org.eclipse.wst.jsdt.chromium.debug.core.Messages;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ChromiumBreakpointWBAFactory;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ChromiumLineBreakpoint;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ConnectedTargetData;
import org.eclipse.wst.jsdt.chromium.debug.core.model.DebugTargetImpl;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResource;
import org.eclipse.wst.jsdt.chromium.debug.core.util.ScriptTargetMapping;
import org.osgi.framework.BundleContext;

public class ChromiumDebugPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.wst.jsdt.chromium.debug.core";
    public static final String BP_MARKER = "org.eclipse.wst.jsdt.chromium.debug.core.LineBP";
    public static final String EXCEPTION_BP_MARKER = "org.eclipse.wst.jsdt.chromium.debug.core.ExceptionBP";
    private static ChromiumDebugPlugin plugin;
    private ChromiumBreakpointWBAFactory breakpointWorkbenchAdapterFactory;
    private static final Handler SDK_LOG_HANDLER;

    static {
        SDK_LOG_HANDLER = new Handler(){

            @Override
            public void publish(LogRecord record) {
                int statusSeverity = 0;
                Level level = record.getLevel();
                statusSeverity = level == Level.SEVERE ? 4 : (level == Level.WARNING ? 2 : 1);
                ChromiumDebugPlugin.log((IStatus)new Status(statusSeverity, ChromiumDebugPlugin.PLUGIN_ID, "SDK:" + record.getLoggerName() + ": " + record.getMessage(), record.getThrown()));
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        };
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IAdapterManager manager = Platform.getAdapterManager();
        this.breakpointWorkbenchAdapterFactory = new ChromiumBreakpointWBAFactory();
        manager.registerAdapters((IAdapterFactory)this.breakpointWorkbenchAdapterFactory, ChromiumLineBreakpoint.class);
        plugin = this;
        JavascriptVmFactory.getRootLogger().addHandler(SDK_LOG_HANDLER);
    }

    public void stop(BundleContext context) throws Exception {
        JavascriptVmFactory.getRootLogger().removeHandler(SDK_LOG_HANDLER);
        plugin = null;
        IAdapterManager manager = Platform.getAdapterManager();
        manager.unregisterAdapters((IAdapterFactory)this.breakpointWorkbenchAdapterFactory);
        super.stop(context);
    }

    public static ChromiumDebugPlugin getDefault() {
        return plugin;
    }

    public static List<? extends ScriptTargetMapping> getScriptTargetMapping(IFile localFile) {
        List<ConnectedTargetData> targetDataList = DebugTargetImpl.getAllConnectedTargetDatas();
        ArrayList<ScriptTargetMapping> result = new ArrayList<ScriptTargetMapping>(targetDataList.size());
        for (ConnectedTargetData targetData : targetDataList) {
            Collection<? extends VmResource> resources;
            try {
                resources = targetData.getVmResource(localFile);
            }
            catch (CoreException e) {
                throw new RuntimeException("Failed to resolve script from the file " + localFile, e);
            }
            if (resources == null || resources.isEmpty()) continue;
            result.add(new ScriptTargetMapping(localFile, resources, targetData));
        }
        return result;
    }

    public static boolean isDebug() {
        ChromiumDebugPlugin thePlugin = ChromiumDebugPlugin.getDefault();
        return thePlugin != null && thePlugin.isDebugging();
    }

    public static boolean isTransportDebug() {
        return ChromiumDebugPlugin.isDebug() && Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.wst.jsdt.chromium.debug.core/debug/transport")) != false;
    }

    public static boolean isV8DebuggerToolDebug() {
        return ChromiumDebugPlugin.isDebug() && Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.wst.jsdt.chromium.debug.core/debug/v8DebuggerTool")) != false;
    }

    public static void log(IStatus status) {
        ChromiumDebugPlugin plugin = ChromiumDebugPlugin.getDefault();
        if (plugin != null) {
            plugin.getLog().log(status);
        } else {
            System.err.println(String.valueOf(status.getPlugin()) + ": " + status.getMessage());
        }
    }

    public static void log(Throwable e) {
        if (e instanceof CoreException) {
            ChromiumDebugPlugin.log((IStatus)new Status(4, PLUGIN_ID, ((CoreException)e).getStatus().getSeverity(), e.getMessage(), e.getCause()));
        } else {
            ChromiumDebugPlugin.log((IStatus)new Status(4, PLUGIN_ID, Messages.ChromiumDebugPlugin_InternalError, e));
        }
    }

    public static void logError(String message, Object ... arguments) {
        ChromiumDebugPlugin.log((IStatus)new Status(4, PLUGIN_ID, ChromiumDebugPlugin.getPossiblyFormattedString(message, arguments)));
    }

    public static void logWarning(String message, Object ... arguments) {
        ChromiumDebugPlugin.log((IStatus)new Status(2, PLUGIN_ID, ChromiumDebugPlugin.getPossiblyFormattedString(message, arguments)));
    }

    private static String getPossiblyFormattedString(String message, Object ... arguments) {
        return arguments.length > 0 ? MessageFormat.format(message, arguments) : message;
    }
}

