/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTMatcher;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.TemplateElement;

public class TemplateLiteral
extends Expression {
    public static final ChildPropertyDescriptor TAG_PROPERTY = new ChildPropertyDescriptor(TemplateLiteral.class, "tag", Expression.class, false, false);
    public static final ChildListPropertyDescriptor ELEMENTS_PROPERTY = new ChildListPropertyDescriptor(TemplateLiteral.class, "elements", TemplateElement.class, true);
    public static final ChildListPropertyDescriptor EXPRESSIONS_PROPERTY = new ChildListPropertyDescriptor(TemplateLiteral.class, "parameters", Expression.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;
    private Expression tag = null;
    private ASTNode.NodeList elements = new ASTNode.NodeList(this, ELEMENTS_PROPERTY);
    private ASTNode.NodeList expressions = new ASTNode.NodeList(this, EXPRESSIONS_PROPERTY);

    static {
        ArrayList propertyList = new ArrayList(4);
        TemplateLiteral.createPropertyList(TemplateLiteral.class, propertyList);
        TemplateLiteral.addProperty(TAG_PROPERTY, propertyList);
        TemplateLiteral.addProperty(ELEMENTS_PROPERTY, propertyList);
        TemplateLiteral.addProperty(EXPRESSIONS_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = TemplateLiteral.reapPropertyList(propertyList);
    }

    public static List<StructuralPropertyDescriptor> propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    TemplateLiteral(AST ast) {
        super(ast);
    }

    @Override
    List internalStructuralPropertiesForType(int apiLevel) {
        return TemplateLiteral.propertyDescriptors(apiLevel);
    }

    @Override
    int getNodeType0() {
        return 99;
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == TAG_PROPERTY) {
            if (get) {
                return this.getTag();
            }
            this.setTag((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == ELEMENTS_PROPERTY) {
            return this.elements();
        }
        if (property == EXPRESSIONS_PROPERTY) {
            return this.expressions();
        }
        return super.internalGetChildListProperty(property);
    }

    public List expressions() {
        return this.expressions;
    }

    public List elements() {
        return this.elements;
    }

    public Expression getTag() {
        return this.tag;
    }

    public void setTag(Expression tag) {
        if (tag == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.tag;
        this.preReplaceChild(oldChild, tag, TAG_PROPERTY);
        this.tag = tag;
        this.postReplaceChild(oldChild, tag, TAG_PROPERTY);
    }

    @Override
    boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        TemplateLiteral result = new TemplateLiteral(target);
        if (this.tag != null) {
            result.setTag((Expression)this.getTag().clone(target));
        }
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.elements().addAll(ASTNode.copySubtrees(target, this.elements()));
        result.expressions().addAll(ASTNode.copySubtrees(target, this.expressions()));
        return result;
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getTag());
            this.acceptChildren(visitor, this.elements);
            this.acceptChildren(visitor, this.expressions);
        }
        visitor.endVisit(this);
    }

    @Override
    int treeSize() {
        return this.memSize() + this.elements.listSize() + this.expressions.listSize();
    }

    @Override
    int memSize() {
        return 52;
    }
}

