/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom.flatten;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayName;
import org.eclipse.wst.jsdt.core.dom.ArrowFunctionExpression;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.AssignmentName;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.CharacterLiteral;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DebuggerStatement;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EmptyStatement;
import org.eclipse.wst.jsdt.core.dom.ExportDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForOfStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionExpression;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.LineComment;
import org.eclipse.wst.jsdt.core.dom.ListExpression;
import org.eclipse.wst.jsdt.core.dom.MetaProperty;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.ModuleSpecifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteralField;
import org.eclipse.wst.jsdt.core.dom.ObjectName;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.RegularExpressionLiteral;
import org.eclipse.wst.jsdt.core.dom.RestElementName;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.SpreadElement;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.TemplateElement;
import org.eclipse.wst.jsdt.core.dom.TemplateLiteral;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.UndefinedLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WithStatement;
import org.eclipse.wst.jsdt.core.dom.YieldExpression;
import org.eclipse.wst.jsdt.core.dom.flatten.IJsCodeElementFactory;
import org.eclipse.wst.jsdt.core.dom.flatten.JsCodeOutputStream;

public class JsCodeIRGenerator
extends ASTVisitor {
    protected IJsCodeElementFactory factory;
    protected JsCodeElement value = null;
    protected static final int SEQUENCE = 0;
    protected static final int ASSIGNMENT = 1;
    protected static final int CONDITIONAL = 2;
    protected static final int LOGICAL_OR = 3;
    protected static final int LOGICAL_AND = 4;
    protected static final int BITWISE_OR = 5;
    protected static final int BITWISE_XOR = 6;
    protected static final int BITWISE_AND = 7;
    protected static final int EQUALITY = 8;
    protected static final int RELATIONAL = 9;
    protected static final int SHIFT = 10;
    protected static final int ADDITIVE = 11;
    protected static final int MULTIPLICATIVE = 12;
    protected static final int PREFIX = 13;
    protected static final int POSTFIX = 14;
    protected static final int NEW = 15;
    protected static final int CALL = 16;
    protected static final int MEMBER = 17;
    protected static final int PRIMARY = 18;

    public JsCodeElement generate(ASTNode node) {
        return this.v(node);
    }

    public JsCodeIRGenerator(IJsCodeElementFactory factory) {
        this.factory = factory;
    }

    @Override
    public boolean visit(Modifier node) {
        this.value = this.token(node.getKeyword().toString());
        return false;
    }

    @Override
    public boolean visit(ArrayAccess node) {
        this.value = this.seqVa(this.v(node.getArray()), this.brack(this.v(node.getIndex())));
        return false;
    }

    @Override
    public boolean visit(ArrayInitializer node) {
        this.value = this.brack(this.seqCsMap(node.expressions()));
        return false;
    }

    @Override
    public boolean visit(Assignment node) {
        JsCodeElement lhs = this.parenOpt(1, node.getLeftHandSide());
        JsCodeElement rhs = this.parenOpt(1, node.getRightHandSide());
        this.value = this.seqVa(lhs, this.token(node.getOperator().toString()), rhs);
        return false;
    }

    @Override
    public boolean visit(Block node) {
        this.value = this.braces(this.seqMap(node.statements()));
        return false;
    }

    @Override
    public boolean visit(BooleanLiteral node) {
        this.value = this.token(node.booleanValue() ? "true" : "false");
        return false;
    }

    @Override
    public boolean visit(BreakStatement node) {
        this.value = this.seqVa(this.token("break"), this.v(node.getLabel()), this.semiOpt());
        return false;
    }

    @Override
    public boolean visit(CatchClause node) {
        this.value = this.seqVa(this.token("catch"), this.paren(this.v(node.getException())), this.v(node.getBody()));
        return false;
    }

    @Override
    public boolean visit(RegularExpressionLiteral node) {
        this.value = this.token(node.getRegularExpression());
        return false;
    }

    @Override
    public boolean visit(ClassInstanceCreation node) {
        this.value = this.seqVa(this.token("new"), this.v(node.getMember()), this.paren(this.seqCsMap(node.arguments())));
        return false;
    }

    @Override
    public boolean visit(JavaScriptUnit node) {
        List<JsCodeElement> l = this.map(node.imports());
        l.addAll(this.map(node.exports()));
        l.addAll(this.map(node.statements()));
        this.value = this.seq(l);
        return false;
    }

    @Override
    public boolean visit(ConditionalExpression node) {
        this.value = this.seqVa(this.parenOpt(3, node.getExpression()), this.token("?"), this.parenOpt(1, node.getThenExpression()), this.token(":"), this.parenOpt(1, node.getElseExpression()));
        return false;
    }

    @Override
    public boolean visit(ContinueStatement node) {
        this.value = this.seqVa(this.token("continue"), this.v(node.getLabel()), this.semiOpt());
        return false;
    }

    @Override
    public boolean visit(DoStatement node) {
        this.value = this.seqVa(this.token("do"), this.v(node.getBody()), this.token("while"), this.paren(this.v(node.getExpression())), this.semiOpt());
        return false;
    }

    @Override
    public boolean visit(EmptyStatement node) {
        this.value = this.semi();
        return false;
    }

    @Override
    public boolean visit(ExpressionStatement node) {
        this.value = this.v(node.getExpression());
        int nt = node.getParent().getNodeType();
        if (nt != 83 && nt != 96) {
            this.value = this.seqVa(this.value, this.semiOpt());
        }
        return false;
    }

    @Override
    public boolean visit(FieldAccess node) {
        this.value = this.seqVa(this.v(node.getExpression()), this.token("."), this.v(node.getName()));
        return false;
    }

    @Override
    public boolean visit(ForStatement node) {
        ArrayList<JsCodeElement> initializers = new ArrayList<JsCodeElement>();
        for (ASTNode initializer : node.initializers()) {
            JsCodeElement element = this.v(initializer);
            if (element == null) continue;
            if (initializer.getNodeType() == 27 && "in".equals(((InfixExpression)initializer).getOperator().toString())) {
                initializers.add(this.paren(element));
                continue;
            }
            initializers.add(element);
        }
        this.value = this.seqVa(this.token("for"), this.paren(this.seqVa(this.seqCs(initializers), this.semi(), this.v(node.getExpression()), this.semi(), this.seqCsMap(node.updaters()))), this.v(node.getBody()));
        return false;
    }

    @Override
    public boolean visit(ForInStatement node) {
        JsCodeElement left = this.v(node.getIterationVariable());
        JsCodeElement right = this.v(node.getCollection());
        this.value = this.seqVa(this.token("for"), this.paren(this.seqVa(left, this.token("in"), right)), this.v(node.getBody()));
        return false;
    }

    @Override
    public boolean visit(ForOfStatement node) {
        JsCodeElement left = this.v(node.getIterationVariable());
        JsCodeElement right = this.v(node.getCollection());
        this.value = this.seqVa(this.token("for"), this.paren(this.seqVa(left, this.token("of"), right)), this.v(node.getBody()));
        return false;
    }

    @Override
    public boolean visit(IfStatement node) {
        ArrayList<JsCodeElement> result = new ArrayList<JsCodeElement>();
        result.add(this.token("if"));
        result.add(this.paren(this.v(node.getExpression())));
        result.add(this.v(node.getThenStatement()));
        JsCodeElement alternate = this.v(node.getElseStatement());
        if (alternate != null) {
            result.add(this.token("else"));
            result.add(alternate);
        }
        this.value = this.seq(result);
        return false;
    }

    @Override
    public boolean visit(InfixExpression node) {
        int precedence = this.expressionPrecedence(node);
        ArrayList<JsCodeElement> result = new ArrayList<JsCodeElement>();
        result.add(this.parenOpt(precedence, node.getLeftOperand()));
        result.add(this.token(node.getOperator().toString()));
        result.add(this.parenOptRight(precedence, node.getRightOperand()));
        List extendedOperands = node.extendedOperands();
        if (extendedOperands.size() != 0) {
            for (ASTNode e : extendedOperands) {
                result.add(this.token(node.getOperator().toString()));
                result.add(this.parenOpt(precedence, e));
            }
        }
        this.value = this.seq(result);
        return false;
    }

    @Override
    public boolean visit(JSdoc node) {
        this.value = this.seqVa(this.token("/** "), this.seqMap(node.tags()), this.token(" */"));
        return false;
    }

    @Override
    public boolean visit(LineComment node) {
        this.value = this.seqVa(this.token("//"), this.token("\n"));
        return false;
    }

    @Override
    public boolean visit(LabeledStatement node) {
        this.value = this.seqVa(this.v(node.getLabel()), this.token(":"), this.v(node.getBody()));
        return false;
    }

    @Override
    public boolean visit(ListExpression node) {
        this.value = this.seqCsMap(node.expressions());
        return false;
    }

    @Override
    public boolean visit(FunctionDeclaration node) {
        ArrayList<JsCodeElement> result = new ArrayList<JsCodeElement>();
        result.add(this.v(node.getJavadoc()));
        result.add(this.seqMap(node.modifiers()));
        if (!node.isConstructor() && !this.isGetterOrSetter(node.modifiers())) {
            result.add(this.token("function" + (node.isGenerator() ? "*" : "")));
        }
        result.add(this.v(node.getMethodName()));
        result.add(this.paren(this.seqCsMap(node.parameters())));
        int i = 0;
        while (i < node.getExtraDimensions()) {
            result.add(this.token("[]"));
            ++i;
        }
        result.add(this.v(node.getBody()));
        this.value = this.seq(result);
        return false;
    }

    @Override
    public boolean visit(FunctionInvocation node) {
        ArrayList<JsCodeElement> result = new ArrayList<JsCodeElement>();
        if (node.getExpression() != null) {
            result.add(this.v(node.getExpression()));
            if (node.getName() != null) {
                result.add(this.token("."));
            }
        }
        if (node.getAST().apiLevel() >= 3 && !node.typeArguments().isEmpty()) {
            result.add(this.token("<"));
            result.add(this.seqCsMap(node.typeArguments()));
            result.add(this.token(">"));
        }
        result.add(this.v(node.getName()));
        result.add(this.paren(this.seqCsMap(node.arguments())));
        this.value = this.seq(result);
        return false;
    }

    @Override
    public boolean visit(NullLiteral node) {
        this.value = this.token("null");
        return false;
    }

    @Override
    public boolean visit(UndefinedLiteral node) {
        this.value = this.token("undefined");
        return false;
    }

    @Override
    public boolean visit(NumberLiteral node) {
        this.value = this.token(node.getToken());
        return false;
    }

    @Override
    public boolean visit(PostfixExpression node) {
        this.value = this.seqVa(this.v(node.getOperand()), this.token(node.getOperator().toString()));
        return false;
    }

    @Override
    public boolean visit(PrefixExpression node) {
        this.value = this.seqVa(this.token(node.getOperator().toString()), this.parenOpt(13, node.getOperand()));
        return false;
    }

    @Override
    public boolean visit(ReturnStatement node) {
        this.value = this.seqVa(this.token("return"), this.v(node.getExpression()), this.semiOpt());
        return false;
    }

    @Override
    public boolean visit(SimpleName node) {
        this.value = this.token(node.getIdentifier());
        return false;
    }

    @Override
    public boolean visit(SingleVariableDeclaration node) {
        ArrayList<JsCodeElement> result = new ArrayList<JsCodeElement>();
        result.add(this.v(node.getType()));
        if (node.isVarargs()) {
            result.add(this.token("..."));
        }
        result.add(this.v(node.getPattern()));
        int i = 0;
        while (i < node.getExtraDimensions()) {
            result.add(this.token("[]"));
            ++i;
        }
        if (node.getInitializer() != null) {
            result.add(this.token("="));
            result.add(this.v(node.getInitializer()));
        }
        this.value = this.seq(result);
        return false;
    }

    @Override
    public boolean visit(StringLiteral node) {
        this.value = this.token(node.getEscapedValue());
        return false;
    }

    @Override
    public boolean visit(SuperMethodInvocation node) {
        List<JsCodeElement> args = this.map(node.arguments());
        this.value = this.seqVa(this.token("super"), this.paren(this.seqCs(args)));
        return false;
    }

    @Override
    public boolean visit(SwitchCase node) {
        this.value = this.seqVa(node.isDefault() ? this.token("default") : this.seqVa(this.token("case"), this.v(node.getExpression())), this.token(":"));
        return false;
    }

    @Override
    public boolean visit(SwitchStatement node) {
        this.value = this.seqVa(this.token("switch"), this.paren(this.v(node.getExpression())), this.braces(this.seqMap(node.statements())));
        return false;
    }

    @Override
    public boolean visit(ThisExpression node) {
        this.value = this.token("this");
        return false;
    }

    @Override
    public boolean visit(ThrowStatement node) {
        this.value = this.seqVa(this.token("throw"), this.v(node.getExpression()), this.semiOpt());
        return false;
    }

    @Override
    public boolean visit(TryStatement node) {
        this.value = this.seqVa(this.token("try"), this.v(node.getBody()), this.seqMap(node.catchClauses()), node.getFinally() != null ? this.seqVa(this.token("finally"), this.v(node.getFinally())) : null);
        return false;
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        JsCodeElement result = this.seqVa(this.v(node.getJavadoc()), this.token("class"), this.v(node.getName()));
        JsCodeElement superType = this.v(node.getSuperclassExpression());
        if (superType != null) {
            result = this.seqVa(result, this.token("extends"), superType);
        }
        this.value = this.seqVa(result, this.braces(this.seqMap(node.bodyDeclarations())));
        return false;
    }

    @Override
    public boolean visit(TypeDeclarationStatement node) {
        this.value = this.v(node.getDeclaration());
        return false;
    }

    @Override
    public boolean visit(VariableDeclarationExpression node) {
        ArrayList<JsCodeElement> result = new ArrayList<JsCodeElement>();
        switch (node.getKind()) {
            case LET: {
                result.add(this.token("let"));
                break;
            }
            case CONST: {
                result.add(this.token("const"));
                break;
            }
            default: {
                result.add(this.token("var"));
            }
        }
        result.add(this.v(node.getType()));
        result.add(this.seqCsMap(node.fragments()));
        this.value = this.seq(result);
        return false;
    }

    @Override
    public boolean visit(VariableDeclarationStatement node) {
        ArrayList<JsCodeElement> result = new ArrayList<JsCodeElement>();
        switch (node.getKind()) {
            case LET: {
                result.add(this.token("let"));
                break;
            }
            case CONST: {
                result.add(this.token("const"));
                break;
            }
            default: {
                result.add(this.token("var"));
            }
        }
        result.add(this.seqCsMap(node.fragments()));
        this.value = this.seq(result);
        return false;
    }

    @Override
    public boolean visit(VariableDeclarationFragment node) {
        ArrayList<JsCodeElement> result = new ArrayList<JsCodeElement>();
        result.add(this.v(node.getName()));
        int i = 0;
        while (i < node.getExtraDimensions()) {
            result.add(this.token("[]"));
            ++i;
        }
        if (node.getInitializer() != null) {
            result.add(this.token("="));
            if (node.getInitializer().getNodeType() == 27 && "in".equals(((InfixExpression)node.getInitializer()).getOperator().toString()) && node.getParent().getParent().getNodeType() == 24) {
                result.add(this.paren(this.v(node.getInitializer())));
            } else {
                result.add(this.v(node.getInitializer()));
            }
        }
        this.value = this.seq(result);
        return false;
    }

    @Override
    public boolean visit(WhileStatement node) {
        this.value = this.seqVa(this.token("while"), this.paren(this.v(node.getExpression())), this.v(node.getBody()));
        return false;
    }

    @Override
    public boolean visit(WithStatement node) {
        this.value = this.seqVa(this.token("with"), this.paren(this.v(node.getExpression())), this.v(node.getBody()));
        return false;
    }

    @Override
    public boolean visit(ObjectLiteral node) {
        this.value = this.braces(this.seqCsMap(node.fields()));
        return false;
    }

    @Override
    public boolean visit(ObjectLiteralField node) {
        this.value = this.seqVa(this.v(node.getFieldName()), this.token(":"), this.v(node.getInitializer()));
        return false;
    }

    @Override
    public boolean visit(FunctionExpression node) {
        this.value = this.v(node.getMethod());
        return false;
    }

    @Override
    public boolean visit(YieldExpression yieldExpression) {
        this.value = this.seqVa(this.token("yield"), this.parenOpt(this.expressionPrecedence(yieldExpression), yieldExpression.getArgument()));
        return false;
    }

    @Override
    public boolean visit(ArrowFunctionExpression arrowFunctionExpression) {
        List params = arrowFunctionExpression.parameters();
        JsCodeElement paramsC = this.seqCsMap(params);
        if (params == null || params.size() != 1 || ((ASTNode)params.get(0)).getNodeType() != 44 || ((VariableDeclaration)params.get(0)).getInitializer() != null) {
            paramsC = this.paren(paramsC);
        }
        this.value = this.seqVa(paramsC, this.token("=>"), this.v(arrowFunctionExpression.getBody()), this.v(arrowFunctionExpression.getExpression()));
        return false;
    }

    @Override
    public boolean visit(DebuggerStatement debuggerStatement) {
        this.value = this.seqVa(this.factory.token("debugger"), this.factory.semiOpt());
        return false;
    }

    @Override
    public boolean visit(ArrayName node) {
        this.value = this.brack(this.seqCsMap(node.elements()));
        return false;
    }

    @Override
    public boolean visit(ObjectName node) {
        this.value = this.braces(this.seqCsMap(node.objectProperties()));
        return false;
    }

    @Override
    public boolean visit(TemplateElement templateElement) {
        String rawValue = templateElement.getRawValue();
        if (rawValue != null && !rawValue.isEmpty()) {
            this.value = this.token(rawValue);
        }
        return false;
    }

    @Override
    public boolean visit(TemplateLiteral node) {
        ArrayList<JsCodeElement> templateBody = new ArrayList<JsCodeElement>();
        templateBody.add(this.token("`"));
        int i = 0;
        while (i < node.elements().size()) {
            TemplateElement te = (TemplateElement)node.elements().get(i);
            templateBody.add(this.v(te));
            if (!te.isTail()) {
                Expression exp = (Expression)node.expressions().get(i);
                templateBody.add(this.token("${"));
                templateBody.add(this.v(exp));
                templateBody.add(this.token("}"));
            }
            ++i;
        }
        templateBody.add(this.token("`"));
        this.value = this.seqVa(this.parenOpt(16, node.getTag()), this.factory.seqRaw(templateBody));
        return false;
    }

    @Override
    public boolean visit(AssignmentName node) {
        JsCodeElement lhs = this.v(node.getLeft());
        JsCodeElement rhs = this.v(node.getRight());
        this.value = this.seqVa(lhs, this.token("="), rhs);
        return false;
    }

    @Override
    public boolean visit(RestElementName node) {
        this.value = this.seqVa(this.token("..."), this.v(node.getArgument()));
        return false;
    }

    @Override
    public boolean visit(SpreadElement node) {
        this.value = this.seqVa(this.token("..."), this.parenOpt(1, node.getArgument()));
        return false;
    }

    @Override
    public boolean visit(MetaProperty metaProperty) {
        this.value = this.token(String.valueOf(metaProperty.getMeta()) + "." + metaProperty.getPropertyName());
        return false;
    }

    @Override
    public boolean visit(ExportDeclaration node) {
        List<JsCodeElement> specifiers = this.map(node.specifiers());
        this.value = this.seqVa(this.token("export"), !specifiers.isEmpty() ? this.seqVa(this.seqCs(specifiers), this.token("from")) : null, this.v(node.getSource()), this.semiOpt());
        return false;
    }

    @Override
    public boolean visit(ImportDeclaration node) {
        List<JsCodeElement> specifiers = this.map(node.specifiers());
        this.value = this.seqVa(this.token("import"), !specifiers.isEmpty() ? this.seqVa(this.seqCs(specifiers), this.token("from")) : null, this.v(node.getSource()), this.semiOpt());
        return false;
    }

    @Override
    public boolean visit(ModuleSpecifier moduleSpecifier) {
        SimpleName l = moduleSpecifier.getLocal();
        SimpleName d = moduleSpecifier.getDiscoverableName();
        JsCodeElement result = null;
        if (moduleSpecifier.isNamespace()) {
            result = this.seqVa(this.token("*"), this.token("as"), this.v(l));
        } else {
            result = d == null || l.getIdentifier().equals(d.getIdentifier()) ? this.v(l) : this.seqVa(this.v(d), this.token("as"), this.v(l));
            if (!moduleSpecifier.isDefault()) {
                result = this.braces(result);
            }
        }
        this.value = result;
        return false;
    }

    @Override
    public boolean visit(TypeDeclarationExpression typeDeclarationExpression) {
        this.value = this.v(typeDeclarationExpression.getDeclaration());
        return false;
    }

    @Override
    public boolean visit(FunctionDeclarationStatement functionDeclarationStatement) {
        this.value = this.v(functionDeclarationStatement.getDeclaration());
        return false;
    }

    protected JsCodeElement token(String token) {
        return this.factory.token(token);
    }

    protected JsCodeElement semi() {
        return this.factory.semi();
    }

    protected JsCodeElement semiOpt() {
        return this.factory.semiOpt();
    }

    protected JsCodeElement wrap(String start, JsCodeElement element, String end) {
        return this.factory.wrap(start, element, end);
    }

    protected JsCodeElement paren(JsCodeElement element) {
        return this.factory.paren(element);
    }

    protected JsCodeElement brack(JsCodeElement element) {
        return this.factory.brack(element);
    }

    protected JsCodeElement braces(JsCodeElement element) {
        return this.factory.braces(element);
    }

    protected JsCodeElement seq(JsCodeElement[] elements) {
        return this.factory.seq(elements);
    }

    protected JsCodeElement seq(List<JsCodeElement> elements) {
        return this.factory.seq(elements);
    }

    protected JsCodeElement seqCs(JsCodeElement[] elements) {
        return this.factory.seqCs(elements);
    }

    protected JsCodeElement seqCs(List<JsCodeElement> elements) {
        return this.factory.seqCs(elements);
    }

    protected JsCodeElement v(ASTNode node) {
        if (node != null) {
            this.value = null;
            node.accept(this);
            return this.value;
        }
        return null;
    }

    protected List<JsCodeElement> map(List<ASTNode> nodes) {
        ArrayList<JsCodeElement> result = new ArrayList<JsCodeElement>();
        for (ASTNode node : nodes) {
            JsCodeElement element = this.v(node);
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    protected JsCodeElement seqMap(List<ASTNode> nodes) {
        return this.seq(this.map(nodes));
    }

    protected JsCodeElement seqCsMap(List<ASTNode> nodes) {
        return this.seqCs(this.map(nodes));
    }

    protected JsCodeElement seqVa(JsCodeElement ... elements) {
        return this.seq(elements);
    }

    protected boolean isGetterOrSetter(List<Modifier> modifiers) {
        for (Modifier node : modifiers) {
            String kw;
            switch (kw = node.getKeyword().toString()) {
                case "get": 
                case "set": {
                    return true;
                }
            }
        }
        return false;
    }

    protected JsCodeElement parenOpt(int parentPrec, ASTNode child) {
        if (child != null && child instanceof Expression) {
            if (this.expressionPrecedence((Expression)child) < parentPrec) {
                return this.paren(this.v(child));
            }
            return this.v(child);
        }
        return this.v(child);
    }

    protected JsCodeElement parenOptRight(int rootPrec, ASTNode child) {
        if (child != null && child instanceof Expression) {
            if (this.expressionPrecedence((Expression)child) <= rootPrec) {
                return this.paren(this.v(child));
            }
            return this.v(child);
        }
        return this.v(child);
    }

    protected int expressionPrecedence(Expression e) {
        if (e instanceof ArrayAccess) {
            return 17;
        }
        if (e instanceof ArrayInitializer) {
            return 18;
        }
        if (e instanceof ArrowFunctionExpression || e instanceof Assignment) {
            return 1;
        }
        if (e instanceof BooleanLiteral || e instanceof CharacterLiteral || e instanceof NullLiteral || e instanceof NumberLiteral || e instanceof ObjectLiteral || e instanceof StringLiteral || e instanceof Name || e instanceof RegularExpressionLiteral || e instanceof UndefinedLiteral || e instanceof TemplateLiteral || e instanceof FunctionExpression || e instanceof ThisExpression || e instanceof ObjectLiteralField || e instanceof TypeDeclarationExpression) {
            return 18;
        }
        if (e instanceof ClassInstanceCreation) {
            return 15;
        }
        if (e instanceof ConditionalExpression) {
            return 2;
        }
        if (e instanceof FieldAccess) {
            return 17;
        }
        if (e instanceof FunctionInvocation) {
            return 16;
        }
        if (e instanceof ListExpression) {
            return 0;
        }
        if (e instanceof MetaProperty) {
            return 17;
        }
        if (e instanceof InfixExpression) {
            return this.operatorPrecedence(((InfixExpression)e).getOperator().toString());
        }
        if (e instanceof PostfixExpression) {
            return 14;
        }
        if (e instanceof PrefixExpression) {
            return 13;
        }
        if (e instanceof SuperMethodInvocation) {
            return 17;
        }
        if (e instanceof YieldExpression) {
            return 1;
        }
        throw new UnimplementedException();
    }

    private int operatorPrecedence(String op) {
        switch (op) {
            case "%": 
            case "*": 
            case "/": {
                return 12;
            }
            case "+": 
            case "-": {
                return 11;
            }
            case "<<": 
            case ">>": 
            case ">>>": {
                return 10;
            }
            case "!=": 
            case "==": 
            case "!==": 
            case "===": {
                return 8;
            }
            case "|": {
                return 5;
            }
            case "^": {
                return 6;
            }
            case "&": {
                return 7;
            }
            case "||": {
                return 3;
            }
            case "&&": {
                return 4;
            }
            case "<": 
            case ">": 
            case "<=": 
            case ">=": 
            case "in": 
            case "instanceof": {
                return 9;
            }
        }
        throw new UnimplementedException();
    }

    public static abstract class JsCodeElement {
        public abstract void emit(JsCodeOutputStream var1);
    }
}

