/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.internal.project;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.web.core.internal.Logger;

class ConvertJob
extends WorkspaceJob {
    static final String JSDT_FACET = "wst.jsdt.web";
    private IProject fProject;
    private boolean fInstall = true;
    private boolean fUseExplicitWorkingCopy = false;

    ConvertJob(IProject project, boolean install, boolean useExplicitWorkingCopy) {
        super(Messages.converter_ConfiguringForJavaScript);
        this.fProject = project;
        this.fInstall = install;
        this.fUseExplicitWorkingCopy = useExplicitWorkingCopy;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        try {
            IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)JSDT_FACET);
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)this.fProject);
            if (facetedProject != null && this.fProject.isAccessible()) {
                if (this.fInstall) {
                    IProjectFacetVersion latestVersion = projectFacet.getLatestVersion();
                    facetedProject.installProjectFacet(latestVersion, null, monitor);
                }
                if (this.fUseExplicitWorkingCopy) {
                    IFacetedProjectWorkingCopy copy = facetedProject.createWorkingCopy();
                    HashSet<IProjectFacet> fixed = new HashSet<IProjectFacet>(facetedProject.getFixedProjectFacets());
                    fixed.add(projectFacet);
                    copy.setFixedProjectFacets(fixed);
                    copy.commitChanges((IProgressMonitor)new NullProgressMonitor());
                    copy.dispose();
                } else {
                    HashSet<IProjectFacet> fixed = new HashSet<IProjectFacet>(facetedProject.getFixedProjectFacets());
                    if (!fixed.contains(projectFacet)) {
                        fixed.add(projectFacet);
                        facetedProject.setFixedProjectFacets(fixed);
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return Status.OK_STATUS;
    }
}

