/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.wst.xml.xpath2.api.Function;
import org.eclipse.wst.xml.xpath2.processor.StaticChecker;
import org.eclipse.wst.xml.xpath2.processor.StaticContext;
import org.eclipse.wst.xml.xpath2.processor.StaticError;
import org.eclipse.wst.xml.xpath2.processor.ast.XPath;
import org.eclipse.wst.xml.xpath2.processor.internal.ReverseAxis;
import org.eclipse.wst.xml.xpath2.processor.internal.StaticAttrNameError;
import org.eclipse.wst.xml.xpath2.processor.internal.StaticContextAdapter;
import org.eclipse.wst.xml.xpath2.processor.internal.StaticElemNameError;
import org.eclipse.wst.xml.xpath2.processor.internal.StaticFunctNameError;
import org.eclipse.wst.xml.xpath2.processor.internal.StaticNameError;
import org.eclipse.wst.xml.xpath2.processor.internal.StaticNsNameError;
import org.eclipse.wst.xml.xpath2.processor.internal.StaticTypeNameError;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AddExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AndExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AnyKindTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AttributeTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AxisStep;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.BinExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.CastExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.CastableExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.CmpExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.CntxItemExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.CommentTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.DecimalLiteral;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.DivExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.DocumentTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.DoubleLiteral;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ElementTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ExceptExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.Expr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.FilterExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ForExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ForwardStep;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.FunctionCall;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.IDivExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.IfExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.InstOfExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.IntegerLiteral;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.IntersectExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ItemType;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.MinusExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ModExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.MulExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.NameTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.NodeTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.OrExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.PITest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ParExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.PipeExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.PlusExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.QuantifiedExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.RangeExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ReverseStep;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SchemaAttrTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SchemaElemTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SequenceType;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SingleType;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.StepExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.StringLiteral;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SubExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.TextTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.TreatAsExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.UnExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.UnionExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.VarExprPair;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.VarRef;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathNode;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathVisitor;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.SimpleAtomicItemTypeImpl;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticNameResolver
implements XPathVisitor,
StaticChecker {
    private org.eclipse.wst.xml.xpath2.api.StaticContext _sc;
    private StaticNameError _err;
    private Set<javax.xml.namespace.QName> _resolvedFunctions = new HashSet<javax.xml.namespace.QName>();
    private Set<String> _axes = new HashSet<String>();
    private Set<javax.xml.namespace.QName> _freeVariables = new HashSet<javax.xml.namespace.QName>();
    private VariableScope _innerScope = null;
    private boolean _rootUsed;

    public StaticNameResolver(StaticContext sc) {
        this._sc = new StaticContextAdapter(sc);
        this._err = null;
    }

    public StaticNameResolver(org.eclipse.wst.xml.xpath2.api.StaticContext context) {
        this._sc = context;
        this._err = null;
    }

    public Set<String> getAxes() {
        return this._axes;
    }

    public Set<javax.xml.namespace.QName> getFreeVariables() {
        return this._freeVariables;
    }

    public Set<javax.xml.namespace.QName> getResolvedFunctions() {
        return this._resolvedFunctions;
    }

    private org.eclipse.wst.xml.xpath2.api.typesystem.ItemType getVariableType(QName name) {
        VariableScope scope = this._innerScope;
        while (scope != null) {
            if (name.equals(scope.name)) {
                return scope.typeDef;
            }
            scope = scope.nextScope;
        }
        return this._sc.getInScopeVariables().getVariableType(name.asQName());
    }

    private boolean isVariableCaptured(QName name) {
        VariableScope scope = this._innerScope;
        while (scope != null) {
            if (name.equals(scope.name)) {
                return true;
            }
            scope = scope.nextScope;
        }
        return false;
    }

    private boolean isVariableInScope(QName name) {
        return this.isVariableCaptured(name) || this._sc.getInScopeVariables().isVariablePresent(name.asQName());
    }

    private void popScope() {
        if (this._innerScope == null) {
            throw new IllegalStateException("Unmatched scope pop");
        }
        this._innerScope = this._innerScope.nextScope;
    }

    private void pushScope(QName var, BuiltinTypeDefinition xsAnytype) {
        this._innerScope = new VariableScope(var, new SimpleAtomicItemTypeImpl(xsAnytype), this._innerScope);
    }

    private boolean expandQName(QName name, String def, boolean allowWildcards) {
        String prefix = name.prefix();
        if ("*".equals(prefix)) {
            if (!allowWildcards) {
                return false;
            }
            name.set_namespace("*");
            return true;
        }
        if (prefix == null || "".equals(prefix)) {
            name.set_namespace(def);
            return true;
        }
        String namespaceURI = this._sc.getNamespaceContext().getNamespaceURI(prefix);
        if ("".equals(namespaceURI)) {
            return false;
        }
        name.set_namespace(namespaceURI);
        return true;
    }

    private boolean expandItemQName(QName name) {
        return this.expandQName(name, this._sc.getDefaultNamespace(), true);
    }

    private boolean expandVarQName(QName name) {
        return this.expandQName(name, null, false);
    }

    private boolean expandFunctionQName(QName name) {
        return this.expandQName(name, this._sc.getDefaultFunctionNamespace(), false);
    }

    private boolean expandItemTypeQName(QName name) {
        return this.expandQName(name, this._sc.getDefaultNamespace(), false);
    }

    private void reportError(StaticNameError err) {
        this._err = err;
        throw new DummyError();
    }

    private void reportBadPrefix(String prefix) {
        this.reportError(StaticNsNameError.unknown_prefix(prefix));
    }

    @Override
    public void check(XPathNode node) throws StaticError {
        try {
            node.accept(this);
        }
        catch (DummyError dummyError) {
            throw this._err;
        }
    }

    @Override
    public Object visit(XPath xp) {
        Iterator i = xp.iterator();
        while (i.hasNext()) {
            Expr e = (Expr)i.next();
            e.accept(this);
        }
        return null;
    }

    private void doForExpr(Iterator iter, Expr expr) {
        int scopes = 0;
        while (iter.hasNext()) {
            VarExprPair pair = (VarExprPair)iter.next();
            QName var = pair.varname();
            if (!this.expandVarQName(var)) {
                this.reportBadPrefix(var.prefix());
            }
            Expr e = pair.expr();
            e.accept(this);
            this.pushScope(var, BuiltinTypeLibrary.XS_ANYTYPE);
            ++scopes;
        }
        expr.accept(this);
        int i = 0;
        while (i < scopes) {
            this.popScope();
            ++i;
        }
    }

    @Override
    public Object visit(ForExpr fex) {
        this.doForExpr(fex.iterator(), fex.expr());
        return null;
    }

    @Override
    public Object visit(QuantifiedExpr qex) {
        this.doForExpr(qex.iterator(), qex.expr());
        return null;
    }

    private void visitExprs(Iterator i) {
        while (i.hasNext()) {
            Expr e = (Expr)i.next();
            e.accept(this);
        }
    }

    @Override
    public Object visit(IfExpr ifex) {
        this.visitExprs(ifex.iterator());
        ifex.then_clause().accept(this);
        ifex.else_clause().accept(this);
        return null;
    }

    public void printBinExpr(String name, BinExpr e) {
        e.left().accept(this);
        e.right().accept(this);
    }

    @Override
    public Object visit(OrExpr orex) {
        this.printBinExpr("OR", orex);
        return null;
    }

    @Override
    public Object visit(AndExpr andex) {
        this.printBinExpr("AND", andex);
        return null;
    }

    @Override
    public Object visit(CmpExpr cmpex) {
        this.printBinExpr(new StringBuffer("CMP").append(cmpex.type()).toString(), cmpex);
        return null;
    }

    @Override
    public Object visit(RangeExpr rex) {
        this.printBinExpr("RANGE", rex);
        return null;
    }

    @Override
    public Object visit(AddExpr addex) {
        this.printBinExpr("ADD", addex);
        return null;
    }

    @Override
    public Object visit(SubExpr subex) {
        this.printBinExpr("SUB", subex);
        return null;
    }

    @Override
    public Object visit(MulExpr mulex) {
        this.printBinExpr("MUL", mulex);
        return null;
    }

    @Override
    public Object visit(DivExpr mulex) {
        this.printBinExpr("DIV", mulex);
        return null;
    }

    @Override
    public Object visit(IDivExpr mulex) {
        this.printBinExpr("IDIV", mulex);
        return null;
    }

    @Override
    public Object visit(ModExpr mulex) {
        this.printBinExpr("MOD", mulex);
        return null;
    }

    @Override
    public Object visit(UnionExpr unex) {
        this.printBinExpr("UNION", unex);
        return null;
    }

    @Override
    public Object visit(PipeExpr pipex) {
        this.printBinExpr("PIPE", pipex);
        return null;
    }

    @Override
    public Object visit(IntersectExpr iexpr) {
        this.printBinExpr("INTERSECT", iexpr);
        return null;
    }

    @Override
    public Object visit(ExceptExpr eexpr) {
        this.printBinExpr("INT_EXCEPT", eexpr);
        return null;
    }

    @Override
    public Object visit(InstOfExpr ioexp) {
        this.printBinExpr("INSTANCEOF", ioexp);
        return null;
    }

    @Override
    public Object visit(TreatAsExpr taexp) {
        this.printBinExpr("TREATAS", taexp);
        return null;
    }

    @Override
    public Object visit(CastableExpr cexp) {
        this.printBinExpr("CASTABLE", cexp);
        return null;
    }

    @Override
    public Object visit(CastExpr cexp) {
        this.printBinExpr("CAST", cexp);
        SingleType st = (SingleType)cexp.right();
        QName type = st.type();
        javax.xml.namespace.QName qName = type.asQName();
        Function f = this._sc.resolveFunction(qName, 1);
        if (f == null) {
            this.reportError(new StaticFunctNameError(new StringBuffer("Type does not exist: ").append(type.toString()).toString()));
        }
        cexp.set_function(f);
        this._resolvedFunctions.add(qName);
        return null;
    }

    public void printUnExpr(String name, UnExpr e) {
        e.arg().accept(this);
    }

    @Override
    public Object visit(MinusExpr e) {
        this.printUnExpr("MINUS", e);
        return null;
    }

    @Override
    public Object visit(PlusExpr e) {
        this.printUnExpr("PLUS", e);
        return null;
    }

    @Override
    public Object visit(XPathExpr e) {
        XPathExpr xp = e;
        boolean firstStep = true;
        while (xp != null) {
            if (firstStep && xp.slashes() != 0) {
                this._rootUsed = true;
            }
            firstStep = false;
            StepExpr se = xp.expr();
            if (se != null) {
                se.accept(this);
            }
            xp = xp.next();
        }
        return null;
    }

    @Override
    public Object visit(ForwardStep e) {
        e.node_test().accept(this);
        this._axes.add(e.iterator().name());
        return null;
    }

    @Override
    public Object visit(ReverseStep e) {
        ReverseAxis iterator;
        NodeTest nt = e.node_test();
        if (nt != null) {
            nt.accept(this);
        }
        if ((iterator = e.iterator()) != null) {
            this._axes.add(iterator.name());
        }
        return null;
    }

    @Override
    public Object visit(NameTest e) {
        QName name = e.name();
        if (!this.expandItemQName(name)) {
            this.reportBadPrefix(name.prefix());
        }
        return null;
    }

    @Override
    public Object visit(VarRef e) {
        QName var = e.name();
        if (!this.expandVarQName(var)) {
            this.reportBadPrefix(var.prefix());
        }
        if (!this.isVariableInScope(var)) {
            this.reportError(new StaticNameError("XPST0008"));
        }
        if (this.getVariableType(var) == null) {
            this.reportError(new StaticNameError("XPST0008"));
        }
        if (!this.isVariableCaptured(var)) {
            this._freeVariables.add(var.asQName());
        }
        return null;
    }

    @Override
    public Object visit(StringLiteral e) {
        return null;
    }

    @Override
    public Object visit(IntegerLiteral e) {
        return null;
    }

    @Override
    public Object visit(DoubleLiteral e) {
        return null;
    }

    @Override
    public Object visit(DecimalLiteral e) {
        return null;
    }

    @Override
    public Object visit(ParExpr e) {
        this.visitExprs(e.iterator());
        return null;
    }

    @Override
    public Object visit(CntxItemExpr e) {
        return null;
    }

    @Override
    public Object visit(FunctionCall e) {
        javax.xml.namespace.QName qName;
        Function f;
        QName name = e.name();
        if (!this.expandFunctionQName(name)) {
            this.reportBadPrefix(name.prefix());
        }
        if ((f = this._sc.resolveFunction(qName = name.asQName(), e.arity())) == null) {
            this.reportError(new StaticFunctNameError(new StringBuffer("Function does not exist: ").append(name.string()).append(" arity: ").append(e.arity()).toString()));
        }
        e.set_function(f);
        this._resolvedFunctions.add(qName);
        this.visitExprs(e.iterator());
        return null;
    }

    @Override
    public Object visit(SingleType e) {
        QName type = e.type();
        if (!this.expandItemTypeQName(type)) {
            this.reportBadPrefix(type.prefix());
        }
        return null;
    }

    @Override
    public Object visit(SequenceType e) {
        ItemType it = e.item_type();
        if (it != null) {
            it.accept(this);
        }
        return null;
    }

    @Override
    public Object visit(ItemType e) {
        switch (e.type()) {
            case 0: {
                break;
            }
            case 1: {
                QName type = e.qname();
                if (!this.expandItemTypeQName(type)) {
                    this.reportBadPrefix(type.prefix());
                }
                if (BuiltinTypeLibrary.BUILTIN_TYPES.lookupType(e.qname().namespace(), e.qname().local()) != null || this._sc.getTypeModel() != null && this._sc.getTypeModel().lookupType(e.qname().namespace(), e.qname().local()) != null) break;
                this.reportError(new StaticTypeNameError(new StringBuffer("Type not defined: ").append(e.qname().string()).toString()));
                break;
            }
            case 2: {
                e.kind_test().accept(this);
            }
        }
        return null;
    }

    @Override
    public Object visit(AnyKindTest e) {
        return null;
    }

    @Override
    public Object visit(DocumentTest e) {
        switch (e.type()) {
            case 1: {
                e.elem_test().accept(this);
                break;
            }
            case 2: {
                e.schema_elem_test().accept(this);
            }
        }
        return null;
    }

    @Override
    public Object visit(TextTest e) {
        return null;
    }

    @Override
    public Object visit(CommentTest e) {
        return null;
    }

    @Override
    public Object visit(PITest e) {
        String arg = e.arg();
        if (arg == null) {
            arg = "";
        }
        return null;
    }

    @Override
    public Object visit(AttributeTest e) {
        QName name = e.name();
        if (name != null && !this.expandItemQName(name)) {
            this.reportBadPrefix(name.prefix());
        }
        if ((name = e.type()) != null && !this.expandItemTypeQName(name)) {
            this.reportBadPrefix(name.prefix());
        }
        return null;
    }

    @Override
    public Object visit(SchemaAttrTest e) {
        QName name = e.arg();
        if (!this.expandItemQName(name)) {
            this.reportBadPrefix(name.prefix());
        }
        if (this._sc.getTypeModel().lookupAttributeDeclaration(name.namespace(), name.local()) == null) {
            this.reportError(new StaticAttrNameError(new StringBuffer("Attribute not decleared: ").append(name.string()).toString()));
        }
        return null;
    }

    @Override
    public Object visit(ElementTest e) {
        if (e.name() != null && !this.expandItemTypeQName(e.name())) {
            this.reportBadPrefix(e.name().prefix());
        }
        if (e.type() != null && !this.expandItemTypeQName(e.type())) {
            this.reportBadPrefix(e.type().prefix());
        }
        return null;
    }

    @Override
    public Object visit(SchemaElemTest e) {
        QName elem = e.name();
        if (!this.expandItemQName(elem)) {
            this.reportBadPrefix(elem.prefix());
        }
        if (this._sc.getTypeModel().lookupElementDeclaration(elem.namespace(), elem.local()) == null) {
            this.reportError(new StaticElemNameError(new StringBuffer("Element not declared: ").append(elem.string()).toString()));
        }
        return null;
    }

    private void visitCollExprs(Iterator i) {
        while (i.hasNext()) {
            Collection exprs = (Collection)i.next();
            this.visitExprs(exprs.iterator());
        }
    }

    @Override
    public Object visit(AxisStep e) {
        e.step().accept(this);
        this.visitCollExprs(e.iterator());
        return null;
    }

    @Override
    public Object visit(FilterExpr e) {
        e.primary().accept(this);
        this.visitCollExprs(e.iterator());
        return null;
    }

    public boolean isRootUsed() {
        return this._rootUsed;
    }

    static class DummyError
    extends Error {
        private static final long serialVersionUID = 3898564402981741950L;

        DummyError() {
        }
    }

    class VariableScope {
        public final QName name;
        public final org.eclipse.wst.xml.xpath2.api.typesystem.ItemType typeDef;
        public final VariableScope nextScope;

        public VariableScope(QName name, org.eclipse.wst.xml.xpath2.api.typesystem.ItemType typeDef, VariableScope nextScope) {
            this.name = name;
            this.typeDef = typeDef;
            this.nextScope = nextScope;
        }
    }
}

