/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.xsd.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.internal.xtend.type.baseimpl.OperationImpl;
import org.eclipse.internal.xtend.type.baseimpl.PropertyImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.ListTypeImpl;
import org.eclipse.xtend.expression.TypeSystemImpl;
import org.eclipse.xtend.typesystem.AbstractTypeImpl;
import org.eclipse.xtend.typesystem.Feature;
import org.eclipse.xtend.typesystem.MetaModel;
import org.eclipse.xtend.typesystem.Type;
import org.eclipse.xtend.typesystem.xsd.XSDMetaModel;
import org.eclipse.xtend.typesystem.xsd.type.EFeatureMapEntryTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EFeatureMapTypeImpl
extends AbstractTypeImpl {
    private static Log log = LogFactory.getLog(EFeatureMapTypeImpl.class);
    protected XSDMetaModel model;
    protected EClass owner;

    static {
        if (EFeatureMapTypeImpl.cacheBugExists()) {
            log.warn((Object)"There is a bug in the internal object cache of Xpand. Therefore feature maps (which are needed to handle mixed XML content) will be just partially functional. Please update to the latest version of Xpand.");
        }
    }

    public static boolean cacheBugExists() {
        TypeSystemImpl ts = new TypeSystemImpl();
        ts.registerMetaModel((MetaModel)new XSDMetaModel());
        EObject cls = EcoreFactory.eINSTANCE.createEObject();
        Type t1 = ts.getType(new ArrayList());
        Type t2 = ts.getType((Object)new BasicFeatureMap((InternalEObject)cls, 1));
        return t1.equals(t2);
    }

    public static boolean isFeatureMap(ETypedElement element) {
        return element != null && element.eContainer() instanceof EClass && element.getEType() != null && element.getEType().getInstanceClass() == FeatureMap.Entry.class;
    }

    public EFeatureMapTypeImpl(XSDMetaModel model, String name, EClass owner) {
        super(model.getTypeSystem(), name);
        this.owner = owner;
        this.model = model;
    }

    public Feature[] getContributedFeatures() {
        ArrayList<Object> features = new ArrayList<Object>();
        for (final EStructuralFeature feature : this.getMapFeatures()) {
            Type type = this.model.getTypeForETypedElement((ETypedElement)feature);
            if (type == null) {
                type = this.getTypeSystem().getObjectType();
            }
            if (!(type instanceof ListTypeImpl)) {
                type = this.getTypeSystem().getListType(type);
            }
            features.add(new PropertyImpl((Type)this, feature.getName(), type){

                public Object get(Object target) {
                    FeatureMap map = (FeatureMap)target;
                    return map.list(feature);
                }
            });
        }
        features.add(new OperationImpl((Type)this, "add", this.getTypeSystem().getBooleanType(), new Type[]{this.model.getEFeatureType(), this.getTypeSystem().getObjectType()}){

            protected Object evaluateInternal(Object target, Object[] params) {
                FeatureMap map = (FeatureMap)target;
                EStructuralFeature f = (EStructuralFeature)params[0];
                return map.add(f, params[1]);
            }
        });
        features.add(new OperationImpl((Type)this, "set", this.getTypeSystem().getVoidType(), new Type[]{this.model.getEFeatureType(), this.getTypeSystem().getObjectType()}){

            protected Object evaluateInternal(Object target, Object[] params) {
                FeatureMap map = (FeatureMap)target;
                EStructuralFeature f = (EStructuralFeature)params[0];
                map.set(f, params[1]);
                return null;
            }
        });
        features.add(new OperationImpl((Type)this, "unset", this.getTypeSystem().getVoidType(), new Type[]{this.model.getEFeatureType()}){

            protected Object evaluateInternal(Object target, Object[] params) {
                FeatureMap map = (FeatureMap)target;
                EStructuralFeature f = (EStructuralFeature)params[0];
                map.unset(f);
                return null;
            }
        });
        features.add(new OperationImpl((Type)this, "isSet", this.getTypeSystem().getBooleanType(), new Type[]{this.model.getEFeatureType()}){

            protected Object evaluateInternal(Object target, Object[] params) {
                FeatureMap map = (FeatureMap)target;
                EStructuralFeature f = (EStructuralFeature)params[0];
                return map.isSet(f);
            }
        });
        features.add(new OperationImpl((Type)this, "list", this.getTypeSystem().getListType(this.getTypeSystem().getObjectType()), new Type[]{this.model.getEFeatureType()}){

            protected Object evaluateInternal(Object target, Object[] params) {
                FeatureMap map = (FeatureMap)target;
                EStructuralFeature f = (EStructuralFeature)params[0];
                return map.list(f);
            }
        });
        features.add(new OperationImpl((Type)this, "addAll", this.getTypeSystem().getBooleanType(), new Type[]{this.model.getEFeatureType(), this.getTypeSystem().getCollectionType(this.getTypeSystem().getObjectType())}){

            protected Object evaluateInternal(Object target, Object[] params) {
                FeatureMap map = (FeatureMap)target;
                EStructuralFeature f = (EStructuralFeature)params[0];
                Collection o = (Collection)params[1];
                return map.addAll(f, o);
            }
        });
        features.add(new OperationImpl((Type)this, "addFrom", this.getTypeSystem().getVoidType(), new Type[]{this.model.getEobjectType()}){

            protected Object evaluateInternal(Object target, Object[] params) {
                FeatureMap map = (FeatureMap)target;
                EStructuralFeature.Setting s = (EStructuralFeature.Setting)map;
                EObject o = (EObject)params[0];
                FeatureMapUtil.Validator v = FeatureMapUtil.getValidator((EClass)s.getEObject().eClass(), (EStructuralFeature)s.getEStructuralFeature());
                for (EStructuralFeature f : o.eClass().getEAllStructuralFeatures()) {
                    if (f.isDerived() || !o.eIsSet(f)) continue;
                    Object val = o.eGet(f);
                    if (val instanceof FeatureMap) {
                        for (FeatureMap.Entry e : new ArrayList((FeatureMap)val)) {
                            if (!v.isValid(e.getEStructuralFeature())) continue;
                            this.add(map, e.getEStructuralFeature(), e.getValue());
                        }
                        continue;
                    }
                    if (!v.isValid(f)) continue;
                    this.add(map, f, val);
                }
                return null;
            }

            private void add(FeatureMap map, EStructuralFeature f, Object val) {
                if (f.isMany() && val instanceof Collection) {
                    map.addAll(f, (Collection)val);
                } else {
                    map.add(f, val);
                }
            }
        });
        return features.toArray(new Feature[features.size()]);
    }

    protected List<EStructuralFeature> getMapFeatures() {
        return Collections.EMPTY_LIST;
    }

    protected Set<? extends Type> internalGetSuperTypes() {
        EFeatureMapEntryTypeImpl f = this.model.getEFeatureMapEntryType();
        return Collections.singleton(this.getTypeSystem().getListType((Type)f));
    }

    public boolean isInstance(Object o) {
        return o instanceof FeatureMap;
    }

    public Object newInstance() {
        throw new UnsupportedOperationException("Feature maps can not be instantiated outside EObjects");
    }

    public EClass getOwner() {
        return this.owner;
    }
}

