/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.google.common.base.Optional;
import com.spotify.docker.client.DockerCertificateException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerCertificates {
    public static final String DEFAULT_CA_CERT_NAME = "ca.pem";
    public static final String DEFAULT_CLIENT_CERT_NAME = "cert.pem";
    public static final String DEFAULT_CLIENT_KEY_NAME = "key.pem";
    private static final char[] KEY_STORE_PASSWORD = "docker!!11!!one!".toCharArray();
    private static final Logger log = LoggerFactory.getLogger(DockerCertificates.class);
    private final SSLContext sslContext;

    public DockerCertificates(Path dockerCertPath) throws DockerCertificateException {
        this(new Builder().dockerCertPath(dockerCertPath));
    }

    private DockerCertificates(Builder builder) throws DockerCertificateException {
        if (builder.caCertPath == null || builder.clientCertPath == null || builder.clientKeyPath == null) {
            throw new DockerCertificateException("caCertPath, clientCertPath, and clientKeyPath must all be specified");
        }
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate caCert = cf.generateCertificate(Files.newInputStream(builder.caCertPath, new OpenOption[0]));
            Certificate clientCert = cf.generateCertificate(Files.newInputStream(builder.clientCertPath, new OpenOption[0]));
            PEMKeyPair clientKeyPair = (PEMKeyPair)new PEMParser((Reader)Files.newBufferedReader(builder.clientKeyPath, Charset.defaultCharset())).readObject();
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(clientKeyPair.getPrivateKeyInfo().getEncoded());
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PrivateKey clientKey = kf.generatePrivate(spec);
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            trustStore.setEntry("ca", new KeyStore.TrustedCertificateEntry(caCert), null);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            keyStore.setCertificateEntry("client", clientCert);
            keyStore.setKeyEntry("key", clientKey, KEY_STORE_PASSWORD, new Certificate[]{clientCert});
            this.sslContext = SSLContexts.custom().loadTrustMaterial(trustStore, null).loadKeyMaterial(keyStore, KEY_STORE_PASSWORD).build();
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | InvalidKeySpecException e) {
            throw new DockerCertificateException(e);
        }
    }

    public SSLContext sslContext() {
        return this.sslContext;
    }

    public X509HostnameVerifier hostnameVerifier() {
        return SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Path caCertPath;
        private Path clientKeyPath;
        private Path clientCertPath;

        public Builder dockerCertPath(Path dockerCertPath) {
            this.caCertPath = dockerCertPath.resolve(DockerCertificates.DEFAULT_CA_CERT_NAME);
            this.clientKeyPath = dockerCertPath.resolve(DockerCertificates.DEFAULT_CLIENT_KEY_NAME);
            this.clientCertPath = dockerCertPath.resolve(DockerCertificates.DEFAULT_CLIENT_CERT_NAME);
            return this;
        }

        public Builder caCertPath(Path caCertPath) {
            this.caCertPath = caCertPath;
            return this;
        }

        public Builder clientKeyPath(Path clientKeyPath) {
            this.clientKeyPath = clientKeyPath;
            return this;
        }

        public Builder clientCertPath(Path clientCertPath) {
            this.clientCertPath = clientCertPath;
            return this;
        }

        public Optional<DockerCertificates> build() throws DockerCertificateException {
            if (this.caCertPath == null || this.clientKeyPath == null || this.clientCertPath == null) {
                log.debug("caCertPath, clientKeyPath or clientCertPath not specified, not using SSL");
                return Optional.absent();
            }
            if (Files.exists(this.caCertPath, new LinkOption[0]) && Files.exists(this.clientKeyPath, new LinkOption[0]) && Files.exists(this.clientCertPath, new LinkOption[0])) {
                return Optional.of((Object)new DockerCertificates(this));
            }
            log.debug("{}, {} or {} does not exist, not using SSL", new Object[]{this.caCertPath, this.clientKeyPath, this.clientCertPath});
            return Optional.absent();
        }
    }
}

