/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.selection.event;

import java.util.Collection;
import java.util.Set;
import net.sourceforge.nattable.coordinate.Range;
import net.sourceforge.nattable.layer.event.ILayerEventHandler;
import net.sourceforge.nattable.layer.event.IStructuralChangeEvent;
import net.sourceforge.nattable.selection.ISelectionModel;
import net.sourceforge.nattable.selection.SelectionLayer;
import org.eclipse.swt.graphics.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionLayerStructuralChangeEventHandler
implements ILayerEventHandler<IStructuralChangeEvent> {
    private ISelectionModel selectionModel;
    private final SelectionLayer selectionLayer;

    public SelectionLayerStructuralChangeEventHandler(SelectionLayer selectionLayer, ISelectionModel selectionModel) {
        this.selectionLayer = selectionLayer;
        this.selectionModel = selectionModel;
    }

    @Override
    public Class<IStructuralChangeEvent> getLayerEventClass() {
        return IStructuralChangeEvent.class;
    }

    @Override
    public void handleLayerEvent(IStructuralChangeEvent event) {
        event.isHorizontalStructureChanged();
        if (event.isVerticalStructureChanged()) {
            Collection<Rectangle> rectangles = event.getChangedPositionRectangles();
            for (Rectangle rectangle : rectangles) {
                if (!this.selectedRowModified(rectangle.y)) continue;
                this.selectionLayer.clear();
            }
        }
    }

    private boolean selectedRowModified(int rowPosition) {
        Set<Range> selectedRows = this.selectionModel.getSelectedRows();
        for (Range rowRange : selectedRows) {
            if (!rowRange.contains(rowPosition)) continue;
            return true;
        }
        return false;
    }
}

