/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.acceleo.common.internal.utils.AcceleoPackageRegistry;
import org.eclipse.acceleo.common.internal.utils.LazyEPackageDescriptor;
import org.eclipse.acceleo.common.internal.utils.compatibility.AcceleoCompatibilityEclipseHelper;
import org.eclipse.acceleo.common.internal.utils.compatibility.AcceleoOCLReflection;
import org.eclipse.acceleo.common.internal.utils.compatibility.OCLVersion;
import org.eclipse.acceleo.common.utils.CompactHashSet;
import org.eclipse.acceleo.common.utils.CompactLinkedHashSet;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoCompletionChoice;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoCompletionImportProposal;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoCompletionProposal;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoCompletionTemplateProposal;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoSourceContent;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.AcceleoUIDocumentationUtils;
import org.eclipse.acceleo.internal.ide.ui.resource.AcceleoUIResourceSet;
import org.eclipse.acceleo.internal.ide.ui.views.overrides.OverridesBrowser;
import org.eclipse.acceleo.internal.ide.ui.views.proposals.ProposalsBrowser;
import org.eclipse.acceleo.internal.parser.ast.ocl.environment.AcceleoEnvironment;
import org.eclipse.acceleo.internal.parser.cst.utils.Sequence;
import org.eclipse.acceleo.internal.parser.cst.utils.SequenceBlock;
import org.eclipse.acceleo.model.mtl.DocumentedElement;
import org.eclipse.acceleo.model.mtl.Macro;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.parser.cst.Block;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.acceleo.parser.cst.CstPackage;
import org.eclipse.acceleo.parser.cst.ForBlock;
import org.eclipse.acceleo.parser.cst.IfBlock;
import org.eclipse.acceleo.parser.cst.InitSection;
import org.eclipse.acceleo.parser.cst.LetBlock;
import org.eclipse.acceleo.parser.cst.ModelExpression;
import org.eclipse.acceleo.parser.cst.ModuleExtendsValue;
import org.eclipse.acceleo.parser.cst.ModuleImportsValue;
import org.eclipse.acceleo.parser.cst.Template;
import org.eclipse.acceleo.parser.cst.TemplateExpression;
import org.eclipse.acceleo.parser.cst.TemplateOverridesValue;
import org.eclipse.acceleo.parser.cst.TextExpression;
import org.eclipse.acceleo.parser.cst.TypedModel;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.helper.Choice;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AcceleoCompletionProcessor
implements IContentAssistProcessor {
    private static final Pattern CAMEL_CASE_PATTERN = Pattern.compile("([a-z]+|[A-Z][a-z]*)");
    private static final char[] AUTO_ACTIVATION_CHARACTERS = AcceleoCompatibilityEclipseHelper.getCurrentOCLVersion() == OCLVersion.GANYMEDE ? new char[]{' ', '.', '[', '-', '>', ':'} : new char[]{'.', '[', '-', '>', ':'};
    protected ITextViewer textViewer;
    protected AcceleoSourceContent content;
    protected String text;
    private final String defaultStart = " ${";
    private int offset;
    private CSTNode cstNode;
    private String defaultVariableType;
    private boolean disableAutoActivation;

    public AcceleoCompletionProcessor(AcceleoSourceContent content) {
        this.content = content;
        this.defaultVariableType = "Type";
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int pos) {
        this.textViewer = viewer;
        this.setText(viewer);
        if (viewer != null) {
            ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
            if (selection != null && selection.getOffset() == pos) {
                this.setCompletionOffset(selection.getOffset() + selection.getLength());
            } else {
                this.setCompletionOffset(pos);
            }
        } else {
            this.setCompletionOffset(pos);
        }
        this.cstNode = this.content.getCSTNode(this.offset, this.offset);
        if (this.cstNode instanceof InitSection && this.offset == this.cstNode.getStartPosition() && this.cstNode.eContainer() != null) {
            this.cstNode = (CSTNode)this.cstNode.eContainer();
        }
        try {
            ICompletionProposal[] iCompletionProposalArray = this.computeCompletionProposals();
            return iCompletionProposalArray;
        }
        finally {
            this.textViewer = null;
            this.text = null;
            this.setCompletionOffset(0);
            this.cstNode = null;
        }
    }

    private ICompletionProposal[] computeCompletionProposals() {
        ITextSelection selection;
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        if (this.textViewer != null && this.cstNode instanceof TextExpression && (selection = (ITextSelection)this.textViewer.getSelectionProvider().getSelection()) != null && selection.getLength() > 0) {
            Template template = (Template)this.content.getCSTParent(this.cstNode, Template.class);
            this.computeSelectionReplacementProposals(proposals, template, selection.getOffset(), selection.getOffset() + selection.getLength());
        }
        if (this.cstNode == null || this.cstNode instanceof org.eclipse.acceleo.parser.cst.Module && this.cstNode.getEndPosition() == 0 && this.cstNode.getStartPosition() == 0) {
            this.computeModulePatternProposals(proposals);
        } else if (this.cstNode instanceof TypedModel) {
            this.computeEPackageProposals(proposals);
        } else if (this.cstNode instanceof ModuleImportsValue || this.cstNode instanceof ModuleExtendsValue) {
            this.computeImportProposals(proposals);
        } else if (this.offset > 0 && this.text.charAt(this.offset - 1) != '/') {
            this.computeEClassifierProposals(proposals);
            boolean addPatterns = false;
            if (proposals.size() == 0) {
                this.computeKeywordsProposals(proposals);
                if (!this.isNextSignificantChar(']')) {
                    addPatterns = true;
                }
            }
            if (this.text.charAt(this.offset - 1) != ']') {
                if (this.cstNode instanceof ModelExpression || this.cstNode instanceof InitSection) {
                    this.computeOCLProposals(proposals);
                } else if (this.cstNode instanceof Template && this.text.substring(this.cstNode.getStartPosition(), this.offset).contains("]")) {
                    this.computeOCLProposals(proposals);
                } else if (this.cstNode instanceof Block && !(this.cstNode instanceof Template)) {
                    this.computeOCLProposals(proposals);
                } else if (this.cstNode instanceof org.eclipse.acceleo.parser.cst.Query && this.cstNode.getStartPosition() > -1 && this.offset > this.cstNode.getStartPosition() && this.isHeaderAfterParenthesis(this.text.substring(this.cstNode.getStartPosition(), this.offset))) {
                    this.computeOCLProposals(proposals);
                } else if (this.cstNode instanceof TemplateOverridesValue) {
                    this.computeTemplatesProposals(proposals);
                }
            }
            if (addPatterns) {
                this.computePatternsProposals(proposals);
            }
        }
        this.computeProposalsBrowserView(proposals);
        if (this.cstNode instanceof org.eclipse.acceleo.parser.cst.Module) {
            this.computeOverridesBrowserView(proposals);
        }
        if (proposals.size() == 0 && this.textViewer != null && this.textViewer.getTextWidget() != null && this.offset < this.text.length() && this.text.charAt(this.offset) == ']' && this.text.charAt(this.offset - 1) == '[') {
            this.textViewer.getTextWidget().replaceTextRange(this.offset, 0, "/");
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private void computeSelectionReplacementProposals(List<ICompletionProposal> proposals, Template template, int begin, int end) {
        if (template != null && template.getEndPosition() > -1 && template.getEndPosition() <= this.text.length()) {
            int last;
            String stringToReplace = this.text.substring(begin, end);
            String stringToReplaceLower = stringToReplace.toLowerCase();
            String endingTextS = this.text.substring(begin, template.getEndPosition());
            StringBuffer endingText = new StringBuffer(endingTextS);
            StringBuffer endingTextLower = new StringBuffer(endingTextS.toLowerCase());
            int count = 0;
            int i = endingTextLower.indexOf(stringToReplaceLower);
            int shift = 0;
            while (i > -1 && i < endingText.length()) {
                int b = i;
                int e = b + stringToReplace.length();
                CSTNode newNode = this.content.getCSTNode(begin + b - shift, begin + b - shift);
                if (newNode instanceof TextExpression) {
                    ++count;
                    String stringFound = endingText.substring(b, e);
                    String replacementString = stringFound.length() > 1 && stringFound.equals(stringFound.toUpperCase()) ? "[${name}.toUpper()/]" : (Character.isUpperCase(stringFound.charAt(0)) ? "[${name}.toUpperFirst()/]" : "[${name}/]");
                    endingText.replace(b, e, replacementString);
                    endingTextLower.replace(b, e, replacementString);
                    shift += replacementString.length() - (e - b);
                    i = endingTextLower.indexOf(stringToReplaceLower, b + replacementString.length());
                    continue;
                }
                i = newNode == null ? -1 : endingTextLower.indexOf(stringToReplaceLower, e);
            }
            Image image = AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/RefactorTextSelection.gif");
            String label = count > 1 ? "Replacing by [ ] - " + count + " times" : "Replacing by [ ]";
            i = last = endingText.length() - 1;
            while (i >= 0) {
                char c = endingText.charAt(i);
                if (c == '$' && (i == last || endingText.charAt(i + 1) != '{')) {
                    endingText.insert(i, '$');
                }
                --i;
            }
            proposals.add(this.createTemplateProposal(endingText.toString(), begin, template.getEndPosition() - begin, begin, image, label, null, String.valueOf(stringToReplace) + " -> [name/]"));
        }
    }

    private void computeProposalsBrowserView(List<ICompletionProposal> proposals) {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow == null || activeWindow.getActivePage() == null) {
            return;
        }
        IWorkbenchPage page = activeWindow.getActivePage();
        IViewReference[] references = page.getViewReferences();
        int i = 0;
        while (i < references.length) {
            List<ICompletionProposal> advancedCompletionProposals;
            IViewReference viewReference = references[i];
            IViewPart view = viewReference.getView(false);
            if (view instanceof ProposalsBrowser && page.isPartVisible((IWorkbenchPart)view) && this.textViewer != null && (advancedCompletionProposals = ((ProposalsBrowser)view).getPatternCompletionProposals(this.textViewer.getDocument(), this.text, this.offset, this.cstNode)).size() > 0) {
                proposals.addAll(0, advancedCompletionProposals);
            }
            ++i;
        }
    }

    private void computeOverridesBrowserView(List<ICompletionProposal> proposals) {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow == null || activeWindow.getActivePage() == null) {
            return;
        }
        IWorkbenchPage page = activeWindow.getActivePage();
        IViewReference[] references = page.getViewReferences();
        int i = 0;
        while (i < references.length) {
            List<ICompletionProposal> advancedCompletionProposals;
            IViewReference viewReference = references[i];
            IViewPart view = viewReference.getView(false);
            if (view instanceof OverridesBrowser && page.isPartVisible((IWorkbenchPart)view) && this.textViewer != null && (advancedCompletionProposals = ((OverridesBrowser)view).getExtendCompletionProposals(this.textViewer.getDocument(), this.text, this.offset)).size() > 0) {
                proposals.addAll(0, advancedCompletionProposals);
            }
            ++i;
        }
    }

    private boolean isNextSignificantChar(char ref) {
        if (this.offset < this.text.length()) {
            char c;
            int i = this.offset;
            while (Character.isWhitespace(c = this.text.charAt(i)) && ++i < this.text.length()) {
            }
            return c == ref;
        }
        return false;
    }

    private void computeTemplatesProposals(List<ICompletionProposal> proposals) {
        int i = this.offset;
        while (i > 0 && Character.isJavaIdentifierPart(this.text.charAt(i - 1))) {
            --i;
        }
        String start = this.text.substring(i, this.offset);
        int startPosition = this.cstNode.getStartPosition();
        if (startPosition < 0) {
            startPosition = 0;
        }
        if (startPosition > this.offset) {
            startPosition = this.offset;
        }
        String textOCL = this.text.substring(startPosition, this.offset);
        Collection<Choice> choices = this.content.getSyntaxHelp(textOCL, this.offset);
        CompactHashSet duplicated = new CompactHashSet();
        for (Choice next : choices) {
            String replacementString = next.getName();
            if (!AcceleoCompletionProcessor.startsWithOrMatchCamelCase(replacementString, start)) continue;
            switch (next.getKind()) {
                case OPERATION: {
                    if (!(next.getElement() instanceof EOperation)) break;
                    Image image = AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Template.gif");
                    EOperation eOperation = (EOperation)next.getElement();
                    String description = eOperation.getEContainingClass() != null ? String.valueOf(eOperation.getEContainingClass().getName()) + "." + next.getDescription() : next.getDescription();
                    if (duplicated.contains(next.getDescription())) break;
                    duplicated.add(next.getDescription());
                    proposals.add(this.createCompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementString.length(), image, next.getDescription(), null, description));
                    break;
                }
            }
        }
    }

    private void computeOCLProposals(List<ICompletionProposal> proposals) {
        int i = this.offset;
        while (i > 0 && Character.isJavaIdentifierPart(this.text.charAt(i - 1))) {
            --i;
        }
        String start = this.text.substring(i, this.offset);
        int startPosition = this.cstNode.getStartPosition();
        if (startPosition < 0) {
            startPosition = 0;
        }
        if (startPosition > this.offset) {
            startPosition = this.offset;
        }
        int oclIndex = this.offset;
        while (oclIndex > 0 && Character.isJavaIdentifierPart(this.text.charAt(oclIndex - 1))) {
            --oclIndex;
        }
        String textOCL = this.text.substring(startPosition, oclIndex);
        Collection<Choice> choices = this.content.getSyntaxHelp(textOCL, oclIndex);
        CompactHashSet duplicated = new CompactHashSet();
        for (Choice next : choices) {
            String choiceValue = next.getName();
            String replacement = this.getReplacementStringFor(choiceValue);
            if (!AcceleoCompletionProcessor.startsWithOrMatchCamelCase(choiceValue, start) && !AcceleoCompletionProcessor.startsWithOrMatchCamelCase(replacement, start)) continue;
            switch (next.getKind()) {
                case OPERATION: {
                    this.addOCLOperationChoice(proposals, next, start, (Set<String>)duplicated);
                    break;
                }
                case PROPERTY: 
                case SIGNAL: {
                    String descriptionProperty;
                    String displayProperty = next.getDescription();
                    if (next.getElement() instanceof EStructuralFeature) {
                        displayProperty = this.getPropertyDisplay((EStructuralFeature)next.getElement());
                        StringBuilder descriptionPropertyBuilder = new StringBuilder(displayProperty);
                        descriptionPropertyBuilder.append("\n\t defined on ");
                        descriptionPropertyBuilder.append(((EStructuralFeature)next.getElement()).getEContainingClass().getName());
                        descriptionProperty = descriptionPropertyBuilder.toString();
                    } else {
                        descriptionProperty = displayProperty;
                    }
                    if (duplicated.contains(displayProperty)) break;
                    duplicated.add(displayProperty);
                    proposals.add(this.createCompletionProposal(replacement, this.offset - start.length(), start.length(), replacement.length(), AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Property.gif"), displayProperty, null, descriptionProperty));
                    break;
                }
                case ENUMERATION_LITERAL: {
                    if (duplicated.contains(choiceValue)) break;
                    duplicated.add(choiceValue);
                    proposals.add(this.createCompletionProposal(replacement, this.offset - start.length(), start.length(), replacement.length(), AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/EnumLiteral.gif"), choiceValue, null, next.getDescription()));
                    break;
                }
                case VARIABLE: {
                    String description;
                    String displayVariable;
                    if ("self".equals(choiceValue) || next.getDescription() == null) {
                        displayVariable = choiceValue;
                        description = "";
                    } else {
                        displayVariable = String.valueOf(choiceValue) + ':' + next.getDescription();
                        description = next.getDescription();
                    }
                    if (duplicated.contains(displayVariable)) break;
                    duplicated.add(displayVariable);
                    proposals.add(this.createCompletionProposal(replacement, this.offset - start.length(), start.length(), replacement.length(), AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Variable.gif"), displayVariable, null, description));
                    break;
                }
            }
        }
    }

    private String getReplacementStringFor(String choiceValue) {
        if (this.content.getOCLEnvironment() instanceof AcceleoEnvironment && AcceleoOCLReflection.getReservedKeywords().contains(choiceValue)) {
            return String.valueOf('_') + choiceValue;
        }
        return choiceValue;
    }

    private void addOCLOperationChoice(List<ICompletionProposal> proposals, Choice nextOperationChoice, String start, Set<String> duplicated) {
        Image image;
        String description = "";
        if (nextOperationChoice instanceof AcceleoCompletionChoice) {
            AcceleoCompletionChoice acceleoCompletionChoice = (AcceleoCompletionChoice)nextOperationChoice;
            ModuleElement acceleoElement = acceleoCompletionChoice.getAcceleoElement();
            image = this.computeImage(acceleoElement);
            description = this.computeDescription(acceleoElement);
        } else {
            image = AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Operation.gif");
        }
        if (nextOperationChoice.getElement() instanceof EOperation) {
            EOperation eOperation = (EOperation)nextOperationChoice.getElement();
            String replacementStringWithArgsBefore = String.valueOf(this.getReplacementStringFor(eOperation.getName())) + "(";
            String replacementStringWithArgsAfter = "";
            Iterator eParametersIt = eOperation.getEParameters().iterator();
            while (eParametersIt.hasNext()) {
                EParameter eParameter = (EParameter)eParametersIt.next();
                replacementStringWithArgsAfter = String.valueOf(replacementStringWithArgsAfter) + "${" + eParameter.getName() + "}";
                if (!eParametersIt.hasNext()) continue;
                replacementStringWithArgsAfter = String.valueOf(replacementStringWithArgsAfter) + ", ";
            }
            replacementStringWithArgsAfter = String.valueOf(replacementStringWithArgsAfter) + ')';
            if (description.length() == 0) {
                description = AcceleoUIDocumentationUtils.getTextFrom(eOperation);
            }
            if (description.length() == 0) {
                description = eOperation.getEContainingClass() != null ? "\n" + eOperation.getEContainingClass().getName() + "." + nextOperationChoice.getDescription() : "\n" + nextOperationChoice.getDescription();
            }
            if (!duplicated.contains(nextOperationChoice.getDescription())) {
                duplicated.add(nextOperationChoice.getDescription());
                proposals.add(this.createTemplateProposal(String.valueOf(replacementStringWithArgsBefore) + replacementStringWithArgsAfter, this.offset - start.length(), start.length(), replacementStringWithArgsBefore.length(), image, nextOperationChoice.getDescription(), null, description));
            }
        } else if (!duplicated.contains(nextOperationChoice.getDescription())) {
            duplicated.add(nextOperationChoice.getDescription());
            String replacementString = nextOperationChoice.getName();
            if (replacementString.contains("(")) {
                replacementString = this.getReplacementStringFor(replacementString.substring(0, replacementString.indexOf(40)));
            }
            proposals.add(this.createCompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementString.length(), image, nextOperationChoice.getDescription(), null, String.valueOf(nextOperationChoice.getDescription()) + description));
        }
    }

    private String computeDescription(ModuleElement acceleoElement) {
        String description = "";
        if (acceleoElement instanceof org.eclipse.acceleo.model.mtl.Template) {
            org.eclipse.acceleo.model.mtl.Template template = (org.eclipse.acceleo.model.mtl.Template)acceleoElement;
            description = AcceleoUIDocumentationUtils.getDocumentation((DocumentedElement)template);
        } else if (acceleoElement instanceof Query) {
            Query query = (Query)acceleoElement;
            description = AcceleoUIDocumentationUtils.getDocumentation((DocumentedElement)query);
        } else if (acceleoElement instanceof Macro) {
            Macro macro = (Macro)acceleoElement;
            description = AcceleoUIDocumentationUtils.getDocumentation((DocumentedElement)macro);
        }
        return description;
    }

    private Image computeImage(ModuleElement acceleoElement) {
        Image image = null;
        if (acceleoElement instanceof org.eclipse.acceleo.model.mtl.Template) {
            org.eclipse.acceleo.model.mtl.Template template = (org.eclipse.acceleo.model.mtl.Template)acceleoElement;
            image = AcceleoUIDocumentationUtils.getCompletionImage(template);
        } else if (acceleoElement instanceof Query) {
            Query query = (Query)acceleoElement;
            image = AcceleoUIDocumentationUtils.getCompletionImage(query);
        } else {
            image = acceleoElement instanceof Macro ? AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Macro.gif") : AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Operation.gif");
        }
        return image;
    }

    private String getPropertyDisplay(EStructuralFeature eStructuralFeature) {
        StringBuffer displayProperty = new StringBuffer();
        displayProperty.append(eStructuralFeature.getName());
        if (eStructuralFeature.isMany()) {
            displayProperty.append(": ");
            if (eStructuralFeature.isUnique() && eStructuralFeature.isOrdered()) {
                displayProperty.append("OrderedSet(");
            } else if (eStructuralFeature.isUnique()) {
                displayProperty.append("Set(");
            } else if (eStructuralFeature.isOrdered()) {
                displayProperty.append("Sequence(");
            } else {
                displayProperty.append("Bag(");
            }
            if (eStructuralFeature.getEType() != null) {
                displayProperty.append(eStructuralFeature.getEType().getName());
            }
            displayProperty.append(')');
        } else if (eStructuralFeature.getEType() != null) {
            displayProperty.append(':');
            displayProperty.append(eStructuralFeature.getEType().getName());
        }
        return displayProperty.toString();
    }

    private void computeImportProposals(List<ICompletionProposal> proposals) {
        int i = this.offset;
        while (i > 0 && !Character.isWhitespace(this.text.charAt(i - 1))) {
            --i;
        }
        String start = this.text.substring(i, this.offset);
        for (URI uri : this.content.getAccessibleOutputFiles()) {
            String displayString = new Path(uri.lastSegment()).removeFileExtension().lastSegment();
            if (Strings.isNullOrEmpty((String)start)) {
                proposals.add(new AcceleoCompletionImportProposal(uri, this.offset - start.length(), start.length(), AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Module.gif"), displayString));
                continue;
            }
            try {
                EObject eObject = AcceleoUIResourceSet.getResource(uri);
                if (!(eObject instanceof Module) || ((Module)eObject).getNsURI() == null || ((Module)eObject).getNsURI().length() <= 0 || !AcceleoCompletionProcessor.startsWithOrMatchCamelCase(((Module)eObject).getNsURI(), start)) continue;
                proposals.add(new AcceleoCompletionImportProposal(((Module)eObject).getNsURI(), this.offset - start.length(), start.length(), AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Module.gif"), displayString));
            }
            catch (IOException iOException) {}
        }
    }

    private void computeEPackageProposals(List<ICompletionProposal> proposals) {
        int i = this.offset;
        while (i > 0 && this.text.charAt(i - 1) != '(' && this.text.charAt(i - 1) != ',' && this.text.charAt(i - 1) != '\'') {
            --i;
        }
        String start = this.text.substring(i, this.offset);
        for (String pURI : new CompactLinkedHashSet((Collection)AcceleoPackageRegistry.INSTANCE.keySet())) {
            if (!AcceleoCompletionProcessor.startsWithOrMatchCamelCase(pURI, start)) continue;
            proposals.add(this.createCompletionProposal(pURI, this.offset - start.length(), start.length(), pURI.length(), AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/URI.gif"), pURI, null, pURI));
        }
        if (start.length() > 0) {
            for (String pURI : new CompactLinkedHashSet((Collection)AcceleoPackageRegistry.INSTANCE.keySet())) {
                Object obj = ModelUtils.getEPackageOrDescriptor((String)pURI);
                String shortName = "";
                if (obj instanceof LazyEPackageDescriptor) {
                    shortName = ((LazyEPackageDescriptor)obj).getName();
                } else if (obj instanceof EPackage) {
                    shortName = ((EPackage)obj).getName();
                } else {
                    EPackage resolved = ModelUtils.getEPackage((String)pURI);
                    if (resolved != null) {
                        shortName = resolved.getName();
                    }
                }
                if (!AcceleoCompletionProcessor.startsWithOrMatchCamelCase(shortName, start)) continue;
                proposals.add(this.createCompletionProposal(pURI, this.offset - start.length(), start.length(), pURI.length(), AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/URI.gif"), pURI, null, pURI));
            }
        }
        ArrayList<IFile> ecoreFiles = new ArrayList<IFile>();
        try {
            this.computeEcoreFiles(ecoreFiles, (IContainer)ResourcesPlugin.getWorkspace().getRoot());
            for (IFile ecoreFile : ecoreFiles) {
                String shortName;
                String ecorePath = ecoreFile.getFullPath().toString();
                if (AcceleoCompletionProcessor.startsWithOrMatchCamelCase(ecorePath, start)) {
                    proposals.add(this.createCompletionProposal(ecorePath, this.offset - start.length(), start.length(), ecorePath.length(), AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/URI.gif"), ecorePath, null, ecorePath));
                }
                if (start.length() <= 0 || !AcceleoCompletionProcessor.startsWithOrMatchCamelCase(shortName = new Path(ecorePath).removeFileExtension().lastSegment(), start)) continue;
                proposals.add(this.createCompletionProposal(ecorePath, this.offset - start.length(), start.length(), ecorePath.length(), AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/URI.gif"), ecorePath, null, ecorePath));
            }
        }
        catch (CoreException e) {
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
        Collections.sort(proposals, new Comparator<ICompletionProposal>(){

            @Override
            public int compare(ICompletionProposal o1, ICompletionProposal o2) {
                return o1.getDisplayString().compareTo(o2.getDisplayString());
            }
        });
    }

    private void computeEcoreFiles(List<IFile> ecoreFiles, IContainer container) throws CoreException {
        Object[] children;
        if (container != null && (children = container instanceof IWorkspaceRoot ? ((IWorkspaceRoot)container).getProjects() : container.members()) != null) {
            int i = 0;
            while (i < children.length) {
                IResource resource = children[i];
                if (resource instanceof IFile && "ecore".equals(((IFile)resource).getFileExtension())) {
                    ecoreFiles.add((IFile)resource);
                } else if (resource instanceof IContainer && resource.isAccessible()) {
                    this.computeEcoreFiles(ecoreFiles, (IContainer)resource);
                }
                ++i;
            }
        }
    }

    private void computeEClassifierProposals(List<ICompletionProposal> proposals) {
        if (this.content.getCST() == null) {
            return;
        }
        int startOfCurrentWord = this.offset;
        int startOfQualifiedName = this.offset;
        while (startOfCurrentWord > 0 && Character.isJavaIdentifierPart(this.text.charAt(startOfCurrentWord - 1))) {
            --startOfCurrentWord;
        }
        startOfQualifiedName = startOfCurrentWord;
        while (startOfQualifiedName > 0 && !Character.isWhitespace(this.text.charAt(startOfQualifiedName - 1))) {
            --startOfQualifiedName;
        }
        int indexOfVarTypeSeparator = startOfQualifiedName;
        while (indexOfVarTypeSeparator > 0 && Character.isWhitespace(this.text.charAt(indexOfVarTypeSeparator - 1))) {
            --indexOfVarTypeSeparator;
        }
        if (indexOfVarTypeSeparator > 0 && (this.text.charAt(indexOfVarTypeSeparator - 1) == ':' || this.typeIsRequiredAfterParenthesis(indexOfVarTypeSeparator))) {
            String qualifiedNameStart = this.text.substring(startOfQualifiedName, startOfCurrentWord);
            if (!qualifiedNameStart.isEmpty() && !qualifiedNameStart.matches("(([A-Za-z])+(::)?)+((?<!:):)?")) {
                return;
            }
            boolean endsWithSeparator = qualifiedNameStart.endsWith(":");
            boolean endsWithSingleColon = false;
            if (endsWithSeparator) {
                endsWithSingleColon = true;
                qualifiedNameStart = qualifiedNameStart.substring(0, qualifiedNameStart.length() - 1);
            }
            if (qualifiedNameStart.endsWith(":")) {
                endsWithSingleColon = false;
                qualifiedNameStart = qualifiedNameStart.substring(0, qualifiedNameStart.length() - 1);
            }
            String[] packageNames = qualifiedNameStart.contains("::") ? qualifiedNameStart.substring(0, qualifiedNameStart.lastIndexOf("::")).split("::") : (qualifiedNameStart.length() > 0 ? new String[]{qualifiedNameStart} : new String[]{});
            String start = this.text.substring(startOfCurrentWord, this.offset);
            Iterator<EClassifier> eClassifierIt = this.content.getTypes().iterator();
            ArrayList<ICompletionProposal> classifierProposals = new ArrayList<ICompletionProposal>();
            ArrayList<ICompletionProposal> packageProposals = new ArrayList<ICompletionProposal>();
            LinkedHashSet<EPackage> packages = new LinkedHashSet<EPackage>();
            while (eClassifierIt.hasNext()) {
                EClassifier eClassifier = eClassifierIt.next();
                packages.add(eClassifier.getEPackage());
                if (!this.matchesQualifiedName(packageNames, eClassifier) || !AcceleoCompletionProcessor.startsWithOrMatchCamelCase(eClassifier.getName(), start)) continue;
                String name = eClassifier.getName();
                if (name.endsWith(")")) {
                    name = name.replaceAll("\\(", "(\\${");
                    name = name.replaceAll("\\)", "})");
                    classifierProposals.add(this.createTemplateProposal(name, this.offset - start.length(), start.length(), name.length(), AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Type.gif"), eClassifier.getName(), null, name));
                    continue;
                }
                String prefixSeparator = this.computeQualifierPrefix(qualifiedNameStart, endsWithSeparator, endsWithSingleColon);
                String replacement = String.valueOf(prefixSeparator) + eClassifier.getName();
                classifierProposals.add(this.createCompletionProposal(replacement, this.offset - start.length(), start.length(), replacement.length(), AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Type.gif"), eClassifier.getName(), null, eClassifier.getName()));
            }
            for (EPackage pack : packages) {
                if (!this.matchesQualifiedName(packageNames, pack, endsWithSeparator) || !AcceleoCompletionProcessor.startsWithOrMatchCamelCase(pack.getName(), start)) continue;
                String replacement = String.valueOf(pack.getName()) + "::";
                packageProposals.add(this.createCompletionProposal(replacement, this.offset - start.length(), start.length(), replacement.length(), AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/package.gif"), pack.getName(), null, pack.getName()));
            }
            proposals.addAll(packageProposals);
            proposals.addAll(classifierProposals);
        }
    }

    private String computeQualifierPrefix(String qualifiedNameStart, boolean endsWithSeparator, boolean endsWithSingleColon) {
        String prefix = "";
        if (qualifiedNameStart.length() > 0) {
            if (endsWithSingleColon) {
                prefix = String.valueOf(prefix) + ':';
            } else if (!endsWithSeparator) {
                prefix = String.valueOf(prefix) + "::";
            }
        }
        return prefix;
    }

    private boolean matchesQualifiedName(String[] qualifiedNameParts, EClassifier classifier) {
        if (qualifiedNameParts.length > 0) {
            ArrayList<EPackage> superPackages = new ArrayList<EPackage>();
            EPackage pack = classifier.getEPackage();
            while (pack != null) {
                superPackages.add(pack);
                pack = pack.getESuperPackage();
            }
            int i = 0;
            while (i < qualifiedNameParts.length) {
                if (!qualifiedNameParts[i].equals(((EPackage)superPackages.get(superPackages.size() - i - 1)).getName())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean matchesQualifiedName(String[] qualifiedNameParts, EPackage pack, boolean endsWithSeparator) {
        boolean result = true;
        if (qualifiedNameParts.length > 0) {
            ArrayList<EPackage> superPackages = new ArrayList<EPackage>();
            EPackage superPack = pack.getESuperPackage();
            while (superPack != null) {
                superPackages.add(superPack);
                superPack = superPack.getESuperPackage();
            }
            if (superPackages.isEmpty()) {
                result = endsWithSeparator ? false : qualifiedNameParts.length == 1 && qualifiedNameParts[0].equals(pack.getName());
            } else {
                int i = 0;
                while (i < qualifiedNameParts.length) {
                    if (result && !qualifiedNameParts[i].equals(((EPackage)superPackages.get(superPackages.size() - i - 1)).getName())) {
                        result = false;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    private boolean typeIsRequiredAfterParenthesis(int index) {
        boolean result;
        if (index <= 0 || this.text.charAt(index - 1) != '(') {
            return false;
        }
        int i = index - 1;
        while (i > 0 && Character.isJavaIdentifierPart(this.text.charAt(i - 1))) {
            --i;
        }
        String start = this.text.substring(i, index - 1);
        if (start.length() == 0) {
            result = false;
        } else if (CollectionKind.getByName((String)start) != null) {
            result = true;
        } else {
            result = false;
            int startPosition = this.cstNode.getStartPosition();
            if (startPosition < 0) {
                startPosition = 0;
            }
            if (startPosition > index - 1) {
                startPosition = index - 1;
            }
            String textOCL = this.text.substring(startPosition, index - 1);
            Iterator<Choice> choices = this.content.getSyntaxHelp(textOCL, index - 1).iterator();
            block1: while (!result && choices.hasNext()) {
                Choice next = choices.next();
                if (start.length() <= 0 || !next.getName().startsWith(start) || !(next.getElement() instanceof EOperation)) continue;
                EOperation eOperation = (EOperation)next.getElement();
                for (EParameter eParameter : eOperation.getEParameters()) {
                    if (eParameter.getEType() == null || !"OclType".equals(eParameter.getEType().getName())) continue;
                    result = true;
                    continue block1;
                }
            }
        }
        return result;
    }

    private void computeModulePatternProposals(List<ICompletionProposal> proposals) {
        int i = this.offset;
        while (i > 0 && Character.isJavaIdentifierPart(this.text.charAt(i - 1))) {
            --i;
        }
        if (i > 0 && this.text.charAt(i - 1) == '[') {
            --i;
        }
        String start = this.text.substring(i, this.offset);
        StringBuffer tabBuffer = new StringBuffer();
        while (i > 0 && Character.isWhitespace(this.text.charAt(i - 1)) && this.text.charAt(i - 1) != '\n') {
            tabBuffer.insert(0, this.text.charAt(i - 1));
            --i;
        }
        if (i == 0 || this.text.charAt(i - 1) == '\n') {
            String fileName = this.content.getFile() != null ? this.content.getFile().getName() : "";
            if ("module".startsWith(start.toLowerCase()) || "[module".startsWith(start.toLowerCase())) {
                String replacementStringBefore = "[module " + new Path(fileName).removeFileExtension().lastSegment() + "('";
                String replacementStringAfter = "${ecore}') /]\n" + tabBuffer.toString();
                String replacementString = String.valueOf(replacementStringBefore) + replacementStringAfter;
                proposals.add(this.createTemplateProposal(replacementString, this.offset - start.length(), start.length(), replacementStringBefore.length(), AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Pattern.gif"), "[module]", null, replacementString));
            }
        }
    }

    private void computePatternsProposals(List<ICompletionProposal> proposals) {
        int i = this.offset;
        while (i > 0 && (Character.isJavaIdentifierPart(this.text.charAt(i - 1)) || this.text.charAt(i - 1) == '@')) {
            --i;
        }
        if (i > 0 && (this.text.charAt(i - 1) == '[' || this.text.charAt(i - 1) == ']')) {
            --i;
        }
        String start = this.text.substring(i, this.offset);
        StringBuffer tabBuffer = new StringBuffer();
        while (i > 0 && Character.isWhitespace(this.text.charAt(i - 1)) && this.text.charAt(i - 1) != '\n') {
            tabBuffer.insert(0, this.text.charAt(i - 1));
            --i;
        }
        String tab = tabBuffer.toString();
        Image patternImage = AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Pattern.gif");
        if (i > 0 && this.text.charAt(i - 1) == '\n') {
            String replacementString;
            String replacementString2;
            String replacementStringAfter;
            String replacementStringBefore;
            if (this.content.getCSTParent(this.cstNode, org.eclipse.acceleo.parser.cst.ModuleElement.class) == null && this.text.substring(0, i).indexOf("[template") == -1 && this.text.substring(0, i).indexOf("[query") == -1 && this.text.substring(0, i).indexOf("[macro") == -1 && ("import".startsWith(start.toLowerCase()) || "[import".startsWith(start.toLowerCase()))) {
                replacementStringBefore = "[import ";
                replacementStringAfter = "${common} /]" + tab;
                replacementString2 = String.valueOf(replacementStringBefore) + replacementStringAfter;
                proposals.add(this.createTemplateProposal(replacementString2, this.offset - start.length(), start.length(), replacementStringBefore.length(), patternImage, "[import]", null, replacementString2));
            }
            if (!(this.cstNode instanceof org.eclipse.acceleo.parser.cst.ModuleElement) && this.content.getCSTParent(this.cstNode, org.eclipse.acceleo.parser.cst.ModuleElement.class) == null) {
                this.computeModuleElementsPatternsProposals(proposals, start, tab, patternImage);
            }
            if (this.cstNode instanceof IfBlock || this.cstNode instanceof TextExpression && this.cstNode.eContainer() instanceof IfBlock) {
                if ("elseif".startsWith(start.toLowerCase()) || "[elseif".startsWith(start.toLowerCase())) {
                    replacementStringBefore = "[elseif (";
                    replacementStringAfter = "${expression})]\n" + tab + '\t';
                    replacementString2 = String.valueOf(replacementStringBefore) + replacementStringAfter;
                    proposals.add(this.createTemplateProposal(replacementString2, this.offset - start.length(), start.length(), replacementStringBefore.length(), patternImage, "[elseif]", null, replacementString2));
                }
                if ("else".startsWith(start.toLowerCase()) || "[else".startsWith(start.toLowerCase())) {
                    replacementString = "[else]\n" + tab + '\t';
                    proposals.add(this.createCompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementString.length(), patternImage, "[else]", null, replacementString));
                }
            }
            if (this.cstNode instanceof LetBlock || this.cstNode instanceof TextExpression && this.cstNode.eContainer() instanceof LetBlock) {
                if ("elselet".startsWith(start.toLowerCase()) || "[elselet".startsWith(start.toLowerCase())) {
                    replacementStringBefore = "[elselet ";
                    replacementStringAfter = "${var} : ${" + this.defaultVariableType + "} = ${self}]" + '\n' + tab + '\t';
                    replacementString2 = String.valueOf(replacementStringBefore) + replacementStringAfter;
                    proposals.add(this.createTemplateProposal(replacementString2, this.offset - start.length(), start.length(), replacementStringBefore.length(), patternImage, "[elselet]", null, replacementString2));
                }
                if ("else".startsWith(start.toLowerCase()) || "[else".startsWith(start.toLowerCase())) {
                    replacementString = "[else]\n" + tab + '\t';
                    proposals.add(this.createCompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementString.length(), patternImage, "[else]", null, replacementString));
                }
            }
            if (!start.startsWith("@")) {
                this.computeBlocksPatternsProposals(proposals, start, tab, patternImage);
            }
            if (!(this.cstNode instanceof ModelExpression) && ("comment".startsWith(start.toLowerCase()) || "[comment".startsWith(start.toLowerCase()))) {
                replacementStringBefore = "[comment ";
                replacementStringAfter = " /]\n" + tab;
                replacementString2 = String.valueOf(replacementStringBefore) + replacementStringAfter;
                proposals.add(this.createCompletionProposal(replacementString2, this.offset - start.length(), start.length(), replacementStringBefore.length(), patternImage, "[comment]", null, replacementString2));
            }
        } else if (!start.startsWith("@")) {
            this.computeBlocksPatternsProposals(proposals, start, tab, patternImage);
        }
        this.computeMainTagPatternsProposals(proposals, start, tab, patternImage);
    }

    private void computeMainTagPatternsProposals(List<ICompletionProposal> proposals, String start, String tab, Image patternImage) {
        if (this.cstNode instanceof TextExpression && ("@main".startsWith(start.toLowerCase()) || "[@main".startsWith(start.toLowerCase()))) {
            String replacementStringBefore;
            String replacementString = replacementStringBefore = "[comment @main /]\n" + tab;
            proposals.add(this.createCompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementStringBefore.length(), patternImage, "@main", null, replacementString));
        }
    }

    private void computeModuleElementsPatternsProposals(List<ICompletionProposal> proposals, String start, String tab, Image patternImage) {
        String replacementString;
        String replacementStringAfter;
        String replacementStringBefore;
        if ("template".startsWith(start.toLowerCase()) || "[template".startsWith(start.toLowerCase())) {
            replacementStringBefore = "[template ${public} ";
            replacementStringAfter = "${name}(${arg} : ${" + this.defaultVariableType + "})]\n" + tab + '\t' + "${template_expression}" + '\n' + tab + '[' + '/' + "template" + ']';
            replacementString = String.valueOf(replacementStringBefore) + replacementStringAfter;
            proposals.add(this.createTemplateProposal(replacementString, this.offset - start.length(), start.length(), replacementStringBefore.length(), patternImage, "[template]", null, String.valueOf(tab) + replacementString));
        }
        if ("query".startsWith(start.toLowerCase()) || "[query".startsWith(start.toLowerCase())) {
            replacementStringBefore = "[query ${public} ";
            replacementStringAfter = "${name}(${arg} : ${" + this.defaultVariableType + "}) : ${OclAny} = ${self} /]\n";
            replacementString = String.valueOf(replacementStringBefore) + replacementStringAfter;
            proposals.add(this.createTemplateProposal(replacementString, this.offset - start.length(), start.length(), replacementStringBefore.length(), patternImage, "[query]", null, String.valueOf(tab) + replacementString));
        }
        if ("macro".startsWith(start.toLowerCase()) || "[macro".startsWith(start.toLowerCase())) {
            replacementStringBefore = "[macro public ";
            replacementStringAfter = "${name}(${arg} : ${" + this.defaultVariableType + "}) : ${String}" + "]\n" + tab + '\t' + '\n' + tab + '[' + '/' + "macro" + ']';
            replacementString = String.valueOf(replacementStringBefore) + replacementStringAfter;
            proposals.add(this.createTemplateProposal(replacementString, this.offset - start.length(), start.length(), replacementStringBefore.length(), patternImage, "[macro]", null, String.valueOf(tab) + replacementString));
        }
    }

    private void computeBlocksPatternsProposals(List<ICompletionProposal> proposals, String start, String tab, Image patternImage) {
        if (this.cstNode instanceof Template) {
            if (((Template)this.cstNode).getBody().size() == 0 || this.offset >= ((TemplateExpression)((Template)this.cstNode).getBody().get(0)).getStartPosition()) {
                this.computeBlocksPatternsProposalsSub(proposals, start, tab, patternImage);
            }
        } else if (this.cstNode instanceof Block) {
            this.computeBlocksPatternsProposalsSub(proposals, start, tab, patternImage);
        }
        if (this.content.getCSTParent(this.cstNode, org.eclipse.acceleo.parser.cst.ModuleElement.class) != null) {
            if (this.cstNode instanceof TextExpression) {
                int size = proposals.size();
                this.computeBlocksPatternsProposalsSub(proposals, start, tab, patternImage);
                if (proposals.size() == size) {
                    this.computeBlocksPatternsProposalsSub(proposals, "", tab, patternImage);
                }
            } else if (this.cstNode instanceof ModelExpression && start.startsWith("[") && (this.offset == this.text.length() || this.text.charAt(this.offset) != '/')) {
                this.computeBlocksPatternsProposalsSub(proposals, start, tab, patternImage);
            }
        }
    }

    private void computeBlocksPatternsProposalsSub(List<ICompletionProposal> proposals, String start, String tab, Image patternImage) {
        String replacementString;
        String replacementString2;
        String replacementStringAfter;
        String replacementStringBefore;
        String virtualText;
        String replacementString3;
        String replacementStringAfter2;
        String replacementStringBefore2;
        if ("[".startsWith(start.toLowerCase())) {
            replacementStringBefore2 = "[${expression}";
            replacementStringAfter2 = "/]";
            replacementString3 = String.valueOf(replacementStringBefore2) + replacementStringAfter2;
            proposals.add(this.createTemplateProposal(replacementString3, this.offset - start.length(), start.length(), replacementStringBefore2.length(), patternImage, "[ ]", null, replacementString3));
        }
        if ("for".startsWith(start.toLowerCase()) || "[for".startsWith(start.toLowerCase())) {
            virtualText = this.getVirtualTextInBlock();
            replacementStringBefore = "[for (";
            replacementStringAfter = virtualText.length() > 0 ? "${it} : ${" + this.defaultVariableType + "} | ${expression})]\n" + tab + virtualText + tab + '[' + '/' + "for" + ']' + '\n' : "${it} : ${" + this.defaultVariableType + "} | ${expression})]\n" + tab + '\t' + "${block_expression}" + '\n' + tab + '[' + '/' + "for" + ']';
            replacementString2 = String.valueOf(replacementStringBefore) + replacementStringAfter;
            proposals.add(this.createTemplateProposal(replacementString2, this.offset - start.length(), start.length() + virtualText.length(), replacementStringBefore.length(), patternImage, "[for]", null, String.valueOf(tab) + replacementString2));
        }
        if ("if".startsWith(start.toLowerCase()) || "[if".startsWith(start.toLowerCase())) {
            virtualText = this.getVirtualTextInBlock();
            replacementStringBefore = "[if (";
            replacementStringAfter = virtualText.length() > 0 ? "${condition})]\n" + tab + virtualText + tab + '[' + '/' + "if" + ']' + '\n' : "${condition})]\n" + tab + '\t' + "${block_expression}" + '\n' + tab + '[' + '/' + "if" + ']';
            replacementString2 = String.valueOf(replacementStringBefore) + replacementStringAfter;
            proposals.add(this.createTemplateProposal(replacementString2, this.offset - start.length(), start.length() + virtualText.length(), replacementStringBefore.length(), patternImage, "[if]", null, String.valueOf(tab) + replacementString2));
        }
        if ("file".startsWith(start.toLowerCase()) || "[file".startsWith(start.toLowerCase())) {
            this.computeFileBlockPatternsProposals(proposals, start, tab, patternImage, true);
            this.computeFileBlockPatternsProposals(proposals, start, tab, patternImage, false);
        }
        if ("let".startsWith(start.toLowerCase()) || "[let".startsWith(start.toLowerCase())) {
            replacementStringBefore2 = "[let ";
            replacementStringAfter2 = "${var} : ${" + this.defaultVariableType + "} = ${self}]\n" + tab + '\t' + "${block_expression}" + '\n' + tab + '[' + '/' + "let" + ']';
            replacementString3 = String.valueOf(replacementStringBefore2) + replacementStringAfter2;
            proposals.add(this.createTemplateProposal(replacementString3, this.offset - start.length(), start.length(), replacementStringBefore2.length(), patternImage, "[let]", null, String.valueOf(tab) + replacementString3));
        }
        if ("trace".startsWith(start.toLowerCase()) || "[trace".startsWith(start.toLowerCase())) {
            replacementStringBefore2 = "[trace ('";
            replacementStringAfter2 = "${message}')]\n" + tab + '\t' + "${block_expression}" + '\n' + tab + '[' + '/' + "trace" + ']';
            replacementString3 = String.valueOf(replacementStringBefore2) + replacementStringAfter2;
            proposals.add(this.createTemplateProposal(replacementString3, this.offset - start.length(), start.length(), replacementStringBefore2.length(), patternImage, "[trace]", null, String.valueOf(tab) + replacementString3));
        }
        if ("protected".startsWith(start.toLowerCase()) || "[protected".startsWith(start.toLowerCase())) {
            replacementStringBefore2 = "[protected ('";
            replacementStringAfter2 = "${protected}')]\n" + tab + '\t' + "${block_expression}" + '\n' + tab + '[' + '/' + "protected" + ']';
            replacementString3 = String.valueOf(replacementStringBefore2) + replacementStringAfter2;
            proposals.add(this.createTemplateProposal(replacementString3, this.offset - start.length(), start.length(), replacementStringBefore2.length(), patternImage, "[protected]", null, String.valueOf(tab) + replacementString3));
        }
        if ("super".startsWith(start.toLowerCase()) || "[super".startsWith(start.toLowerCase())) {
            String replacementString4 = replacementStringBefore2 = "[super/]\n" + tab;
            proposals.add(this.createCompletionProposal(replacementString4, this.offset - start.length(), start.length(), replacementStringBefore2.length(), patternImage, "[super]", null, replacementString4));
        }
        if ("[".startsWith(start.toLowerCase())) {
            replacementString = "[ '[' /] ";
            proposals.add(this.createCompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementString.length(), patternImage, "'['", null, replacementString));
        }
        if ("".equals(start.toLowerCase())) {
            replacementString = "[ ']' /] ";
            proposals.add(this.createCompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementString.length(), patternImage, "']'", null, replacementString));
        }
    }

    private String getVirtualTextInBlock() {
        boolean lineContainsTextAfter = false;
        int i = this.offset;
        while (i < this.text.length()) {
            char c = this.text.charAt(i);
            if (!Character.isWhitespace(c)) {
                lineContainsTextAfter = true;
                break;
            }
            if (c == '\n') break;
            ++i;
        }
        if (lineContainsTextAfter) {
            i = this.offset;
            int iEmptyLineAndNoMTL = -1;
            int iBeginLine = i;
            boolean currentLineIsEmpty = false;
            while (i < this.text.length()) {
                char c = this.text.charAt(i);
                if (!Character.isWhitespace(c)) {
                    if (currentLineIsEmpty && c == '[') {
                        iEmptyLineAndNoMTL = iBeginLine;
                        break;
                    }
                    currentLineIsEmpty = false;
                } else if (c == '\n') {
                    if (currentLineIsEmpty) {
                        iEmptyLineAndNoMTL = i + 1;
                        break;
                    }
                    currentLineIsEmpty = true;
                    iBeginLine = i + 1;
                }
                ++i;
            }
            if (iEmptyLineAndNoMTL > -1) {
                return this.text.substring(this.offset, iEmptyLineAndNoMTL).replace("$", "$$");
            }
        }
        return "";
    }

    private void computeFileBlockPatternsProposals(List<ICompletionProposal> proposals, String start, String tab, Image patternImage, boolean withMainTag) {
        String defaultEncoding;
        String mainTagText = withMainTag ? "[comment @main /]\n" + tab : "";
        String replacementStringBefore = String.valueOf(mainTagText) + '[' + "file" + ' ' + "(${path}";
        try {
            defaultEncoding = this.content != null && this.content.getFile() != null ? this.content.getFile().getCharset() : System.getProperty("file.encoding");
        }
        catch (CoreException e) {
            AcceleoUIActivator.log((Exception)((Object)e), true);
            defaultEncoding = System.getProperty("file.encoding");
        }
        String replacementStringAfter = ", ${false}, '" + defaultEncoding + "')]\n" + tab + '\t' + "${file_expression}" + '\n' + tab + '[' + '/' + "file" + ']';
        String replacementString = String.valueOf(replacementStringBefore) + replacementStringAfter;
        String displayString = "[file]";
        if (withMainTag) {
            displayString = String.valueOf(displayString) + " - @main";
        }
        proposals.add(this.createTemplateProposal(replacementString, this.offset - start.length(), start.length(), replacementStringBefore.length(), patternImage, displayString, null, String.valueOf(tab) + replacementString));
    }

    private void computeKeywordsProposals(List<ICompletionProposal> proposals) {
        if (this.cstNode != null) {
            int i = this.offset;
            while (i > 0 && Character.isJavaIdentifierPart(this.text.charAt(i - 1))) {
                --i;
            }
            String start = this.text.substring(i, this.offset);
            int bHeader = this.cstNode.getStartPosition();
            String bHeaderText = bHeader > -1 && bHeader < i ? this.text.substring(bHeader, i).trim() : "";
            Image keywordImage = AcceleoUIActivator.getDefault().getImage("icons/template-editor/completion/Keyword.gif");
            if (this.cstNode instanceof org.eclipse.acceleo.parser.cst.Module && this.isHeaderAfterParenthesis(bHeaderText) && ((org.eclipse.acceleo.parser.cst.Module)this.cstNode).getExtends().size() == 0) {
                this.computeKeywordProposal(proposals, start, "extends ", "", keywordImage);
            }
            if (this.cstNode instanceof ModelExpression && this.cstNode.eContainingFeature() == CstPackage.eINSTANCE.getBlock_Body()) {
                this.computeKeywordsProposalsInTemplateInvocationHeader(proposals, start, bHeaderText, keywordImage);
            }
            if (this.cstNode instanceof Template) {
                this.computeKeywordsProposalsInTemplateHeader(proposals, start, bHeaderText, keywordImage);
            }
            if (this.cstNode instanceof org.eclipse.acceleo.parser.cst.Macro) {
                this.computeKeywordsProposalsInMacroHeader(proposals, start, bHeaderText, keywordImage);
            }
            if (this.cstNode instanceof ForBlock) {
                this.computeKeywordsProposalsInForBlockHeader(proposals, start, bHeaderText, keywordImage);
            }
        }
    }

    private void computeKeywordsProposalsInTemplateHeader(List<ICompletionProposal> proposals, String start, String bHeaderText, Image keywordImage) {
        if (bHeaderText.equals("template")) {
            this.computeKeywordProposal(proposals, start, "public ", "", keywordImage);
            this.computeKeywordProposal(proposals, start, "protected ", "", keywordImage);
            this.computeKeywordProposal(proposals, start, "private ", "", keywordImage);
        }
        if (this.isHeaderAfterParenthesis(bHeaderText)) {
            boolean isAfterPost;
            boolean isAfterGuard;
            boolean isAfterOverrides;
            StringBuffer bHeaderBuffer = new StringBuffer(bHeaderText);
            Sequence pGuard = new Sequence("?", "(");
            Sequence pPost = new Sequence("post", "(");
            Sequence pInit = new Sequence("{");
            Template cstTemplate = (Template)this.cstNode;
            if (cstTemplate.getOverrides().size() == 0 && pGuard.search(bHeaderBuffer).b() == -1 && pPost.search(bHeaderBuffer).b() == -1 && pInit.search(bHeaderBuffer).b() == -1) {
                this.computeKeywordProposal(proposals, start, "overrides ", "", keywordImage);
            }
            boolean bl = isAfterOverrides = cstTemplate.getOverrides().size() == 0 || ((TemplateOverridesValue)cstTemplate.getOverrides().get(cstTemplate.getOverrides().size() - 1)).getEndPosition() < this.offset;
            if (cstTemplate.getGuard() == null && pPost.search(bHeaderBuffer).b() == -1 && pInit.search(bHeaderBuffer).b() == -1 && isAfterOverrides) {
                this.computeKeywordProposal(proposals, start, "? (", ")", keywordImage);
            }
            boolean bl2 = isAfterGuard = cstTemplate.getGuard() == null || cstTemplate.getGuard().getEndPosition() < this.offset;
            if (cstTemplate.getPost() == null && pInit.search(bHeaderBuffer).b() == -1 && isAfterOverrides && isAfterGuard) {
                this.computeKeywordProposal(proposals, start, "post (", ")", keywordImage);
            }
            boolean bl3 = isAfterPost = cstTemplate.getPost() == null || cstTemplate.getPost().getEndPosition() < this.offset;
            if (cstTemplate.getInit() == null && "{".startsWith(start.toLowerCase()) && isAfterOverrides && isAfterGuard && isAfterPost) {
                String replacementStringBefore = "{ ";
                String replacementStringAfter = "${var} : ${" + this.defaultVariableType + "}; }";
                String replacementString = String.valueOf(replacementStringBefore) + replacementStringAfter;
                proposals.add(this.createTemplateProposal(replacementString, this.offset - start.length(), start.length(), replacementStringBefore.length(), keywordImage, "{ }", null, replacementString));
            }
        }
    }

    private void computeKeywordsProposalsInMacroHeader(List<ICompletionProposal> proposals, String start, String bHeaderText, Image keywordImage) {
        if (bHeaderText.equals("macro")) {
            this.computeKeywordProposal(proposals, start, "public ", "", keywordImage);
            this.computeKeywordProposal(proposals, start, "protected ", "", keywordImage);
            this.computeKeywordProposal(proposals, start, "private ", "", keywordImage);
        }
    }

    private void computeKeywordsProposalsInTemplateInvocationHeader(List<ICompletionProposal> proposals, String start, String bHeaderText, Image keywordImage) {
        if (this.isHeaderAfterParenthesis(bHeaderText) || bHeaderText.indexOf("super") > -1) {
            StringBuffer bHeaderBuffer = new StringBuffer(bHeaderText);
            Sequence pSeparator = new Sequence("separator", "(");
            Sequence pAfter = new Sequence("after", "(");
            Sequence pGuard = new Sequence("?", "(");
            if (((ModelExpression)this.cstNode).getBefore() == null && pSeparator.search(bHeaderBuffer).b() == -1 && pAfter.search(bHeaderBuffer).b() == -1 && pGuard.search(bHeaderBuffer).b() == -1) {
                this.computeKeywordProposal(proposals, start, "before (", ")", keywordImage);
            }
            if (((ModelExpression)this.cstNode).getEach() == null && pAfter.search(bHeaderBuffer).b() == -1 && pGuard.search(bHeaderBuffer).b() == -1) {
                this.computeKeywordProposal(proposals, start, "separator (", ")", keywordImage);
            }
            if (((ModelExpression)this.cstNode).getAfter() == null && pGuard.search(bHeaderBuffer).b() == -1) {
                this.computeKeywordProposal(proposals, start, "after (", ")", keywordImage);
            }
        }
    }

    private void computeKeywordsProposalsInForBlockHeader(List<ICompletionProposal> proposals, String start, String bHeaderText, Image keywordImage) {
        if (this.isHeaderAfterParenthesis(bHeaderText)) {
            StringBuffer bHeaderBuffer = new StringBuffer(bHeaderText);
            Sequence pSeparator = new Sequence("separator", "(");
            Sequence pAfter = new Sequence("after", "(");
            Sequence pGuard = new Sequence("?", "(");
            Sequence pInit = new Sequence("{");
            if (((ForBlock)this.cstNode).getBefore() == null && pSeparator.search(bHeaderBuffer).b() == -1 && pAfter.search(bHeaderBuffer).b() == -1 && pGuard.search(bHeaderBuffer).b() == -1 && pInit.search(bHeaderBuffer).b() == -1) {
                this.computeKeywordProposal(proposals, start, "before (", ")", keywordImage);
            }
            if (((ForBlock)this.cstNode).getEach() == null && pAfter.search(bHeaderBuffer).b() == -1 && pGuard.search(bHeaderBuffer).b() == -1 && pInit.search(bHeaderBuffer).b() == -1) {
                this.computeKeywordProposal(proposals, start, "separator (", ")", keywordImage);
            }
            if (((ForBlock)this.cstNode).getAfter() == null && pGuard.search(bHeaderBuffer).b() == -1 && pInit.search(bHeaderBuffer).b() == -1) {
                this.computeKeywordProposal(proposals, start, "after (", ")", keywordImage);
            }
            if (((ForBlock)this.cstNode).getGuard() == null && pInit.search(bHeaderBuffer).b() == -1) {
                this.computeKeywordProposal(proposals, start, "? (", ")", keywordImage);
            }
            if (((ForBlock)this.cstNode).getInit() == null && "{".startsWith(start)) {
                String replacementStringBefore = "{ ";
                String replacementStringAfter = "${var} : ${" + this.defaultVariableType + "}; }";
                String replacementString = String.valueOf(replacementStringBefore) + replacementStringAfter;
                proposals.add(this.createTemplateProposal(replacementString, this.offset - start.length(), start.length(), replacementStringBefore.length(), keywordImage, "{ }", null, replacementString));
            }
        }
    }

    private boolean isHeaderAfterParenthesis(String aText) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(aText);
        buffer.append(" ---TAG--- ");
        Sequence literalEscape = new Sequence("\\'");
        SequenceBlock pLiteral = new SequenceBlock(new Sequence("'"), new Sequence("'"), literalEscape, false, null);
        SequenceBlock pParenthesis = new SequenceBlock(new Sequence("("), new Sequence(")"), null, true, new SequenceBlock[]{pLiteral});
        Sequence pHeaderEnd = new Sequence("]");
        Sequence pTag = new Sequence(" ---TAG--- ");
        return pHeaderEnd.search(buffer, 0, buffer.length(), null, new SequenceBlock[]{pLiteral}).b() == -1 && pParenthesis.search(buffer, 0, buffer.length()).b() > -1 && pTag.search(buffer, 0, buffer.length(), null, new SequenceBlock[]{pLiteral, pParenthesis}).b() > -1;
    }

    private void computeKeywordProposal(List<ICompletionProposal> proposals, String start, String replacementStringBefore, String replacementStringAfter, Image keywordImage) {
        String replacementString = String.valueOf(replacementStringBefore) + replacementStringAfter;
        if (replacementString.toLowerCase().startsWith(start.toLowerCase())) {
            proposals.add(this.createCompletionProposal(replacementString, this.offset - start.length(), start.length(), replacementStringBefore.length(), keywordImage, replacementString, null, replacementString));
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        if (this.disableAutoActivation) {
            return new char[0];
        }
        return AUTO_ACTIVATION_CHARACTERS;
    }

    public void disableAutoActivation() {
        this.disableAutoActivation = true;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    protected ICompletionProposal createTemplateProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        String info = additionalProposalInfo;
        if (this.textViewer != null && this.textViewer.getDocument() != null) {
            org.eclipse.jface.text.templates.Template template = new org.eclipse.jface.text.templates.Template(displayString, displayString, "__ACCELEO_block", replacementString, true);
            TemplateContextType type = new TemplateContextType("__ACCELEO_block", "__ACCELEO_block");
            DocumentTemplateContext context = new DocumentTemplateContext(type, this.textViewer.getDocument(), replacementOffset, replacementLength);
            Region region = new Region(replacementOffset, replacementLength);
            return new AcceleoCompletionTemplateProposal(template, (TemplateContext)context, (IRegion)region, image, info);
        }
        return this.createCompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, info);
    }

    protected ICompletionProposal createCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        return new AcceleoCompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo);
    }

    protected void setCompletionOffset(int newOffset) {
        this.offset = newOffset;
    }

    protected void setText(ITextViewer viewer) {
        this.text = viewer != null ? viewer.getDocument().get() : this.content.getText();
    }

    private static boolean startsWithOrMatchCamelCase(String candidate, String query) {
        boolean result = false;
        if (AcceleoCompletionProcessor.startsWithIgnoreCase(candidate, query)) {
            result = true;
        } else if (candidate != null) {
            String regex = String.valueOf(CAMEL_CASE_PATTERN.matcher(query).replaceAll("$1[^A-Z]*")) + ".*";
            result = candidate.matches(regex);
        }
        return result;
    }

    private static boolean startsWithIgnoreCase(String candidate, String prefix) {
        return candidate != null && candidate.regionMatches(true, 0, prefix, 0, prefix.length());
    }
}

