/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Vector;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.BinaryImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Coord;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Neighbor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Topology {
    static final short TYPE_INTERIOR = 0;
    static final short TYPE_EDGE = 1;
    static final short TYPE_CONNECTED = 2;
    static final short TYPE_BRANCHING = 3;
    static final short TYPE_CROSSING = 4;
    ConnectedComponent component;
    int width;
    int height;
    int numNodes = 0;
    Node[] nodes = null;
    int numInterior = 0;
    int numEdges = 0;
    int numBranches = 0;
    int numCrosses = 0;
    int[][] distance = null;
    int count = 0;

    public Topology(ConnectedComponent connectedComponent) throws ImageException {
        this(connectedComponent, false);
    }

    public Topology(ConnectedComponent connectedComponent, boolean bl) throws ImageException {
        int n;
        Neighbor neighbor;
        int n2;
        this.component = connectedComponent;
        this.width = this.component.shape.width;
        this.height = this.component.shape.height;
        BinaryImage binaryImage = this.component.shape;
        Vector<Node> vector = new Vector<Node>();
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        while (n5 < this.height) {
            n2 = 0;
            while (n2 < this.width) {
                if (binaryImage.data[n5][n2] != 0) {
                    Node node;
                    ++this.count;
                    if (n3 == -1) {
                        n3 = n5;
                    }
                    n4 = n5;
                    Neighbor neighbor2 = new Neighbor(binaryImage, n2, n5);
                    int n6 = neighbor2.crossingNumber();
                    if (n6 == 1) {
                        ++this.numNodes;
                        ++this.numEdges;
                        node = new Node(n2, n5, 1);
                        vector.addElement(node);
                    } else if (n6 == 3) {
                        ++this.numNodes;
                        ++this.numBranches;
                        node = new Node(n2, n5, 3);
                        vector.addElement(node);
                    } else if (n6 == 4) {
                        ++this.numNodes;
                        ++this.numCrosses;
                        node = new Node(n2, n5, 4);
                        vector.addElement(node);
                    } else if (n6 == 0) {
                        ++this.numNodes;
                        ++this.numInterior;
                        node = new Node(n2, n5, 0);
                        vector.addElement(node);
                    }
                }
                ++n2;
            }
            ++n5;
        }
        if (n3 == -1) {
            return;
        }
        n5 = 0;
        n2 = 0;
        int n7 = 0;
        while (n7 < this.numNodes) {
            Node node = (Node)vector.elementAt(n7);
            if (node.y == n3) {
                n5 = 1;
            }
            if (node.y == n4) {
                n2 = 1;
            }
            ++n7;
        }
        Node node = null;
        Node node2 = null;
        if (n5 == 0) {
            int n8 = 0;
            while (n8 < this.width) {
                if (binaryImage.data[n3][n8] != 0) {
                    neighbor = new Neighbor(binaryImage, n8, n3);
                    n = neighbor.crossingNumber();
                    if (n == 2) {
                        ++this.numNodes;
                        node = new Node(n8, n3, 2);
                        break;
                    }
                    throw new ImageException("Unknown type");
                }
                ++n8;
            }
        }
        if (n2 == 0) {
            int n9 = this.width - 1;
            while (n9 >= 0) {
                if (binaryImage.data[n4][n9] != 0) {
                    neighbor = new Neighbor(binaryImage, n9, n4);
                    n = neighbor.crossingNumber();
                    if (n == 2) {
                        ++this.numNodes;
                        node2 = new Node(n9, n4, 2);
                        break;
                    }
                    throw new ImageException("Unknown type");
                }
                --n9;
            }
        }
        this.nodes = new Node[this.numNodes];
        int n10 = 0;
        if (node != null) {
            this.nodes[0] = node;
            n10 = 1;
        }
        int n11 = 0;
        while (n11 < vector.size()) {
            this.nodes[n11 + n10] = (Node)vector.elementAt(n11);
            ++n11;
        }
        if (node2 != null) {
            this.nodes[this.numNodes - 1] = node2;
        }
        if (bl) {
            this.distance = new int[this.numNodes][this.numNodes];
            n11 = 0;
            while (n11 < this.numNodes - 1) {
                int[][] nArray = this.getDistanceMap(new Coord(this.nodes[n11].x, this.nodes[n11].y));
                int n12 = n11 + 1;
                while (n12 < this.numNodes) {
                    this.distance[n11][n12] = nArray[this.nodes[n12].y][this.nodes[n12].x];
                    this.distance[n12][n11] = this.distance[n11][n12];
                    ++n12;
                }
                ++n11;
            }
        }
    }

    public static boolean match(Topology topology, Topology topology2) {
        if (topology.numInterior != topology2.numInterior) {
            return false;
        }
        if (topology.numEdges != topology2.numEdges) {
            return false;
        }
        if (topology.numBranches != topology2.numBranches) {
            return false;
        }
        return topology.numCrosses == topology2.numCrosses;
    }

    public boolean match(Topology topology) {
        return Topology.match(this, topology);
    }

    private int[][] getDistanceMap(Coord coord) {
        int[][] nArray = new int[this.height][this.width];
        BinaryImage binaryImage = this.component.shape;
        Vector<Coord> vector = null;
        Vector<Coord> vector2 = new Vector<Coord>();
        vector2.addElement(coord);
        int n = 1;
        int n2 = vector2.size();
        while (n2 > 0) {
            vector = vector2;
            vector2 = new Vector();
            int n3 = 0;
            while (n3 < n2) {
                Coord coord2 = (Coord)vector.elementAt(n3);
                int n4 = coord2.x;
                int n5 = coord2.y;
                if (n4 > 0 && binaryImage.data[n5][n4 - 1] != 0) {
                    this.checkAndSetDistance(n4 - 1, n5, nArray, n, vector2);
                }
                if (n5 > 0 && binaryImage.data[n5 - 1][n4] != 0) {
                    this.checkAndSetDistance(n4, n5 - 1, nArray, n, vector2);
                }
                if (n4 < this.width - 1 && binaryImage.data[n5][n4 + 1] != 0) {
                    this.checkAndSetDistance(n4 + 1, n5, nArray, n, vector2);
                }
                if (n5 < this.height - 1 && binaryImage.data[n5 + 1][n4] != 0) {
                    this.checkAndSetDistance(n4, n5 + 1, nArray, n, vector2);
                }
                if (n4 > 0 && n5 > 0 && binaryImage.data[n5 - 1][n4 - 1] != 0) {
                    this.checkAndSetDistance(n4 - 1, n5 - 1, nArray, n, vector2);
                }
                if (n4 < this.width - 1 && n5 > 0 && binaryImage.data[n5 - 1][n4 + 1] != 0) {
                    this.checkAndSetDistance(n4 + 1, n5 - 1, nArray, n, vector2);
                }
                if (n4 > 0 && n5 < this.height - 1 && binaryImage.data[n5 + 1][n4 - 1] != 0) {
                    this.checkAndSetDistance(n4 - 1, n5 + 1, nArray, n, vector2);
                }
                if (n4 < this.width - 1 && n5 < this.height - 1 && binaryImage.data[n5 + 1][n4 + 1] != 0) {
                    this.checkAndSetDistance(n4 + 1, n5 + 1, nArray, n, vector2);
                }
                ++n3;
            }
            n2 = vector2.size();
            ++n;
        }
        return nArray;
    }

    private void checkAndSetDistance(int n, int n2, int[][] nArray, int n3, Vector<Coord> vector) {
        if (nArray[n2][n] == 0) {
            nArray[n2][n] = n3;
            vector.addElement(new Coord(n, n2));
        }
    }

    public int getNumNodes() {
        return this.numNodes;
    }

    public int getNumInterior() {
        return this.numInterior;
    }

    public int getNumEdges() {
        return this.numEdges;
    }

    public int getNumBranches() {
        return this.numBranches;
    }

    public int getNumCrosses() {
        return this.numCrosses;
    }

    public int getCount() {
        return this.count;
    }

    public void showNodes(PrintStream printStream) {
        PrintWriter printWriter = new PrintWriter(printStream, true);
        this.showNodes(printWriter);
    }

    public void showNodes(PrintWriter printWriter) {
        printWriter.println("-------------------------------");
        printWriter.println("Dumping nodes");
        char[][] cArray = new char[this.height][this.width];
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                cArray[n][n2] = this.component.shape.data[n][n2] != 0 ? 35 : 46;
                ++n2;
            }
            ++n;
        }
        n = 0;
        while (n < this.numNodes) {
            Node node = this.nodes[n];
            if (node.type == 1) {
                cArray[node.y][node.x] = 49;
            } else if (node.type == 2) {
                cArray[node.y][node.x] = 50;
            } else if (node.type == 3) {
                cArray[node.y][node.x] = 51;
            } else if (node.type == 4) {
                cArray[node.y][node.x] = 52;
            } else if (node.type == 0) {
                cArray[node.y][node.x] = 48;
            }
            ++n;
        }
        n = 0;
        while (n < this.height) {
            printWriter.println(new String(cArray[n]));
            ++n;
        }
        printWriter.println("-------------------------------");
    }

    public void showDistances(PrintStream printStream) {
        if (this.distance == null) {
            return;
        }
        PrintWriter printWriter = new PrintWriter(printStream, true);
        this.showDistances(printWriter);
    }

    public void showDistances(PrintWriter printWriter) {
        if (this.distance == null) {
            return;
        }
        printWriter.println("-------------------------------");
        printWriter.println("Showing distances");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    ");
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("----");
        int n = 0;
        while (n < this.numNodes) {
            stringBuffer.append("|" + this.numberFormat4(n));
            stringBuffer2.append("+----");
            ++n;
        }
        printWriter.println(stringBuffer.toString());
        printWriter.println(stringBuffer2.toString());
        n = 0;
        while (n < this.numNodes) {
            StringBuffer stringBuffer3 = new StringBuffer();
            stringBuffer3.append(String.valueOf(this.numberFormat4(n)) + "|");
            int n2 = 0;
            while (n2 < this.numNodes - 1) {
                stringBuffer3.append(String.valueOf(this.numberFormat4(this.distance[n][n2])) + "|");
                ++n2;
            }
            stringBuffer3.append(this.numberFormat4(this.distance[n][this.numNodes - 1]));
            printWriter.println(stringBuffer3.toString());
            ++n;
        }
        printWriter.println("-------------------------------");
    }

    private String numberFormat4(int n) {
        if (n >= 0 && n <= 9) {
            return "   " + n;
        }
        if (10 <= n && n <= 99) {
            return "  " + n;
        }
        if (100 <= n && n <= 999) {
            return " " + n;
        }
        return "" + n;
    }

    class Node {
        int x;
        int y;
        short type;

        public Node(int n, int n2, short s) {
            this.x = n;
            this.y = n2;
            this.type = s;
        }
    }
}

