/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.command;

import java.io.File;
import java.util.Map;
import org.eclipse.andmore.android.certmanager.command.AbstractHandler2;
import org.eclipse.andmore.android.certmanager.core.KeyStoreUtils;
import org.eclipse.andmore.android.certmanager.event.KeyStoreModelEvent;
import org.eclipse.andmore.android.certmanager.event.KeyStoreModelEventManager;
import org.eclipse.andmore.android.certmanager.exception.InvalidPasswordException;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.ui.dialogs.importks.ConvertKeyStoreTypeDialog;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStore;
import org.eclipse.andmore.android.certmanager.ui.model.ITreeNode;
import org.eclipse.andmore.android.common.exception.AndroidException;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.PlatformUI;

public class ChangeKeyStoreTypeHandler
extends AbstractHandler2 {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ConvertKeyStoreTypeDialog dialog;
        int diagStatus;
        ITreeNode node = this.getSelection().get(0);
        if (node instanceof IKeyStore && (diagStatus = (dialog = new ConvertKeyStoreTypeDialog(PlatformUI.getWorkbench().getModalDialogShellProvider().getShell(), (IKeyStore)((Object)node))).open()) == 0) {
            IKeyStore keyStore = dialog.getKeyStore();
            String newType = dialog.getNewType();
            Map<String, String> aliases = dialog.getAliases();
            String password = dialog.getKeystorePassword();
            File keyStoreFile = keyStore.getFile();
            try {
                if (password != null) {
                    KeyStoreUtils.changeKeyStoreType(keyStoreFile, password.toCharArray(), keyStore.getType(), newType, aliases);
                    keyStore.setType(newType);
                    keyStore.forceReload(password.toCharArray(), false);
                    KeyStoreModelEventManager.getInstance().fireEvent((ITreeNode)((Object)keyStore), KeyStoreModelEvent.EventType.UPDATE);
                }
            }
            catch (KeyStoreManagerException e) {
                EclipseUtils.showErrorDialog((AndroidException)e);
            }
            catch (InvalidPasswordException e) {
                EclipseUtils.showErrorDialog((AndroidException)e);
            }
        }
        return null;
    }
}

