/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.android.certmanager.command.AbstractHandler2;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.model.EntryNode;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStore;
import org.eclipse.andmore.android.certmanager.ui.model.ITreeNode;
import org.eclipse.andmore.android.common.exception.AndroidException;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DeleteKeyHandler
extends AbstractHandler2
implements IHandler {
    private boolean showQuestion(List<ITreeNode> nodesToDelete) {
        final Boolean[] reply = new Boolean[1];
        final String entryName = nodesToDelete.size() == 1 ? nodesToDelete.get(0).getName() : null;
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow ww = workbench.getActiveWorkbenchWindow();
                Shell shell = ww.getShell();
                reply[0] = MessageDialog.openQuestion((Shell)shell, (String)CertificateManagerNLS.DeleteKeyHandler_ConfirmationQuestionDialog_Title, (String)(entryName != null ? NLS.bind((String)CertificateManagerNLS.DeleteKeyHandler_ConfirmationQuestionDialog_Description, (Object)entryName) : CertificateManagerNLS.DeleteKeyHandler_Delete_Selected_Keys));
            }
        });
        return reply[0];
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        boolean shouldProceed;
        List<ITreeNode> nodesToDelete = this.getSelection();
        if (!nodesToDelete.isEmpty() && (shouldProceed = this.showQuestion(nodesToDelete))) {
            Map<IKeyStore, List<String>> deleteNodesMap = this.getKeysMap(nodesToDelete);
            for (IKeyStore keyStore : deleteNodesMap.keySet()) {
                try {
                    keyStore.removeKeys(deleteNodesMap.get(keyStore));
                }
                catch (KeyStoreManagerException e) {
                    EclipseUtils.showErrorDialog((AndroidException)e);
                    throw new ExecutionException(e.getMessage(), (Throwable)((Object)e));
                }
            }
        }
        nodesToDelete.clear();
        return null;
    }

    private Map<IKeyStore, List<String>> getKeysMap(List<ITreeNode> nodesToDelete) {
        HashMap<IKeyStore, List<String>> deleteNodesMap = new HashMap<IKeyStore, List<String>>();
        for (ITreeNode node2Delete : nodesToDelete) {
            if (!(node2Delete instanceof EntryNode)) continue;
            EntryNode entryNode = (EntryNode)node2Delete;
            IKeyStore iKeyStore = (IKeyStore)((Object)entryNode.getParent());
            ArrayList<String> keyList = (ArrayList<String>)deleteNodesMap.get(iKeyStore);
            if (keyList == null) {
                keyList = new ArrayList<String>();
            }
            keyList.add(entryNode.getAlias());
            deleteNodesMap.put(iKeyStore, keyList);
        }
        return deleteNodesMap;
    }
}

