/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.event;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.andmore.android.certmanager.event.IKeyStoreModelListener;
import org.eclipse.andmore.android.certmanager.event.KeyStoreModelEvent;
import org.eclipse.andmore.android.certmanager.ui.model.ITreeNode;

public class KeyStoreModelEventManager {
    private static KeyStoreModelEventManager _instance;
    private final List<IKeyStoreModelListener> listeners = new ArrayList<IKeyStoreModelListener>();

    private KeyStoreModelEventManager() {
    }

    public static synchronized KeyStoreModelEventManager getInstance() {
        if (_instance == null) {
            _instance = new KeyStoreModelEventManager();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IKeyStoreModelListener listener) {
        IKeyStoreModelListener iKeyStoreModelListener = listener;
        synchronized (iKeyStoreModelListener) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IKeyStoreModelListener listener) {
        IKeyStoreModelListener iKeyStoreModelListener = listener;
        synchronized (iKeyStoreModelListener) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(ITreeNode treeNodeItem, KeyStoreModelEvent.EventType eventType) {
        KeyStoreModelEvent keyStoreModelEvent = new KeyStoreModelEvent(treeNodeItem, eventType);
        List<IKeyStoreModelListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners != null) {
                for (IKeyStoreModelListener listener : this.listeners) {
                    switch (eventType) {
                        case ADD: {
                            listener.handleNodeAdditionEvent(keyStoreModelEvent);
                            break;
                        }
                        case REMOVE: {
                            listener.handleNodeRemovalEvent(keyStoreModelEvent);
                            break;
                        }
                        case UPDATE: {
                            listener.handleNodeUpdateEvent(keyStoreModelEvent);
                            break;
                        }
                        case COLLAPSE: {
                            listener.handleNodeCollapseEvent(keyStoreModelEvent);
                            break;
                        }
                        case REFRESH: {
                            listener.handleNodeRefreshEvent(keyStoreModelEvent);
                            break;
                        }
                        case CLEAR: {
                            listener.handleNodeClearEvent(keyStoreModelEvent);
                            break;
                        }
                    }
                }
            }
        }
    }
}

