/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.ui.wizards;

import java.io.File;
import java.util.List;
import org.eclipse.andmore.android.certmanager.core.KeyStoreManager;
import org.eclipse.andmore.android.certmanager.core.PasswordProvider;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStore;
import org.eclipse.andmore.android.certmanager.ui.model.KeyStoreNode;
import org.eclipse.andmore.android.certmanager.ui.model.SigningAndKeysModelManager;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.common.utilities.FileUtil;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ImportKeystorePage
extends WizardPage {
    private Text keystoreFilename;
    private ComboViewer keystoreType;
    public static final String IMPORT_KEYSTORE_HELP_ID = "org.eclipse.andmore.android.certmanager.import_keystore";
    private SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ImportKeystorePage.this.validatePage();
        }
    };
    private boolean userChangedFilename = false;
    private Composite mainComposite;
    private File keystoreFile;
    private String keystoreTypeString;
    protected boolean keystoreAlreadyMapped = false;
    private IKeyStore keyStoreNode;

    protected ImportKeystorePage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        this.mainComposite = new Composite(parent, 4);
        this.mainComposite.setLayout((Layout)new GridLayout(3, false));
        this.mainComposite.setLayoutData((Object)new GridData(1808));
        this.setTitle(CertificateManagerNLS.ImportKeystorePage_Title);
        this.setMessage(CertificateManagerNLS.ImportKeystorePage_Description);
        this.createFilenameSection(this.mainComposite);
        this.createKeystoreTypeSection(this.mainComposite);
        this.validatePage();
        this.setControl((Control)this.mainComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IMPORT_KEYSTORE_HELP_ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.mainComposite, IMPORT_KEYSTORE_HELP_ID);
    }

    private void createFilenameSection(Composite mainComposite) {
        Label keystoreFilenameLabel = new Label(mainComposite, 0);
        keystoreFilenameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        keystoreFilenameLabel.setText(CertificateManagerNLS.CreateKeystorePage_KeystoreFilenameLabel);
        this.keystoreFilename = new Text(mainComposite, 2052);
        this.keystoreFilename.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.keystoreFilename.addSelectionListener(this.selectionListener);
        this.keystoreFilename.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportKeystorePage.this.userChangedFilename = true;
                ImportKeystorePage.this.validatePage();
            }
        });
        Button chooseLocation = new Button(mainComposite, 8);
        chooseLocation.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        chooseLocation.setText(CertificateManagerNLS.CreateKeystorePage_KeystoreFilenameBrowse);
        chooseLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = Display.getCurrent().getActiveShell();
                FileDialog dialog = new FileDialog(shell, 4096);
                String keystoreFilenameStr = dialog.open();
                if (keystoreFilenameStr != null) {
                    ImportKeystorePage.this.keystoreFilename.setText(keystoreFilenameStr);
                    ImportKeystorePage.this.keystoreType.getCombo().setFocus();
                }
            }
        });
    }

    private void createKeystoreTypeSection(Composite parent) {
        Label keystoreTypeLabel = new Label(parent, 0);
        keystoreTypeLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        keystoreTypeLabel.setText(CertificateManagerNLS.CreateKeystorePage_KeystoreType);
        this.keystoreType = new ComboViewer(parent, 8);
        this.keystoreType.getCombo().setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        this.keystoreType.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }
        });
        this.keystoreType.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getText(Object element) {
                return (String)element;
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        this.keystoreType.setInput(KeyStoreManager.getInstance().getAvailableTypes());
        int i = 0;
        while (i < this.keystoreType.getCombo().getItemCount()) {
            if (this.keystoreType.getCombo().getItem(i).compareToIgnoreCase(KeyStoreManager.getInstance().getDefaultType()) == 0) {
                this.keystoreType.getCombo().select(i);
            }
            ++i;
        }
        this.keystoreType.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportKeystorePage.this.validatePage();
            }
        });
        Label separator2 = new Label(parent, 0);
        separator2.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
    }

    protected boolean validatePage() {
        String errorMessage = null;
        boolean pageComplete = true;
        this.keystoreAlreadyMapped = false;
        this.keystoreFile = new File(this.keystoreFilename.getText());
        this.keystoreTypeString = this.keystoreType.getCombo().getText();
        if (this.keystoreType.getCombo().getText().isEmpty()) {
            errorMessage = CertificateManagerNLS.ImportKeystorePage_KeystoreTypeCannotBeEmpty;
            pageComplete = false;
        }
        if (this.userChangedFilename && !this.keystoreFile.exists()) {
            errorMessage = NLS.bind((String)CertificateManagerNLS.ImportKeystorePage_FileDoesNotExist, (Object)this.keystoreFilename.getText());
            pageComplete = false;
        }
        if (this.keystoreFile.exists()) {
            if (this.keystoreFile.isFile()) {
                int fileSize = -1;
                try {
                    fileSize = FileUtil.getFileSize((File)this.keystoreFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (fileSize <= 0) {
                    errorMessage = NLS.bind((String)CertificateManagerNLS.ImportKeystorePage_FileEmpty, (Object)this.keystoreFilename.getText());
                    pageComplete = false;
                }
            } else if (this.keystoreFile.isDirectory()) {
                errorMessage = NLS.bind((String)CertificateManagerNLS.ImportKeystorePage_DirectoryNotAllowedErrorMsg, (Object)this.keystoreFilename.getText());
                pageComplete = false;
            }
        }
        if (this.keystoreFilename.getText().isEmpty()) {
            errorMessage = CertificateManagerNLS.ImportKeystorePage_FilenameCannotBeEmpty;
            pageComplete = false;
        }
        if (KeyStoreManager.getInstance().isKeystoreMapped(this.keystoreFile)) {
            errorMessage = NLS.bind((String)CertificateManagerNLS.ImportKeystorePage_KeystoreAlreadyMapped, (Object)this.keystoreFilename.getText());
            this.keystoreAlreadyMapped = true;
            pageComplete = false;
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(pageComplete);
        return pageComplete;
    }

    protected boolean importKeystore(String password, boolean savePassword) {
        boolean successfullyImported = true;
        this.validatePage();
        if (this.isPageComplete()) {
            KeyStoreNode keyStoreNode = new KeyStoreNode(this.keystoreFile, this.keystoreType.getCombo().getText());
            try {
                SigningAndKeysModelManager.getInstance().mapKeyStore(keyStoreNode);
                if (savePassword) {
                    PasswordProvider passwordProvider = new PasswordProvider(this.keystoreFile);
                    passwordProvider.saveKeyStorePassword(password);
                }
            }
            catch (KeyStoreManagerException e) {
                EclipseUtils.showErrorDialog((String)CertificateManagerNLS.ImportKeystorePage_CouldNotImportKeystore, (String)e.getMessage());
                successfullyImported = false;
            }
        } else {
            successfullyImported = false;
        }
        return successfullyImported;
    }

    public boolean importKeystore() {
        return this.importKeystore(null, false);
    }

    protected IKeyStore getSelectedKeystore() {
        if (this.keyStoreNode == null || !this.keyStoreNode.getFile().equals(this.keystoreFile) || this.keyStoreNode.getFile().equals(this.keystoreFile) && this.keyStoreNode.getType().equalsIgnoreCase(this.keystoreTypeString)) {
            this.keyStoreNode = new KeyStoreNode(this.keystoreFile, this.keystoreTypeString);
        }
        return this.keyStoreNode;
    }

    protected Composite getMainComposite() {
        return this.mainComposite;
    }
}

