/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.ui.wizards;

import org.eclipse.andmore.android.certmanager.exception.InvalidPasswordException;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStore;
import org.eclipse.andmore.android.certmanager.ui.model.KeyStoreNode;
import org.eclipse.andmore.android.certmanager.ui.wizards.SelectExistentKeystorePage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SelectExistentKeystoreWizard
extends Wizard {
    protected SelectExistentKeystorePage selectExistentKeystorePage = null;
    private static final String WIZARD_BANNER = "icons/wizban/import_keystore_wiz.png";
    public static final String SELECT_KEYSTORE_HELP_ID = "org.eclipse.andmore.android.certmanager.select_keystore";

    public SelectExistentKeystoreWizard() {
        this.setWindowTitle(CertificateManagerNLS.ImportKeystoreWizard_ImportKeystore);
        this.setDefaultPageImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.certmanager", (String)WIZARD_BANNER));
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), SELECT_KEYSTORE_HELP_ID);
    }

    public boolean performFinish() {
        IKeyStore iKeyStore = this.selectExistentKeystorePage.getSelectedKeystore();
        if (iKeyStore instanceof KeyStoreNode) {
            KeyStoreNode keyStoreNode = (KeyStoreNode)iKeyStore;
            try {
                keyStoreNode.isPasswordValid(this.selectExistentKeystorePage.getPassword());
            }
            catch (KeyStoreManagerException keyStoreManagerException) {
                this.selectExistentKeystorePage.setErrorMessage(CertificateManagerNLS.SelectExistentKeystoreWizard_Error_KeystoreType);
                return false;
            }
            catch (InvalidPasswordException invalidPasswordException) {
                this.selectExistentKeystorePage.setErrorMessage(CertificateManagerNLS.SelectExistentKeystoreWizard_Error_InvalidPassword);
                return false;
            }
        }
        if (this.selectExistentKeystorePage.needToImportIntoView()) {
            this.selectExistentKeystorePage.importKeystore();
        }
        return true;
    }

    public void addPages() {
        this.selectExistentKeystorePage = new SelectExistentKeystorePage(CertificateManagerNLS.SelectExistentKeystoreWizard_BrowseExistentKeystore_PageTitle);
        this.addPage((IWizardPage)this.selectExistentKeystorePage);
    }

    public IKeyStore getSelectedKeystore() {
        IKeyStore iKeyStore = this.selectExistentKeystorePage.getSelectedKeystore();
        return iKeyStore;
    }

    public boolean canSavePassword() {
        return this.selectExistentKeystorePage.canSavePassword();
    }

    public String getPassword() {
        return this.selectExistentKeystorePage.getPassword();
    }
}

