/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.model.manifest.dom;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.android.common.utilities.i18n.UtilitiesNLS;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public abstract class AndroidManifestNode {
    protected static final List<String> defaultProperties = new LinkedList<String>();
    private String[] ALL_PROPERTIES = null;
    protected final List<AndroidManifestNode> children = new LinkedList<AndroidManifestNode>();
    protected AndroidManifestNode parent = null;
    protected final Map<String, String> properties = new HashMap<String, String>();
    protected final List<AndroidManifestNode> unknownChildren = new LinkedList<AndroidManifestNode>();
    protected final Map<String, String> unknownProperties = new HashMap<String, String>();

    public static String getNodeName(NodeType nodeType) {
        String nodeName;
        switch (nodeType) {
            case Action: {
                nodeName = "action";
                break;
            }
            case Activity: {
                nodeName = "activity";
                break;
            }
            case ActivityAlias: {
                nodeName = "activity-alias";
                break;
            }
            case Application: {
                nodeName = "application";
                break;
            }
            case Category: {
                nodeName = "category";
                break;
            }
            case Data: {
                nodeName = "data";
                break;
            }
            case GrantUriPermission: {
                nodeName = "grant-uri-permission";
                break;
            }
            case Instrumentation: {
                nodeName = "instrumentation";
                break;
            }
            case IntentFilter: {
                nodeName = "intent-filter";
                break;
            }
            case Manifest: {
                nodeName = "manifest";
                break;
            }
            case MetaData: {
                nodeName = "meta-data";
                break;
            }
            case Permission: {
                nodeName = "permission";
                break;
            }
            case PermissionGroup: {
                nodeName = "permission-group";
                break;
            }
            case PermissionTree: {
                nodeName = "permission-tree";
                break;
            }
            case Provider: {
                nodeName = "provider";
                break;
            }
            case Receiver: {
                nodeName = "receiver";
                break;
            }
            case Service: {
                nodeName = "service";
                break;
            }
            case UsesLibrary: {
                nodeName = "uses-library";
                break;
            }
            case UsesPermission: {
                nodeName = "uses-permission";
                break;
            }
            case UsesSdk: {
                nodeName = "uses-sdk";
                break;
            }
            case Comment: {
                nodeName = "comment";
                break;
            }
            case UsesFeature: {
                nodeName = "uses-feature";
                break;
            }
            default: {
                nodeName = "unknown";
            }
        }
        return nodeName;
    }

    protected abstract boolean canContains(NodeType var1);

    protected abstract boolean isNodeValid();

    public abstract NodeType getNodeType();

    public abstract Map<String, String> getNodeProperties();

    protected abstract List<IStatus> getSpecificNodeProblems();

    protected AndroidManifestNode() {
    }

    public String getNodeName() {
        return AndroidManifestNode.getNodeName(this.getNodeType());
    }

    public void addChild(AndroidManifestNode child) {
        Assert.isLegal((child != null ? 1 : 0) != 0);
        if (this.canContains(child.getNodeType())) {
            this.children.add(child);
        } else {
            this.unknownChildren.add(child);
        }
        child.setParent(this);
    }

    public void setParent(AndroidManifestNode parent) {
        Assert.isLegal((parent != null ? 1 : 0) != 0);
        this.parent = parent;
    }

    public AndroidManifestNode getParent() {
        return this.parent;
    }

    public AndroidManifestNode[] getChildren() {
        AndroidManifestNode[] childrenArray = new AndroidManifestNode[this.children.size()];
        childrenArray = this.children.toArray(childrenArray);
        return childrenArray;
    }

    public AndroidManifestNode[] getUnkownChildren() {
        AndroidManifestNode[] unknownChildrenArray = new AndroidManifestNode[this.unknownChildren.size()];
        unknownChildrenArray = this.unknownChildren.toArray(unknownChildrenArray);
        return unknownChildrenArray;
    }

    public boolean addUnknownProperty(String property, String value) {
        boolean added = false;
        if (property != null && property.trim().length() > 0 && value != null && this.canAddUnknownProperty(property)) {
            this.unknownProperties.put(property, value);
        }
        return added;
    }

    protected boolean canAddUnknownProperty(String property) {
        boolean canAdd = true;
        if (this.ALL_PROPERTIES == null) {
            this.ALL_PROPERTIES = new String[defaultProperties.size()];
            this.ALL_PROPERTIES = defaultProperties.toArray(this.ALL_PROPERTIES);
        }
        String[] stringArray = this.ALL_PROPERTIES;
        int n = this.ALL_PROPERTIES.length;
        int n2 = 0;
        while (n2 < n) {
            String prop = stringArray[n2];
            if (prop.trim().equalsIgnoreCase(property)) {
                canAdd = false;
                break;
            }
            ++n2;
        }
        return canAdd;
    }

    public Map<String, String> getNodeUnknownProperties() {
        return this.unknownProperties;
    }

    protected AndroidManifestNode[] getAllChildrenFromType(NodeType type) {
        LinkedList<AndroidManifestNode> nodes = new LinkedList<AndroidManifestNode>();
        for (AndroidManifestNode node : this.children) {
            if (node.getNodeType() != type) continue;
            nodes.add(node);
        }
        AndroidManifestNode[] arrayNodes = new AndroidManifestNode[nodes.size()];
        arrayNodes = nodes.toArray(arrayNodes);
        return arrayNodes;
    }

    public IStatus[] getNodeErrors() {
        List<IStatus> specificErrors;
        LinkedList<IStatus> nodeErrors = new LinkedList<IStatus>();
        if (this.getNodeType() != NodeType.Unknown && this.getNodeType() != NodeType.Comment && (specificErrors = this.getSpecificNodeProblems()) != null && !specificErrors.isEmpty()) {
            nodeErrors.addAll(specificErrors);
        }
        return nodeErrors.toArray(new IStatus[0]);
    }

    public IStatus[] getNodeWarnings() {
        LinkedList<Status> nodeWarnings = new LinkedList<Status>();
        if (this.getNodeType() != NodeType.Unknown && this.getNodeType() != NodeType.Comment) {
            String thisNode = "<" + this.getNodeName() + ">";
            for (String attribute : this.getNodeUnknownProperties().keySet()) {
                String errMsg = NLS.bind((String)UtilitiesNLS.WARN_AndroidManifestNode_TheNodeContainsAnInvalidAttribute, (Object)thisNode, (Object)attribute);
                nodeWarnings.add(new Status(2, "org.eclipse.andmore.android.common", errMsg));
            }
        }
        return nodeWarnings.toArray(new IStatus[0]);
    }

    public IStatus[] getRecursiveNodeErrors() {
        int n;
        int n2;
        Object[] objectArray;
        LinkedList<IStatus> nodeErrors = new LinkedList<IStatus>();
        IStatus[] thisNodeErrors = this.getNodeErrors();
        if (thisNodeErrors != null) {
            objectArray = thisNodeErrors;
            n2 = thisNodeErrors.length;
            n = 0;
            while (n < n2) {
                IStatus status = objectArray[n];
                nodeErrors.add(status);
                ++n;
            }
        }
        objectArray = this.getChildren();
        n2 = objectArray.length;
        n = 0;
        while (n < n2) {
            IStatus node = objectArray[n];
            IStatus[] childrenErrors = node.getNodeErrors();
            if (childrenErrors != null) {
                IStatus[] iStatusArray = childrenErrors;
                int n3 = childrenErrors.length;
                int n4 = 0;
                while (n4 < n3) {
                    IStatus status = iStatusArray[n4];
                    nodeErrors.add(status);
                    ++n4;
                }
            }
            ++n;
        }
        return nodeErrors.toArray(new IStatus[0]);
    }

    protected boolean canAddOrUpdateProperty(String property) {
        boolean canAdd = false;
        if (this.ALL_PROPERTIES == null) {
            this.ALL_PROPERTIES = new String[defaultProperties.size()];
            this.ALL_PROPERTIES = defaultProperties.toArray(this.ALL_PROPERTIES);
        }
        String[] stringArray = this.ALL_PROPERTIES;
        int n = this.ALL_PROPERTIES.length;
        int n2 = 0;
        while (n2 < n) {
            String prop = stringArray[n2];
            if (prop.trim().equalsIgnoreCase(property)) {
                canAdd = true;
                break;
            }
            ++n2;
        }
        return canAdd;
    }

    public boolean addOrUpdateKnownProperty(String property, String value) {
        boolean added = false;
        if (property != null && property.trim().length() > 0 && value != null && this.canAddOrUpdateProperty(property)) {
            this.properties.put(property, value);
        }
        return added;
    }

    public static enum NodeType {
        Action,
        Activity,
        ActivityAlias,
        Application,
        Category,
        Data,
        GrantUriPermission,
        Instrumentation,
        IntentFilter,
        Manifest,
        MetaData,
        Permission,
        PermissionGroup,
        PermissionTree,
        Provider,
        Receiver,
        Service,
        UsesLibrary,
        UsesPermission,
        UsesSdk,
        Comment,
        Unknown,
        UsesFeature;

    }
}

