/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.model.manifest.dom;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.android.model.manifest.dom.AndroidManifestNode;
import org.eclipse.andmore.android.model.manifest.dom.ApplicationNode;
import org.eclipse.andmore.android.model.manifest.dom.IAndroidManifestProperties;
import org.eclipse.andmore.android.model.manifest.dom.InstrumentationNode;
import org.eclipse.andmore.android.model.manifest.dom.PermissionGroupNode;
import org.eclipse.andmore.android.model.manifest.dom.PermissionNode;
import org.eclipse.andmore.android.model.manifest.dom.PermissionTreeNode;
import org.eclipse.andmore.android.model.manifest.dom.UsesFeatureNode;
import org.eclipse.andmore.android.model.manifest.dom.UsesPermissionNode;
import org.eclipse.andmore.android.model.manifest.dom.UsesSDKNode;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;

public class ManifestNode
extends AndroidManifestNode
implements IAndroidManifestProperties {
    private static final String PROP_XMLNS_DEFAULTVALUE = "http://schemas.android.com/apk/res/android";
    private String propPackage = null;
    private String propSharedUserId = null;
    private Integer propVersionCode = null;
    private String propVersionName = null;

    static {
        defaultProperties.add("xmlns:android");
        defaultProperties.add("package");
        defaultProperties.add("android:sharedUserId");
        defaultProperties.add("android:versionCode");
        defaultProperties.add("android:versionName");
    }

    public ManifestNode(String packageName) {
        this.setPackage(packageName);
    }

    @Override
    protected boolean canContains(AndroidManifestNode.NodeType nodeType) {
        return nodeType == AndroidManifestNode.NodeType.Application || nodeType == AndroidManifestNode.NodeType.Instrumentation || nodeType == AndroidManifestNode.NodeType.Permission || nodeType == AndroidManifestNode.NodeType.PermissionGroup || nodeType == AndroidManifestNode.NodeType.PermissionTree || nodeType == AndroidManifestNode.NodeType.UsesPermission || nodeType == AndroidManifestNode.NodeType.UsesFeature || nodeType == AndroidManifestNode.NodeType.UsesSdk || nodeType == AndroidManifestNode.NodeType.Comment || nodeType == AndroidManifestNode.NodeType.MetaData || nodeType == AndroidManifestNode.NodeType.Unknown;
    }

    @Override
    public AndroidManifestNode.NodeType getNodeType() {
        return AndroidManifestNode.NodeType.Manifest;
    }

    @Override
    public Map<String, String> getNodeProperties() {
        this.properties.clear();
        this.properties.put("xmlns:android", PROP_XMLNS_DEFAULTVALUE);
        this.properties.put("package", this.propPackage);
        if (this.propSharedUserId != null) {
            this.properties.put("android:sharedUserId", this.propSharedUserId);
        }
        if (this.propVersionCode != null) {
            this.properties.put("android:versionCode", this.propVersionCode.toString());
        }
        if (this.propVersionName != null) {
            this.properties.put("android:versionName", this.propVersionName);
        }
        return this.properties;
    }

    @Override
    protected boolean isNodeValid() {
        int applicationCount = 0;
        boolean allAcceptable = true;
        for (AndroidManifestNode child : this.children) {
            if (child.getNodeType() == AndroidManifestNode.NodeType.Application) {
                ++applicationCount;
                continue;
            }
            if (this.canContains(child.getNodeType())) continue;
            allAcceptable = false;
            break;
        }
        return allAcceptable && applicationCount == 1 && this.isValidPackageName(this.propPackage);
    }

    private boolean isValidPackageName(String packageName) {
        boolean isValid = false;
        String[] parts = packageName.split("\\.");
        if (parts.length > 1) {
            isValid = true;
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                isValid &= part.length() > 0;
                ++n2;
            }
        }
        return isValid;
    }

    public void setPackage(String packageName) {
        Assert.isLegal((packageName != null ? 1 : 0) != 0);
        this.propPackage = packageName;
    }

    public String getPackageName() {
        return this.propPackage;
    }

    public void setSharedUserId(String sharedUserId) {
        this.propSharedUserId = sharedUserId;
    }

    public String getSharedUserId() {
        return this.propSharedUserId;
    }

    public void setVersionCode(Integer versionCode) {
        this.propVersionCode = versionCode;
    }

    public Integer getVersionCode() {
        return this.propVersionCode;
    }

    public void setVersionName(String versionName) {
        this.propVersionName = versionName;
    }

    public String getVersionName() {
        return this.propVersionName;
    }

    public ApplicationNode getApplicationNode() {
        ApplicationNode applicationNode = null;
        AndroidManifestNode[] androidManifestNodeArray = this.getAllChildrenFromType(AndroidManifestNode.NodeType.Application);
        if (androidManifestNodeArray.length != 0) {
            AndroidManifestNode appNode = androidManifestNodeArray[0];
            applicationNode = (ApplicationNode)appNode;
        }
        if (applicationNode == null) {
            applicationNode = new ApplicationNode("");
            this.addChild(applicationNode);
        }
        return applicationNode;
    }

    public void addInstrumentationNode(InstrumentationNode instrumentation) {
        if (instrumentation != null && !this.children.contains(instrumentation)) {
            this.children.add(instrumentation);
        }
    }

    public List<InstrumentationNode> getInstrumentationNodes() {
        LinkedList<InstrumentationNode> instrumentations = new LinkedList<InstrumentationNode>();
        AndroidManifestNode[] androidManifestNodeArray = this.getAllChildrenFromType(AndroidManifestNode.NodeType.Instrumentation);
        int n = androidManifestNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AndroidManifestNode node = androidManifestNodeArray[n2];
            instrumentations.add((InstrumentationNode)node);
            ++n2;
        }
        return instrumentations;
    }

    public void removeInstrumentationNode(InstrumentationNode instrumentation) {
        if (instrumentation != null) {
            this.children.remove(instrumentation);
        }
    }

    public void addPermissionNode(PermissionNode permission) {
        if (permission != null && !this.children.contains(permission)) {
            this.children.add(permission);
        }
    }

    public List<PermissionNode> getPermissionNodes() {
        LinkedList<PermissionNode> permissions = new LinkedList<PermissionNode>();
        AndroidManifestNode[] androidManifestNodeArray = this.getAllChildrenFromType(AndroidManifestNode.NodeType.Permission);
        int n = androidManifestNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AndroidManifestNode node = androidManifestNodeArray[n2];
            permissions.add((PermissionNode)node);
            ++n2;
        }
        return permissions;
    }

    public void removePermissionNode(PermissionNode permission) {
        if (permission != null) {
            this.children.remove(permission);
        }
    }

    public void addPermissionGroupNode(PermissionGroupNode permissionGroup) {
        if (permissionGroup != null && !this.children.contains(permissionGroup)) {
            this.children.add(permissionGroup);
        }
    }

    public List<PermissionGroupNode> getPermissionGroupNodes() {
        LinkedList<PermissionGroupNode> permissionGroups = new LinkedList<PermissionGroupNode>();
        AndroidManifestNode[] androidManifestNodeArray = this.getAllChildrenFromType(AndroidManifestNode.NodeType.PermissionGroup);
        int n = androidManifestNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AndroidManifestNode node = androidManifestNodeArray[n2];
            permissionGroups.add((PermissionGroupNode)node);
            ++n2;
        }
        return permissionGroups;
    }

    public void removePermissionGroupNode(PermissionGroupNode permissionGroup) {
        if (permissionGroup != null) {
            this.children.remove(permissionGroup);
        }
    }

    public void addPermissionTreeNode(PermissionTreeNode permissionTree) {
        if (permissionTree != null && !this.children.contains(permissionTree)) {
            this.children.add(permissionTree);
        }
    }

    public List<PermissionTreeNode> getPermissionTreeNodes() {
        LinkedList<PermissionTreeNode> permissionTrees = new LinkedList<PermissionTreeNode>();
        AndroidManifestNode[] androidManifestNodeArray = this.getAllChildrenFromType(AndroidManifestNode.NodeType.PermissionTree);
        int n = androidManifestNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AndroidManifestNode node = androidManifestNodeArray[n2];
            permissionTrees.add((PermissionTreeNode)node);
            ++n2;
        }
        return permissionTrees;
    }

    public void removePermissionTreeNode(PermissionTreeNode permissionTree) {
        if (permissionTree != null) {
            this.children.remove(permissionTree);
        }
    }

    public void addUsesPermissionNode(UsesPermissionNode usesPermission) {
        if (usesPermission != null && !this.children.contains(usesPermission)) {
            this.addBeforeApplicationNode(usesPermission);
        }
    }

    public List<UsesPermissionNode> getUsesPermissionNodes() {
        LinkedList<UsesPermissionNode> usesPermissions = new LinkedList<UsesPermissionNode>();
        AndroidManifestNode[] androidManifestNodeArray = this.getAllChildrenFromType(AndroidManifestNode.NodeType.UsesPermission);
        int n = androidManifestNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AndroidManifestNode node = androidManifestNodeArray[n2];
            usesPermissions.add((UsesPermissionNode)node);
            ++n2;
        }
        return usesPermissions;
    }

    public void removeUsesPermissionNode(UsesPermissionNode usesPermission) {
        if (usesPermission != null) {
            this.children.remove(usesPermission);
        }
    }

    public int removeUsesPermissionNode(String permission) {
        int nodesRemoved = 0;
        for (UsesPermissionNode node : this.getUsesPermissionNodes()) {
            if (!node.getName().equals(permission)) continue;
            this.removeUsesPermissionNode(node);
            ++nodesRemoved;
        }
        return nodesRemoved;
    }

    @Override
    protected List<IStatus> getSpecificNodeProblems() {
        return null;
    }

    public void addUsesFeatureNode(UsesFeatureNode usesFeature) {
        if (usesFeature != null && !this.children.contains(usesFeature)) {
            this.addBeforeApplicationNode(usesFeature);
        }
    }

    public UsesFeatureNode getUsesFeatureNode(String featureName) {
        UsesFeatureNode usesFeature = null;
        AndroidManifestNode[] androidManifestNodeArray = this.getAllChildrenFromType(AndroidManifestNode.NodeType.UsesFeature);
        int n = androidManifestNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AndroidManifestNode node = androidManifestNodeArray[n2];
            if (node.getNodeProperties() != null && node.getNodeProperties().containsKey("android:name") && node.getNodeProperties().get("android:name").equals(featureName)) {
                usesFeature = (UsesFeatureNode)node;
                break;
            }
            ++n2;
        }
        return usesFeature;
    }

    public UsesSDKNode getUsesSdkNode() {
        UsesSDKNode usesSDKNode = null;
        AndroidManifestNode[] androidManifestNodeArray = this.getAllChildrenFromType(AndroidManifestNode.NodeType.UsesSdk);
        int n = androidManifestNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AndroidManifestNode node = androidManifestNodeArray[n2];
            if (node instanceof UsesSDKNode) {
                usesSDKNode = (UsesSDKNode)node;
                break;
            }
            ++n2;
        }
        return usesSDKNode;
    }

    public void addUsesSdkNode(UsesSDKNode usesSdk) {
        if (usesSdk != null && !this.children.contains(usesSdk)) {
            this.addBeforeApplicationNode(usesSdk);
        }
    }

    private void addBeforeApplicationNode(AndroidManifestNode node) {
        ApplicationNode applicationNode = this.getApplicationNode();
        if (applicationNode != null) {
            int appNodeIdx = this.children.indexOf(applicationNode);
            this.children.add(appNodeIdx, node);
        } else {
            this.children.add(node);
        }
    }
}

