/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.command;

import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.db.core.DbCoreActivator;
import org.eclipse.andmore.android.db.core.exception.AndmoreDbException;
import org.eclipse.andmore.android.db.core.project.ProjectNode;
import org.eclipse.andmore.android.db.core.ui.DbNode;
import org.eclipse.andmore.android.db.core.ui.IDbNode;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.andmore.android.db.core.ui.action.CreateDatabaseManagementClassesAction;
import org.eclipse.andmore.android.db.core.ui.view.AndmoreDatabaseExplorerView;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CreateDatabaseManagementClassesHandler
extends AbstractHandler
implements IHandler {
    private IDbNode selectedDbNode = null;
    private ProjectNode selectedProjectNode;

    private void setSelectedNode() {
        this.selectedDbNode = null;
        this.selectedProjectNode = null;
        AndmoreDatabaseExplorerView view = DbCoreActivator.getAndmoreDatabaseExplorerView();
        if (view != null) {
            ITreeNode items = view.getSelectedItemOnTree();
            if (items != null) {
                if (items instanceof IDbNode) {
                    this.selectedDbNode = (IDbNode)items;
                } else if (items instanceof ProjectNode) {
                    this.selectedProjectNode = (ProjectNode)items;
                }
            }
        } else {
            IWorkbenchWindow window;
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null && !workbench.isClosing() && (window = workbench.getActiveWorkbenchWindow()) != null) {
                ISelection selection = window.getSelectionService().getSelection();
                Object structureSelection = null;
                structureSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : new StructuredSelection();
                Object selectionElement = structureSelection.getFirstElement();
                if (selectionElement != null) {
                    IResource resource = null;
                    if (selectionElement instanceof IResource) {
                        resource = (IResource)selectionElement;
                    } else if (selectionElement instanceof IAdaptable) {
                        try {
                            resource = (IResource)((IAdaptable)selectionElement).getAdapter(IResource.class);
                        }
                        catch (Exception e) {
                            AndmoreLogger.error(CreateDatabaseManagementClassesAction.class, (String)e.getMessage());
                        }
                    }
                    if (resource != null) {
                        this.selectedProjectNode = new ProjectNode(resource.getProject(), null);
                        if (resource instanceof IFile) {
                            try {
                                this.selectedDbNode = new DbNode((IPath)new Path(resource.getLocation().toFile().getAbsolutePath()), this.selectedProjectNode);
                            }
                            catch (AndmoreDbException e) {
                                AndmoreLogger.error(CreateDatabaseManagementClassesAction.class, (String)e.getMessage());
                            }
                        }
                    }
                }
            }
        }
    }

    public CreateDatabaseManagementClassesHandler() {
        this.setSelectedNode();
    }

    public CreateDatabaseManagementClassesHandler(IDbNode node) {
        this.selectedDbNode = node;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        CreateDatabaseManagementClassesAction action = new CreateDatabaseManagementClassesAction();
        this.setSelectedNode();
        action.setDbNodeSelected(this.selectedDbNode);
        action.setProjectNodeSelected(this.selectedProjectNode);
        action.run();
        return null;
    }
}

