/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.project;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.db.core.event.DatabaseModelEvent;
import org.eclipse.andmore.android.db.core.event.DatabaseModelEventManager;
import org.eclipse.andmore.android.db.core.exception.AndmoreDbException;
import org.eclipse.andmore.android.db.core.i18n.DbCoreNLS;
import org.eclipse.andmore.android.db.core.model.DbModel;
import org.eclipse.andmore.android.db.core.model.TableModel;
import org.eclipse.andmore.android.db.core.ui.AbstractTreeNode;
import org.eclipse.andmore.android.db.core.ui.DbNode;
import org.eclipse.andmore.android.db.core.ui.IDbNode;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.andmore.android.db.core.ui.action.IDbCreatorNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;

public class ProjectNode
extends AbstractTreeNode
implements IDbCreatorNode,
IResourceChangeListener {
    public static final String DB_FOLDER = "assets";
    private IProject project;

    private ProjectNode() {
    }

    public ProjectNode(IProject project, ITreeNode parent) {
        this(project.getName(), parent);
        this.project = project;
    }

    public ProjectNode(String id, ITreeNode parent) {
        super(parent);
        this.init(id);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    @Override
    public void refresh() {
        this.clear();
        this.loadContent();
    }

    @Override
    public IStatus createDb(String dbName) {
        return this.createDb(dbName, null);
    }

    @Override
    public IStatus createDb(String dbName, List<TableModel> tables) {
        IStatus status = Status.OK_STATUS;
        dbName = !dbName.endsWith(".db") ? String.valueOf(dbName) + ".db" : dbName;
        IPath projectPath = this.project.getLocation();
        File assetsFolder = new File(projectPath.toFile(), DB_FOLDER);
        if (!assetsFolder.exists()) {
            assetsFolder.mkdirs();
        }
        IPath dbPath = new Path(assetsFolder.getAbsolutePath()).append(String.valueOf(File.separator) + dbName);
        try {
            DbNode dbNode = new DbNode(dbPath, this, true);
            if (tables != null) {
                status = dbNode.createTables(tables);
            }
            this.putChild(dbNode);
        }
        catch (AndmoreDbException e) {
            status = new Status(4, "org.eclipse.andmore.android.db.core", NLS.bind((String)DbCoreNLS.ProjectNode_Error_While_Creating_DB, (Object)dbName), (Throwable)((Object)e));
        }
        return status;
    }

    private void init(String id) {
        this.setId(id);
        this.setName(id);
    }

    @Override
    public ImageDescriptor getIcon() {
        return this.getSpecificIcon("org.eclipe.andmore", "icons/android.png");
    }

    private void loadContent() {
        File folder = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getName()).getFile(DB_FOLDER).getLocation().toFile();
        if (folder.exists() && folder.list().length > 0) {
            File[] foundFiles = folder.listFiles();
            ArrayList<ITreeNode> dbNodes = new ArrayList<ITreeNode>(foundFiles.length);
            File[] fileArray = foundFiles;
            int n = foundFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (DbModel.isValidSQLiteDatabase(file)) {
                    try {
                        DbNode dbNode = new DbNode((IPath)new Path(file.getAbsolutePath()), this);
                        dbNodes.add(dbNode);
                    }
                    catch (AndmoreDbException andmoreDbException) {}
                }
                ++n2;
            }
            this.putChildren(dbNodes);
        }
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    protected IProject getProject() {
        return this.project;
    }

    public void addDb(File file) {
        try {
            if (DbModel.isValidSQLiteDatabase(file)) {
                IDbNode dN = null;
                Path dbPath = new Path(file.getAbsolutePath());
                dN = this.getDatabaseNodeFromFile(file);
                if (dN == null) {
                    dN = new DbNode((IPath)dbPath, this);
                    this.putChild(dN);
                }
            }
        }
        catch (AndmoreDbException e) {
            String message = NLS.bind((String)DbCoreNLS.ProjectNode_Failed_ToVerify_If_DB_Is_Valid, (Object)file.getName());
            AndmoreLogger.error(ProjectNode.class, (String)message, (Throwable)((Object)e));
        }
    }

    @Override
    public IStatus deleteDb(IDbNode dbNode) {
        IStatus status = dbNode.deleteDb();
        if (status.isOK()) {
            this.removeDb(dbNode);
        }
        return status;
    }

    public void removeDb(IDbNode dbNode) {
        this.removeChild(dbNode);
    }

    protected void updateDatabase(File dbFile) {
        IDbNode databaseNode = this.getDatabaseNodeFromFile(dbFile);
        if (databaseNode != null) {
            DatabaseModelEventManager.getInstance().fireEvent(databaseNode, DatabaseModelEvent.EVENT_TYPE.UPDATE);
        }
    }

    private IDbNode getDatabaseNodeFromFile(File dbFile) {
        Path dbFilePath = new Path(dbFile.getAbsolutePath());
        String dbFileName = dbFilePath.lastSegment();
        String id = String.valueOf(dbFilePath.toFile().getParent()) + "." + dbFileName;
        IDbNode databaseNode = null;
        ITreeNode node = this.getChildById(id);
        if (node instanceof IDbNode) {
            databaseNode = (IDbNode)node;
        }
        return databaseNode;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResource res = event.getResource();
        switch (event.getType()) {
            case 4: {
                boolean openedConnection = false;
                try {
                    IProject project;
                    IFolder assetsFolder;
                    if (res instanceof IProject && (assetsFolder = (project = (IProject)res).getFolder(DB_FOLDER)).exists()) {
                        IResource[] assetsRes = assetsFolder.members();
                        int i = 0;
                        while (i < assetsRes.length) {
                            IFile f;
                            IDbNode dbNode;
                            if (assetsRes[i] instanceof IFile && (dbNode = this.getDatabaseNodeFromFile((f = (IFile)assetsRes[i]).getLocation().toFile())).isConnected()) {
                                openedConnection = true;
                            }
                            ++i;
                        }
                    }
                }
                catch (Exception exception) {}
                if (!openedConnection) break;
                EclipseUtils.showWarningDialog((String)DbCoreNLS.UI_DeleteProjectDialogTitle, (String)DbCoreNLS.UI_DeleteProjectDialogMsg);
                break;
            }
            case 1: {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)new ResourceDeltaVisior(this));
                    break;
                }
                catch (CoreException e) {
                    AndmoreLogger.error(ProjectNode.class, (String)"Error listening to changes in resources", (Throwable)e);
                }
            }
        }
    }

    public boolean refreshAssetsFolder() {
        IFolder assetsFolder = this.project.getFolder(DB_FOLDER);
        if (assetsFolder.exists()) {
            try {
                assetsFolder.refreshLocal(2, null);
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    class ResourceDeltaVisior
    implements IResourceDeltaVisitor {
        private final ProjectNode projectNode;

        ResourceDeltaVisior(ProjectNode projectNode2) {
            this.projectNode = projectNode2;
        }

        public boolean visit(IResourceDelta delta) {
            IResource res = delta.getResource();
            if (res instanceof IResource && res.getFileExtension() != null && res.getProject().equals((Object)this.projectNode.getProject()) && res.getFileExtension().equalsIgnoreCase("db")) {
                switch (delta.getKind()) {
                    case 1: {
                        AndmoreLogger.info((String)("Database added: " + res.getFullPath()));
                        ProjectNode.this.addDb(res.getLocation().toFile());
                        break;
                    }
                    case 2: {
                        AndmoreLogger.info((String)("Database deleted: " + res.getFullPath()));
                        IDbNode dbNode = ProjectNode.this.getDatabaseNodeFromFile(res.getLocation().toFile());
                        if (dbNode == null) break;
                        ProjectNode.this.removeDb(dbNode);
                    }
                }
            }
            return true;
        }
    }
}

