/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.db.core.DbCoreActivator;
import org.eclipse.andmore.android.db.core.event.DatabaseModelEvent;
import org.eclipse.andmore.android.db.core.event.DatabaseModelEventManager;
import org.eclipse.andmore.android.db.core.i18n.DbCoreNLS;
import org.eclipse.andmore.android.db.core.ui.AbstractLoadingNodeJob;
import org.eclipse.andmore.android.db.core.ui.ISaveStateTreeNode;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.andmore.android.db.core.ui.view.SaveStateManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public abstract class AbstractTreeNode
implements ITreeNode {
    public static final String PROP_VALUE_NODE_STATUS_ERROR = "org.eclipse.andmore.android.db.core.nodeStatusError";
    public static final String PROP_NAME_NODE_STATUS = "org.eclipse.andmore.android.db.core.nodeStatus";
    private static final String DEFAULT_ICON_PATH = "icons/obj16/plate16.png";
    private String id;
    private String name;
    private ITreeNode parent;
    private ImageDescriptor icon = DbCoreActivator.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.db.core", (String)"icons/obj16/plate16.png");
    private IStatus nodeStatus = Status.OK_STATUS;
    private final List<ITreeNode> children = new CopyOnWriteArrayList<ITreeNode>();
    private volatile boolean isLoading = false;
    private String tooltip;

    public AbstractTreeNode() {
        this(null, null, null);
    }

    public AbstractTreeNode(ITreeNode parent) {
        this(null, null, parent);
    }

    public AbstractTreeNode(String id, String name, ITreeNode parent) {
        this(id, name, parent, null);
    }

    public AbstractTreeNode(String id, String name, ITreeNode parent, ImageDescriptor icon) {
        this.id = id;
        this.name = name;
        this.parent = parent;
        this.icon = icon;
        if (this instanceof ISaveStateTreeNode) {
            ISaveStateTreeNode saveStateTreeNode = (ISaveStateTreeNode)((Object)this);
            SaveStateManager saveStateManager = SaveStateManager.getInstance();
            saveStateManager.registerSaveStateNode(saveStateTreeNode);
            IEclipsePreferences prefNode = saveStateManager.getPrefNode();
            if (prefNode != null) {
                saveStateTreeNode.restoreState(prefNode);
            }
        }
    }

    @Override
    public final void refreshAsync() {
        this.refreshAsync(true);
    }

    @Override
    public final void refreshAsync(final boolean canRefreshYesResponse) {
        if (!this.isLoading()) {
            AbstractLoadingNodeJob loadingJob = new AbstractLoadingNodeJob(NLS.bind((String)DbCoreNLS.AbstractTreeNode_Loading_Job_Name, (Object)this.getName()), this){

                protected IStatus run(IProgressMonitor monitor) {
                    AbstractTreeNode.this.refresh(canRefreshYesResponse);
                    return Status.OK_STATUS;
                }
            };
            loadingJob.schedule();
        }
    }

    @Override
    public abstract void refresh();

    public void refresh(boolean canRefreshYesResponse) {
        this.refresh();
    }

    @Override
    public ITreeNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ITreeNode parent) {
        this.parent = parent;
    }

    @Override
    public List<ITreeNode> getChildren() {
        return this.children;
    }

    @Override
    public void clear() {
        DatabaseModelEventManager.getInstance().fireEvent(this, DatabaseModelEvent.EVENT_TYPE.CLEAR);
        for (ITreeNode child : this.getChildren()) {
            child.cleanUp();
            child.clear();
        }
        this.children.clear();
    }

    @Override
    public ITreeNode getChild(int index) {
        return this.children.size() > index ? this.children.get(index) : null;
    }

    @Override
    public ITreeNode getChildById(String id) {
        ITreeNode foundChild = null;
        for (ITreeNode node : this.children) {
            if (node == null || node.getId() == null || !node.getId().equals(id)) continue;
            foundChild = node;
            break;
        }
        return foundChild;
    }

    @Override
    public List<ITreeNode> getFilteredChildren(String regex) {
        ArrayList<ITreeNode> filteredChildren = new ArrayList();
        if (regex == null) {
            filteredChildren = this.getChildren();
        } else {
            for (ITreeNode child : this.children) {
                if (regex == null || !child.getId().matches(regex)) continue;
                filteredChildren.add(child);
            }
        }
        return filteredChildren;
    }

    @Override
    public void putChild(ITreeNode treeNode) {
        treeNode.setParent(this);
        this.children.add(treeNode);
        DatabaseModelEventManager.getInstance().fireEvent(treeNode, DatabaseModelEvent.EVENT_TYPE.ADD);
    }

    @Override
    public void putChildren(List<ITreeNode> childrenList) {
        this.children.addAll(childrenList);
    }

    @Override
    public void removeChild(ITreeNode node) {
        node.cleanUp();
        this.children.remove(node);
        DatabaseModelEventManager.getInstance().fireEvent(node, DatabaseModelEvent.EVENT_TYPE.REMOVE);
    }

    @Override
    public boolean isLoading() {
        return this.isLoading;
    }

    @Override
    public void setLoading(boolean isLoading) {
        this.isLoading = isLoading;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ImageDescriptor getIcon() {
        return this.icon;
    }

    protected final ImageDescriptor getSpecificIcon(String bundleId, String iconPath) {
        ImageDescriptor imgDesc = null;
        try {
            Bundle bundle = Platform.getBundle((String)bundleId);
            URL path = bundle.getEntry("/");
            URL fullPathString = new URL(path, iconPath);
            imgDesc = ImageDescriptor.createFromURL((URL)fullPathString);
        }
        catch (Exception e) {
            AndmoreLogger.error(this.getClass(), (String)"Error retrieving icon for tree node", (Throwable)e);
        }
        if (imgDesc == null) {
            imgDesc = this.getIcon();
        }
        return imgDesc;
    }

    @Override
    public void setIcon(ImageDescriptor icon) {
        this.icon = icon;
    }

    @Override
    public IStatus canRefresh() {
        return Status.OK_STATUS;
    }

    @Override
    public abstract boolean isLeaf();

    public String toString() {
        return "AbstractTreeNode [id=" + this.id + ", name=" + this.name + ", parent=" + this.parent + "]";
    }

    @Override
    public void cleanUp() {
        for (ITreeNode node : this.children) {
            node.cleanUp();
        }
        if (this instanceof ISaveStateTreeNode) {
            SaveStateManager.getInstance().unregisterSaveStateNode((ISaveStateTreeNode)((Object)this));
        }
    }

    @Override
    public void setNodeStatus(IStatus status) {
        this.nodeStatus = status;
        DatabaseModelEventManager.getInstance().fireEvent(this, DatabaseModelEvent.EVENT_TYPE.UPDATE);
    }

    @Override
    public IStatus getNodeStatus() {
        return this.nodeStatus;
    }

    public boolean testAttribute(Object target, String name, String value) {
        boolean result = false;
        if (name.equals(PROP_NAME_NODE_STATUS) && value.equals(PROP_VALUE_NODE_STATUS_ERROR)) {
            result = !this.getNodeStatus().isOK();
        }
        return result;
    }

    @Override
    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }
}

