/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.ui.view;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.andmore.android.db.core.ui.ISaveStateTreeNode;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class SaveStateManager {
    private static SaveStateManager instance;
    private final Set<ISaveStateTreeNode> registeredTreeNodes = Collections.synchronizedSet(new HashSet());
    private final IEclipsePreferences prefNode = InstanceScope.INSTANCE.getNode("org.eclipse.andmore.android.db.core");

    private SaveStateManager() {
    }

    public static SaveStateManager getInstance() {
        if (instance == null) {
            instance = new SaveStateManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSaveStateNode(ISaveStateTreeNode treeNode) {
        Set<ISaveStateTreeNode> set = this.registeredTreeNodes;
        synchronized (set) {
            this.registeredTreeNodes.add(treeNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState() {
        Set<ISaveStateTreeNode> set = this.registeredTreeNodes;
        synchronized (set) {
            for (ISaveStateTreeNode registeredTreeNode : this.registeredTreeNodes) {
                registeredTreeNode.saveState(this.prefNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSaveStateNode(ISaveStateTreeNode node) {
        Set<ISaveStateTreeNode> set = this.registeredTreeNodes;
        synchronized (set) {
            this.registeredTreeNodes.remove(node);
        }
    }

    public IEclipsePreferences getPrefNode() {
        return this.prefNode;
    }
}

