/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.devices.model;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.andmore.android.AndmoreEventManager;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.DdmsRunnable;
import org.eclipse.andmore.android.db.core.CanRefreshStatus;
import org.eclipse.andmore.android.db.core.ui.AbstractTreeNode;
import org.eclipse.andmore.android.db.core.ui.IRootNode;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.andmore.android.db.devices.i18n.DbDevicesNLS;
import org.eclipse.andmore.android.db.devices.model.DeviceNode;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DevicesRootNode
extends AbstractTreeNode
implements IRootNode {
    private static final String ICON_PATH = "icons/obj16/devices.png";
    private ConnectDeviceListener connectedListener = new ConnectDeviceListener(this);
    private DisconnectDeviceListener disconnectedListener = new DisconnectDeviceListener(this);

    public DevicesRootNode() {
        AndmoreEventManager.asyncAddDeviceChangeListeners((DdmsRunnable)this.connectedListener, (DdmsRunnable)this.disconnectedListener);
    }

    public IStatus canRefresh() {
        ArrayList<IStatus> childrenStatus = new ArrayList<IStatus>(this.getChildren().size());
        String message = NLS.bind((String)DbDevicesNLS.DevicesRootNode_Cant_Refresh_Node, (Object)this.getName());
        for (ITreeNode treeNode : this.getChildren()) {
            IStatus nodecanRefresh = treeNode.canRefresh();
            if (nodecanRefresh.isOK()) continue;
            childrenStatus.add(nodecanRefresh);
            message = nodecanRefresh.getMessage();
            break;
        }
        IStatus status = null;
        if (!childrenStatus.isEmpty()) {
            status = new CanRefreshStatus(16, "org.eclipse.andmore.android.db.devices", childrenStatus.toArray(new IStatus[0]), message);
        }
        return status != null ? status : Status.OK_STATUS;
    }

    public void refresh() {
        this.clear();
        Collection connectedSerialNumbers = DDMSFacade.getConnectedSerialNumbers();
        ArrayList<DeviceNode> deviceNodes = new ArrayList<DeviceNode>();
        for (String serialNumber : connectedSerialNumbers) {
            DeviceNode deviceNode = new DeviceNode(serialNumber, (ITreeNode)this);
            deviceNodes.add(deviceNode);
        }
        this.putChildren(deviceNodes);
    }

    public boolean isLeaf() {
        return false;
    }

    public ImageDescriptor getIcon() {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.db.devices", (String)ICON_PATH);
    }

    public void cleanUp() {
        super.cleanUp();
        AndmoreEventManager.removeEventListener((AndmoreEventManager.EventType)AndmoreEventManager.EventType.DEVICE_CONNECTED, (DdmsRunnable)this.connectedListener);
        AndmoreEventManager.removeEventListener((AndmoreEventManager.EventType)AndmoreEventManager.EventType.DEVICE_DISCONNECTED, (DdmsRunnable)this.disconnectedListener);
    }

    private static class ConnectDeviceListener
    implements DdmsRunnable {
        private DevicesRootNode devicesRootNode;

        public ConnectDeviceListener(DevicesRootNode devicesRootNode) {
            this.devicesRootNode = devicesRootNode;
        }

        public void run(String serialNumber) {
            DeviceNode deviceNode = new DeviceNode(serialNumber, (ITreeNode)this.devicesRootNode);
            this.devicesRootNode.putChild(deviceNode);
        }
    }

    private static class DisconnectDeviceListener
    implements DdmsRunnable {
        private DevicesRootNode devicesRootNode;

        public DisconnectDeviceListener(DevicesRootNode devicesRootNode) {
            this.devicesRootNode = devicesRootNode;
        }

        public void run(String serialNumber) {
            ITreeNode treeNode = this.devicesRootNode.getChildById(serialNumber);
            if (treeNode instanceof DeviceNode) {
                DeviceNode deviceNode = (DeviceNode)treeNode;
                this.devicesRootNode.removeChild(deviceNode);
            }
        }
    }
}

