/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.devices.services;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sequoyah.device.framework.factory.DeviceTypeRegistry;
import org.eclipse.sequoyah.device.framework.model.IDeviceType;
import org.eclipse.sequoyah.device.framework.model.IService;
import org.eclipse.sequoyah.device.framework.model.handler.IServiceHandler;
import org.eclipse.sequoyah.device.framework.model.handler.ServiceHandler;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class DeviceServicesPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.andmore.android.devices.services";
    public static final String DEPLOY_SERVICE_ID = "org.eclipse.andmore.android.devices.services.deployService";
    public static final String UNINSTALL_APP_SERVICE_ID = "org.eclipse.andmore.android.devices.services.uninstallAppService";
    private static ServiceHandler deployServiceHandler = null;
    private static ServiceHandler uninstallAppServiceHandler = null;
    public static final boolean IS_WIN32 = Platform.getOS().equals("win32");
    private static String EMULATOR_CONSOLE_SERVICE_ID = "org.eclipse.andmore.android.devices.services.emulatorConsole";
    private static String ADB_SHELL_SERVICE_ID = "org.eclipse.andmore.android.devices.services.adbShell";
    private static DeviceServicesPlugin plugin;
    private static final String SCREENSHOT_SERVICE_ID = "org.eclipse.andmore.android.devices.services.takescreenshot";
    private static final String MONKEY_SERVICE_ID = "org.eclipse.andmore.android.devices.services.monkey";
    private static ServiceHandler screenshotServiceHandler;
    private static ServiceHandler monkeyServiceHandler;
    private static ServiceHandler adbShellServiceHandler;
    private static ServiceHandler emulatorConsoleServiceHandler;
    public static final String ANDROID_LANG_SERVICE_ID = "org.eclipse.andmore.android.devices.services.changeLanguageService";
    public static final String LANG_PAGE_CONTEXT_HELP_ID = "org.eclipse.andmore.android.devices.services.langPage";
    private static Collection<IConsoleKilledListener> listeners;
    private final IWorkbenchListener workbenchListener = new IWorkbenchListener(){

        public boolean preShutdown(IWorkbench workbench, boolean forced) {
            ArrayList<IConsole> consolesToClose = new ArrayList<IConsole>();
            ArrayList copy = new ArrayList(listeners);
            IConsole[] iConsoleArray = (IConsole[])ConsolePlugin.getDefault().getConsoleManager().getConsoles().clone();
            int n = iConsoleArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole console = iConsoleArray[n2];
                if (console.getName().contains("Emulator Console") || console.getName().contains("ADB Shell")) {
                    for (IConsoleKilledListener listener : copy) {
                        listener.consoleKilled(console.getName());
                    }
                    consolesToClose.add(console);
                }
                ++n2;
            }
            if (consolesToClose.size() > 0) {
                ConsolePlugin.getDefault().getConsoleManager().removeConsoles(consolesToClose.toArray(new IConsole[0]));
            }
            return true;
        }

        public void postShutdown(IWorkbench workbench) {
        }
    };

    static {
        screenshotServiceHandler = null;
        monkeyServiceHandler = null;
        adbShellServiceHandler = null;
        emulatorConsoleServiceHandler = null;
        listeners = new ArrayList<IConsoleKilledListener>();
    }

    public static void addConsoleKilledListener(IConsoleKilledListener listener) {
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public static void removeConsoleKilledListener(IConsoleKilledListener listener) {
        listeners.remove(listener);
    }

    public void start(BundleContext context) throws Exception {
        AndmoreLogger.debug(DeviceServicesPlugin.class, (String)"Starting Andmore Device Services Plugin...");
        super.start(context);
        plugin = this;
        PlatformUI.getWorkbench().addWorkbenchListener(this.workbenchListener);
        AndmoreLogger.debug(DeviceServicesPlugin.class, (String)"Andmore Device Services Plugin started.");
    }

    public void stop(BundleContext context) throws Exception {
        PlatformUI.getWorkbench().removeWorkbenchListener(this.workbenchListener);
        plugin = null;
        super.stop(context);
    }

    public static DeviceServicesPlugin getDefault() {
        return plugin;
    }

    public static void redirectProcessStreamsToConsole(Process p, String consoleName) {
        InputStream processIn = p.getInputStream();
        OutputStream processOut = p.getOutputStream();
        DeviceServicesPlugin.redirectStreamsToConsole(processIn, processOut, consoleName);
    }

    public static void redirectStreamsToConsole(final InputStream in, final OutputStream out, final String consoleName) {
        final IOConsole console = new IOConsole(consoleName, null);
        console.activate();
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
        final IOConsoleOutputStream consoleOut = console.newOutputStream();
        final IOConsoleInputStream consoleIn = console.getInputStream();
        new Thread(new Runnable(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                carriageReturn = false;
                try {
                    while (true) {
                        if ((byteRead = in.read()) == -1) {
                            throw new Exception();
                        }
                        if (carriageReturn && byteRead != 13) {
                            consoleOut.write(13);
                            consoleOut.write(byteRead);
                            carriageReturn = false;
                        } else if (!carriageReturn && byteRead == 13) {
                            carriageReturn = true;
                        } else {
                            consoleOut.write(byteRead);
                            carriageReturn = false;
                        }
                        consoleOut.flush();
                    }
                }
                catch (Exception v0) {
                    ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{console});
                    cloneListeners = new ArrayList<E>(DeviceServicesPlugin.access$0());
                    ** for (listener : cloneListeners)
                }
lbl-1000:
                // 1 sources

                {
                    listener.consoleKilled(consoleName);
                    continue;
                }
lbl24:
                // 1 sources

            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        int byteRead = consoleIn.read();
                        out.write(byteRead);
                        out.flush();
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }
        }).start();
    }

    public static ServiceHandler getADBShellServiceHandler() {
        if (adbShellServiceHandler == null && ADB_SHELL_SERVICE_ID != null) {
            IDeviceType device = DeviceTypeRegistry.getInstance().getDeviceTypeById("org.eclipse.andmore.android.emulator.androidDevice");
            List services = device.getServices();
            for (IService service : services) {
                IServiceHandler handler = service.getHandler();
                if (!handler.getService().getId().equals(ADB_SHELL_SERVICE_ID)) continue;
                adbShellServiceHandler = (ServiceHandler)handler;
                break;
            }
        }
        return adbShellServiceHandler;
    }

    public static ServiceHandler getEmulatorConsoleServiceHandler() {
        if (emulatorConsoleServiceHandler == null && EMULATOR_CONSOLE_SERVICE_ID != null) {
            IDeviceType device = DeviceTypeRegistry.getInstance().getDeviceTypeById("org.eclipse.andmore.android.emulator.androidDevice");
            List services = device.getServices();
            for (IService service : services) {
                IServiceHandler handler = service.getHandler();
                if (!handler.getService().getId().equals(EMULATOR_CONSOLE_SERVICE_ID)) continue;
                emulatorConsoleServiceHandler = (ServiceHandler)handler;
                break;
            }
        }
        return emulatorConsoleServiceHandler;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return DeviceServicesPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static ServiceHandler getDeployServiceHandler() {
        if (deployServiceHandler == null && DEPLOY_SERVICE_ID != null) {
            IDeviceType device = DeviceTypeRegistry.getInstance().getDeviceTypeById("org.eclipse.andmore.android.emulator.androidDevice");
            List services = device.getServices();
            for (IService service : services) {
                IServiceHandler handler = service.getHandler();
                if (!handler.getService().getId().equals(DEPLOY_SERVICE_ID)) continue;
                deployServiceHandler = (ServiceHandler)handler;
                break;
            }
        }
        return deployServiceHandler;
    }

    public static ServiceHandler getUninstallAppServiceHandler() {
        if (uninstallAppServiceHandler == null && UNINSTALL_APP_SERVICE_ID != null) {
            IDeviceType device = DeviceTypeRegistry.getInstance().getDeviceTypeById("org.eclipse.andmore.android.emulator.androidDevice");
            List services = device.getServices();
            for (IService service : services) {
                IServiceHandler handler = service.getHandler();
                if (!handler.getService().getId().equals(UNINSTALL_APP_SERVICE_ID)) continue;
                uninstallAppServiceHandler = (ServiceHandler)handler;
                break;
            }
        }
        return uninstallAppServiceHandler;
    }

    public static ServiceHandler getScreenshotServiceHandler() {
        if (screenshotServiceHandler == null && SCREENSHOT_SERVICE_ID != null) {
            IDeviceType device = DeviceTypeRegistry.getInstance().getDeviceTypeById("org.eclipse.andmore.android.emulator.androidDevice");
            List services = device.getServices();
            for (IService service : services) {
                IServiceHandler handler = service.getHandler();
                if (!handler.getService().getId().equals(SCREENSHOT_SERVICE_ID)) continue;
                screenshotServiceHandler = (ServiceHandler)handler;
                break;
            }
        }
        return screenshotServiceHandler;
    }

    public static ServiceHandler getMonkeyServiceHandler() {
        if (monkeyServiceHandler == null && MONKEY_SERVICE_ID != null) {
            IDeviceType device = DeviceTypeRegistry.getInstance().getDeviceTypeById("org.eclipse.andmore.android.emulator.androidDevice");
            List services = device.getServices();
            IServiceHandler handler = null;
            for (IService service : services) {
                handler = service.getHandler();
                if (!handler.getService().getId().equals(MONKEY_SERVICE_ID)) continue;
                monkeyServiceHandler = (ServiceHandler)handler;
                break;
            }
        }
        return monkeyServiceHandler;
    }

    public static interface IConsoleKilledListener {
        public void consoleKilled(String var1);
    }
}

