/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.devices.services.lang.model;

import org.eclipse.andmore.android.devices.services.i18n.ServicesNLS;
import org.eclipse.andmore.android.devices.services.lang.model.Country;
import org.eclipse.andmore.android.devices.services.lang.model.Language;
import org.eclipse.andmore.android.devices.services.lang.model.LocationComposite;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class LangWizardPage
extends WizardPage {
    LocationComposite locationComposite = null;
    private String[] currentLangAndCountry = null;

    public LangWizardPage() {
        this(null);
    }

    public LangWizardPage(String[] currentLangAndCountry) {
        super("langWizardPage");
        this.currentLangAndCountry = currentLangAndCountry;
        this.setTitle(ServicesNLS.UI_Wizard_Page_Locale_Title);
        this.setDescription(ServicesNLS.UI_Wizard_Page_Locale_Description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.andmore.android.devices.services.langPage");
        GridLayout mainLayout = new GridLayout(1, false);
        mainLayout.marginTop = 0;
        mainLayout.marginWidth = 0;
        mainLayout.marginHeight = 0;
        this.locationComposite = this.currentLangAndCountry != null ? new LocationComposite(parent, this.currentLangAndCountry[0], this.currentLangAndCountry[1]) : new LocationComposite(parent);
        this.locationComposite.addListener(1234, new Listener(){

            public void handleEvent(Event arg0) {
                LangWizardPage.this.updatePageComplete();
            }
        });
        this.locationComposite.setLayoutData(mainLayout);
        this.setControl((Control)this.locationComposite);
    }

    private void updatePageComplete() {
        this.setPageComplete(false);
        String language = Language.getIdFromName(this.locationComposite.getLanguage());
        String country = Country.getIdFromName(this.locationComposite.getCountry());
        if (this.currentLangAndCountry == null || !this.currentLangAndCountry[0].equals(language) || !this.currentLangAndCountry[1].equals(country)) {
            this.setPageComplete(true);
        }
    }

    public String getLanguage() {
        return this.locationComposite.getLanguage();
    }

    public String getCountry() {
        return this.locationComposite.getCountry();
    }
}

