/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.devices.services.lang.model;

import java.util.List;
import org.eclipse.andmore.android.devices.services.i18n.ServicesNLS;
import org.eclipse.andmore.android.devices.services.lang.model.Country;
import org.eclipse.andmore.android.devices.services.lang.model.Language;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class LocationComposite
extends Composite {
    static final int LOCATION_CHANGE = 1234;
    private String language = "";
    private String country = "";
    private Combo comboLanguage = null;
    private Combo comboCountry = null;

    public LocationComposite(Composite parent) {
        this(parent, null, null);
    }

    public LocationComposite(Composite parent, String currentLanguageId, String currentCountryId) {
        super(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 16384);
        label.setText(ServicesNLS.UI_Language);
        this.comboLanguage = new Combo((Composite)this, 12);
        this.comboLanguage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LocationComposite.this.language = LocationComposite.this.comboLanguage.getText();
                LocationComposite.this.notifyListeners(1234, null);
            }
        });
        if (currentLanguageId != null && !currentLanguageId.equals("")) {
            this.fillComboBoxAndSelectCurrentLanguage(currentLanguageId);
        } else {
            this.comboLanguage.setItems(this.getLanguagesList());
        }
        this.language = this.comboLanguage.getText();
        this.comboLanguage.setLayoutData((Object)new GridData(4, 4, true, false));
        this.comboLanguage.setVisibleItemCount(20);
        label = new Label((Composite)this, 16384);
        label.setText(ServicesNLS.UI_Country);
        this.comboCountry = new Combo((Composite)this, 12);
        this.comboCountry.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LocationComposite.this.country = LocationComposite.this.comboCountry.getText();
                LocationComposite.this.notifyListeners(1234, null);
            }
        });
        if (currentCountryId != null && !currentCountryId.equals("")) {
            this.fillComboBoxAndSelectCurrentCountry(currentCountryId);
        } else {
            this.comboCountry.setItems(this.getCountriesList());
        }
        this.country = this.comboCountry.getText();
        this.comboCountry.setLayoutData((Object)new GridData(4, 4, true, false));
        this.comboCountry.setVisibleItemCount(20);
    }

    private void fillComboBoxAndSelectCurrentLanguage(String currentLanguageId) {
        String[] langNamesAndIndex = this.getLanguagesList(currentLanguageId);
        int index = langNamesAndIndex.length - 1;
        int currentLanguageIndex = Integer.parseInt(langNamesAndIndex[index]);
        this.comboLanguage.setItems(langNamesAndIndex);
        this.comboLanguage.remove(index);
        this.comboLanguage.select(currentLanguageIndex);
    }

    private void fillComboBoxAndSelectCurrentCountry(String currentCountryId) {
        String[] countryNamesAndIndex = this.getCountriesList(currentCountryId);
        int index = countryNamesAndIndex.length - 1;
        int currentCountryIndex = Integer.parseInt(countryNamesAndIndex[index]);
        this.comboCountry.setItems(countryNamesAndIndex);
        this.comboCountry.remove(index);
        this.comboCountry.select(currentCountryIndex);
    }

    private String[] getLanguagesList() {
        List<Language> languageObjs = Language.getLanguageList();
        String[] languages = new String[languageObjs.size()];
        int i = 0;
        for (Language language : languageObjs) {
            languages[i] = language.getName();
            ++i;
        }
        return languages;
    }

    private String[] getLanguagesList(String currentlanguageId) {
        List<Language> languageObjs = Language.getLanguageList();
        int size = languageObjs.size();
        String[] langNamesAndIndex = new String[size + 1];
        String languageIndex = null;
        int i = 0;
        for (Language language : languageObjs) {
            String name = language.getName();
            String id = language.getId();
            if (id.equalsIgnoreCase(currentlanguageId)) {
                langNamesAndIndex[size] = languageIndex = String.valueOf(i);
            }
            langNamesAndIndex[i] = name;
            ++i;
        }
        return langNamesAndIndex;
    }

    private String[] getCountriesList() {
        List<Country> countryObjs = Country.getCountryList();
        String[] countries = new String[countryObjs.size()];
        int i = 0;
        for (Country country : countryObjs) {
            countries[i] = country.getName();
            ++i;
        }
        return countries;
    }

    private String[] getCountriesList(String currentCountryId) {
        List<Country> countryObjs = Country.getCountryList();
        int size = countryObjs.size();
        String[] countryNamesAndIndex = new String[size + 1];
        String countryIndex = null;
        int i = 0;
        for (Country country : countryObjs) {
            String name = country.getName();
            String id = country.getId();
            if (id.equalsIgnoreCase(currentCountryId)) {
                countryNamesAndIndex[size] = countryIndex = String.valueOf(i);
            }
            countryNamesAndIndex[i] = name;
            ++i;
        }
        return countryNamesAndIndex;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCountry() {
        return this.country;
    }
}

