/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator;

import java.util.List;
import java.util.Properties;
import org.eclipse.andmore.android.AndmoreEventManager;
import org.eclipse.andmore.android.AndroidPlugin;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.DdmsRunnable;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.preferences.DialogWithToggleUtils;
import org.eclipse.andmore.android.emulator.core.devfrm.DeviceFrameworkManager;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.device.AndroidDeviceUtils;
import org.eclipse.andmore.android.emulator.device.SequoyahLogRedirector;
import org.eclipse.andmore.android.emulator.device.instance.AndroidDevInstListener;
import org.eclipse.andmore.android.emulator.device.instance.AndroidDeviceInstance;
import org.eclipse.andmore.android.emulator.device.refresh.InstancesListRefresh;
import org.eclipse.andmore.android.emulator.device.sync.DeviceViewsSync;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.emulator.ui.view.AbstractAndroidView;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.device.framework.events.IInstanceListener;
import org.eclipse.sequoyah.device.framework.events.InstanceAdapter;
import org.eclipse.sequoyah.device.framework.events.InstanceEvent;
import org.eclipse.sequoyah.device.framework.events.InstanceEventManager;
import org.eclipse.sequoyah.device.framework.factory.DeviceTypeRegistry;
import org.eclipse.sequoyah.device.framework.model.IDeviceType;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.IService;
import org.eclipse.sequoyah.device.framework.model.handler.IServiceHandler;
import org.eclipse.sequoyah.device.framework.model.handler.ServiceHandler;
import org.eclipse.sequoyah.device.framework.ui.view.InstanceMgtView;
import org.eclipse.sequoyah.device.framework.ui.wizard.DefaultDeviceTypeMenuWizardPage;
import org.eclipse.sequoyah.vnc.utilities.logger.ILogger;
import org.eclipse.sequoyah.vnc.utilities.logger.Logger;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class EmulatorPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.andmore.android.emulator";
    private static EmulatorPlugin plugin;
    public static final String DEVICE_ID = "org.eclipse.andmore.android.emulator.androidDevice";
    public static final String STATUS_ONLINE_ID = "org.eclipse.andmore.android.emulator.status.online";
    public static final String STATUS_OFFLINE_NO_DATA = "org.eclipse.andmore.android.emulator.status.offlineNoData";
    public static final String STATUS_OFFLINE = "org.eclipse.andmore.android.emulator.status.offline";
    public static final String STATUS_NOT_AVAILABLE = "org.eclipse.andmore.android.emulator.status.notavailable";
    public static final String SERVICE_INIT_ID = "org.eclipse.andmore.android.emulator.initEmulatorService";
    public static final String STOP_SERVICE_ID = "org.eclipse.andmore.android.emulator.stopService";
    public static final String START_SERVICE_ID = "org.eclipse.andmore.android.emulator.startService";
    private static final String DEV_MANAGER_HELP = "org.eclipse.sequoyah.device.framework.ui.devmgr";
    private static final String NEW_DEVICE_HELP = "org.eclipse.sequoyah.device.framework.ui.newdev";
    public static String DEFAULT_EMULATOR_DEFINITION;
    public static final String FORCE_ATTR = "force";
    public static final String EMULATOR_UNEXPECTEDLY_STOPPED = "emulator.unexpectedly.stopped";
    private static AndroidDevInstListener instanceListener;
    private static DdmsRunnable connectedListener;
    private static DdmsRunnable disconnectedListener;
    private static final Runnable sdkLoaderListener;
    private static IInstanceListener sequoyahInstanceListener;
    private static ServiceHandler stopServiceHandler;
    private static ServiceHandler startServiceHandler;
    private static String stopServiceId;
    private static String startServiceId;

    static {
        DEFAULT_EMULATOR_DEFINITION = "org.eclipse.andmore.android.emulator10.defaultEmulatorDefinitions";
        connectedListener = new DdmsRunnable(){

            public void run(String serialNumber) {
                if (DDMSFacade.isEmulator((String)serialNumber)) {
                    DeviceFrameworkManager devFrameworkManager;
                    IAndroidEmulatorInstance instance;
                    InstancesListRefresh.refresh();
                    AndmoreLogger.info((String)("New Device connected at " + serialNumber));
                    String vmName = DDMSFacade.getNameBySerialNumber((String)serialNumber);
                    if (vmName != null && (instance = (devFrameworkManager = DeviceFrameworkManager.getInstance()).getInstanceByName(vmName)) instanceof AndroidDeviceInstance) {
                        AndroidDeviceInstance emulatorInstance = (AndroidDeviceInstance)instance;
                        AndroidDeviceUtils.fireDummyStartTransition(emulatorInstance, serialNumber);
                    }
                }
            }
        };
        disconnectedListener = new DdmsRunnable(){

            public void run(String serialNum) {
                if (DDMSFacade.isEmulator((String)serialNum)) {
                    AndmoreLogger.info((String)("Device just disconnected from serial=" + serialNum));
                    String vmName = DDMSFacade.getNameBySerialNumber((String)serialNum);
                    if (vmName != null) {
                        IAndroidEmulatorInstance instance = DeviceFrameworkManager.getInstance().getInstanceByName(vmName);
                        if (instance != null && instance.isStarted()) {
                            try {
                                instance.stop(true);
                                DialogWithToggleUtils.showError((String)EmulatorPlugin.EMULATOR_UNEXPECTEDLY_STOPPED, (String)EmulatorNLS.GEN_Error, (String)NLS.bind((String)EmulatorNLS.ERR_AndroidLogicPlugin_EmulatorStopped, (Object)instance.getName()));
                            }
                            catch (Exception exception) {
                                AndmoreLogger.error((String)("Error trying to force the stop process on instance associated to disconnected device: " + instance));
                            }
                        }
                        if (instance instanceof AndroidDeviceInstance) {
                            ((AndroidDeviceInstance)instance).setNameSuffix(null);
                            InstanceEventManager.getInstance().notifyListeners(new InstanceEvent(InstanceEvent.InstanceEventType.INSTANCE_UPDATED, (IInstance)((AndroidDeviceInstance)instance)));
                        }
                    } else {
                        for (IAndroidEmulatorInstance instance : DeviceFrameworkManager.getInstance().getAllInstances()) {
                            AndroidDeviceInstance androidInstance;
                            String instanceSuffix;
                            if (!(instance instanceof AndroidDeviceInstance) || (instanceSuffix = (androidInstance = (AndroidDeviceInstance)instance).getNameSuffix()) == null || !instanceSuffix.equals(serialNum)) continue;
                            androidInstance.setNameSuffix(null);
                            InstanceEventManager.getInstance().notifyListeners(new InstanceEvent(InstanceEvent.InstanceEventType.INSTANCE_UPDATED, (IInstance)androidInstance));
                        }
                    }
                }
            }
        };
        sdkLoaderListener = new Runnable(){

            @Override
            public void run() {
                IPreferenceStore store;
                boolean deviceStartupOptionsUpdated;
                InstancesListRefresh.refresh();
                if (!Platform.getOS().equals("macosx") && !(deviceStartupOptionsUpdated = (store = EmulatorPlugin.getDefault().getPreferenceStore()).getBoolean("DeviceStartupOptionsUpdated"))) {
                    for (IAndroidEmulatorInstance instance : DeviceFrameworkManager.getInstance().getAllInstances()) {
                        if (!(instance instanceof AndroidDeviceInstance)) continue;
                        AndroidDeviceInstance androidInstance = (AndroidDeviceInstance)instance;
                        Properties emuProperties = androidInstance.getProperties();
                        String commandline = emuProperties.getProperty("Command_Line", "");
                        if (commandline.contains("-no-window")) {
                            commandline = commandline.replace("-no-window", "");
                        }
                        emuProperties.setProperty("Command_Line", commandline);
                        androidInstance.setProperties(emuProperties);
                        InstanceEventManager.getInstance().notifyListeners(new InstanceEvent(InstanceEvent.InstanceEventType.INSTANCE_UPDATED, (IInstance)androidInstance));
                    }
                    store.setValue("DeviceStartupOptionsUpdated", true);
                }
            }
        };
        sequoyahInstanceListener = new InstanceAdapter(){

            public void instanceUpdated(InstanceEvent e) {
                AbstractAndroidView.updateInstanceName(e.getInstance());
            }
        };
        stopServiceHandler = null;
        startServiceHandler = null;
        stopServiceId = null;
        startServiceId = null;
    }

    public EmulatorPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        AndmoreLogger.debug(EmulatorPlugin.class, (String)"Starting Andmore Emulator Plugin...");
        super.start(context);
        this.start();
        AndmoreLogger.debug(EmulatorPlugin.class, (String)"Andmore Emulator Plugin started.");
    }

    private void start() {
        SequoyahLogRedirector tmlLogger = new SequoyahLogRedirector();
        Logger.setLogger((ILogger)tmlLogger);
        BasePlugin.getBaseDefault().setLogger((org.eclipse.sequoyah.device.common.utilities.logger.ILogger)tmlLogger);
        instanceListener = new AndroidDevInstListener();
        InstanceEventManager.getInstance().addInstanceListener((IInstanceListener)instanceListener);
        AndmoreEventManager.asyncAddDeviceChangeListeners((DdmsRunnable)connectedListener, (DdmsRunnable)disconnectedListener);
        AndroidPlugin.getDefault().addSDKLoaderListener(sdkLoaderListener);
        DeviceViewsSync.getInstance().initialize();
        DefaultDeviceTypeMenuWizardPage.setHelpContextId((String)NEW_DEVICE_HELP);
        InstanceMgtView.setHelp((String)DEV_MANAGER_HELP);
        InstanceEventManager.getInstance().addInstanceListener(sequoyahInstanceListener);
        EmulatorPlugin.registerStopServiceId(STOP_SERVICE_ID);
        EmulatorPlugin.registerStartServiceId(START_SERVICE_ID);
    }

    public void stop(BundleContext context) throws Exception {
        AndroidPlugin.getDefault().removeSDKLoaderListener(sdkLoaderListener);
        InstanceEventManager.getInstance().removeInstanceListener((IInstanceListener)instanceListener);
        AndmoreEventManager.asyncRemoveDeviceChangeListeners((DdmsRunnable)connectedListener, (DdmsRunnable)disconnectedListener);
        InstanceEventManager.getInstance().removeInstanceListener(sequoyahInstanceListener);
        EmulatorPlugin.unregisterStopServiceHandler();
        EmulatorPlugin.unregisterStartServiceHandler();
        plugin = null;
        super.stop(context);
    }

    public static void registerStopServiceId(String stopServiceId) {
        EmulatorPlugin.stopServiceId = stopServiceId;
    }

    public static void unregisterStopServiceHandler() {
        stopServiceHandler = null;
        stopServiceId = null;
    }

    public static ServiceHandler getStopServiceHandler() {
        if (stopServiceHandler == null && stopServiceId != null) {
            IDeviceType device = DeviceTypeRegistry.getInstance().getDeviceTypeById(DEVICE_ID);
            List services = device.getServices();
            for (IService service : services) {
                IServiceHandler handler = service.getHandler();
                if (!handler.getService().getId().equals(stopServiceId)) continue;
                stopServiceHandler = (ServiceHandler)handler;
                break;
            }
        }
        return stopServiceHandler;
    }

    public static void registerStartServiceId(String startServiceId) {
        EmulatorPlugin.startServiceId = startServiceId;
    }

    public static void unregisterStartServiceHandler() {
        startServiceHandler = null;
        startServiceId = null;
    }

    public static ServiceHandler getStartServiceHandler() {
        if (startServiceHandler == null && startServiceId != null) {
            IDeviceType device = DeviceTypeRegistry.getInstance().getDeviceTypeById(DEVICE_ID);
            List services = device.getServices();
            for (IService service : services) {
                IServiceHandler handler = service.getHandler();
                if (!handler.getService().getId().equals(startServiceId)) continue;
                startServiceHandler = (ServiceHandler)handler;
                break;
            }
        }
        return startServiceHandler;
    }

    public static EmulatorPlugin getDefault() {
        return plugin;
    }
}

