/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.core.skin;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.emulator.core.exception.SkinException;
import org.eclipse.andmore.android.emulator.core.skin.IAndroidSkin;
import org.eclipse.andmore.android.emulator.core.skin.ISkinFrameworkConstants;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.osgi.util.NLS;

public class SkinFramework
implements ISkinFrameworkConstants {
    private final Map<String, String> skinIdMap = new HashMap<String, String>();

    public SkinFramework() {
        this.populateSkinIdMap();
    }

    public Collection<String> getAllInstalledSkinIds() {
        return this.skinIdMap.keySet();
    }

    public IAndroidSkin getSkinById(String skinId) throws SkinException {
        return this.getSkinById(skinId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IAndroidSkin getSkinById(String skinId, File emulatorInstallDir) throws SkinException {
        IAndroidSkin selectedSkin = null;
        if (skinId == null) {
            AndmoreLogger.error((String)"A null parameter as skin name was provided for retrieving a skin object");
            throw new SkinException(NLS.bind((String)EmulatorNLS.WARN_SkinFramework_SkinNotInstalled, (Object)"\"\""));
        }
        try {
            String extensionId = this.skinIdMap.get(skinId);
            if (extensionId == null) {
                AndmoreLogger.warn((String)("The skin " + skinId + " was requested but not retrieved. It is not installed."));
                throw new SkinException(NLS.bind((String)EmulatorNLS.WARN_SkinFramework_SkinNotInstalled, (Object)skinId));
            }
            selectedSkin = (IAndroidSkin)EclipseUtils.getExecutable((String)extensionId, (String)"skinInfo");
            if (emulatorInstallDir != null) {
                selectedSkin.setSkinFilesPath(emulatorInstallDir.getAbsolutePath());
            }
        }
        catch (CoreException e) {
            AndmoreLogger.error((String)("It was not possible to load the IAndroidSkin object associated to " + skinId + " skin. Cause: " + e.getMessage()));
            throw new SkinException(NLS.bind((String)EmulatorNLS.EXC_SkinFramework_CreateIAndroidSkin, (Object)skinId));
        }
        if (selectedSkin == null) {
            AndmoreLogger.error((String)"The skin plugin is not accordant with the skin extension point specification");
            throw new SkinException(EmulatorNLS.EXC_SkinFramework_CreateIAndroidSkin);
        }
        return selectedSkin;
    }

    private void populateSkinIdMap() {
        IExtension[] skinExtensions = EclipseUtils.getInstalledPlugins((String)"org.eclipse.andmore.android.emulator.skin");
        String currentId = "";
        try {
            IExtension[] iExtensionArray = skinExtensions;
            int n = skinExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension skinExtension = iExtensionArray[n2];
                currentId = skinExtension.getUniqueIdentifier();
                IConfigurationElement[] iConfigurationElementArray = elements = skinExtension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals("skinInfo")) {
                        String extensionId = skinExtension.getUniqueIdentifier();
                        String skinId = element.getAttribute("skinId");
                        if (skinId != null) {
                            this.skinIdMap.put(skinId, extensionId);
                        } else {
                            AndmoreLogger.warn((String)"A invalid skin extension was not loaded because it did not declare its ID");
                            String title = EmulatorNLS.GEN_Warning;
                            String message = NLS.bind((String)EmulatorNLS.WARN_SkinFramework_InvalidInstalledSkinsNotLoaded, (Object)currentId);
                            EclipseUtils.showErrorDialog((String)title, (String)message);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (InvalidRegistryObjectException e) {
            AndmoreLogger.warn((String)("There are invalid skin extensions that were not loaded due to an exception. Cause: " + e.getMessage()));
            String title = EmulatorNLS.GEN_Warning;
            EclipseUtils.showErrorDialog((String)title, (String)NLS.bind((String)EmulatorNLS.WARN_SkinFramework_InvalidInstalledSkinsNotLoaded, (Object)currentId));
        }
    }
}

