/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.device;

import java.util.LinkedHashMap;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.EmulatorPlugin;
import org.eclipse.andmore.android.emulator.device.instance.AndroidDeviceInstance;
import org.eclipse.andmore.android.emulator.logic.AbstractStartAndroidEmulatorLogic;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sequoyah.device.framework.events.InstanceEvent;
import org.eclipse.sequoyah.device.framework.events.InstanceEventManager;
import org.eclipse.sequoyah.device.framework.model.IInstance;

public class AndroidDeviceUtils {
    public static synchronized void fireDummyStartTransition(AndroidDeviceInstance instance, String serialNumber) {
        boolean instanceStarted = instance.isStarted();
        boolean instanceIsStarting = instance.getStateMachineHandler().isTransitioning();
        boolean vmAlreadyUp = instance.hasDevice();
        instance.setNameSuffix(String.valueOf(serialNumber) + ", " + instance.getTarget());
        InstanceEventManager.getInstance().notifyListeners(new InstanceEvent(InstanceEvent.InstanceEventType.INSTANCE_UPDATED, (IInstance)instance));
        if (vmAlreadyUp && !instanceStarted && !instanceIsStarting) {
            AndmoreLogger.info((String)"The TmL Instance is not started/Starting, but the emulator/VM is already online. Execute a dummy start service to force a transition to start status...");
            LinkedHashMap<Class<AbstractStartAndroidEmulatorLogic.LogicMode>, AbstractStartAndroidEmulatorLogic.LogicMode> attributes = new LinkedHashMap<Class<AbstractStartAndroidEmulatorLogic.LogicMode>, AbstractStartAndroidEmulatorLogic.LogicMode>();
            attributes.put(AbstractStartAndroidEmulatorLogic.LogicMode.class, AbstractStartAndroidEmulatorLogic.LogicMode.DO_NOTHING);
            try {
                EmulatorPlugin.getStartServiceHandler().run((IInstance)instance, attributes, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                AndmoreLogger.error((String)("Failed to run the dummy start service on " + instance + " : " + e.getMessage()));
            }
        }
    }

    public static boolean isInstanceStarting(AndroidDeviceInstance androidInstance) {
        return androidInstance.getStateMachineHandler().isTransitioning();
    }
}

